function btmt.register_flower(name,def)
minetest.register_node(name, { 
    description = def.description,
    drawtype = "plantlike",
    visual_scale = def.visual_scale, 
    tiles = {def.texture},
    inventory_image = def.texture,
    wield_image = def.texture,
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
    groups = {snappy = 3, flammable = 2, flora = 1, attached_node = 1},
    sounds = default.node_sound_leaves_defaults(),
    selection_box = {
        type = "fixed",
        fixed = {-0.25, -0.5, -0.25, 0.25, 0.3, 0.25},
    },
})
end

btmt.register_flower("btmt:flame_lily", {
description = "Flame Lily",
visual_scale = 2,
texture = "flowers_flame_lily.png",
})

btmt.register_flower("btmt:foxglove", {
description = "Foxglove",
visual_scale = 2,
texture = "flowers_foxglove_purple.png",
})


btmt.register_flower("btmt:lantana", {
description = "Lantana",
visual_scale = 1,
texture = "flowers_lantana.png",
})

btmt.register_flower("btmt:lavender", {
description = "Lavender",
visual_scale = 2,
texture = "flowers_lavender_flower.png",
})

minetest.register_node("btmt:clover", { 
    description = "Clover",
    drawtype = "nodebox",
    --visual_scale = def.visual_scale, 
    tiles = {"clover_top.png","clover_side.png"},
    --inventory_image = "",
   -- wield_image = "",
    paramtype = "light",
    use_texture_alpha = "clip",
    sunlight_propagates = true,
    walkable = false,
    buildable_to = true,
    groups = {snappy = 3, flammable = 2, flora = 1, attached_node = 1},
    sounds = default.node_sound_leaves_defaults(),
     node_box = {
        type = "fixed",
        fixed = {
          {-0.3, -0.4, -0.3, 0.3, -0.4, 0.3}, 
          {-0.002, -0.5, -0.04, 0.002, -0.41, 0.04},
          {-0.04, -0.5, -0.002, 0.04, -0.41, 0.002}, 
            
        },
    },
})

function btmt.register_decoration(node_p,biome_p,deco_p)
minetest.register_decoration({
    deco_type = "simple",
    place_on = {node_p},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {biome_p},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.004,
    y_max = 200,
    y_min = 1,
    decoration = deco_p,
})
end

btmt.register_decoration("default:dirt_with_rainforest_litter","rainforest","btmt:flame_lily")
btmt.register_decoration("default:dirt_with_grass","deciduous_forest","btmt:foxglove")
btmt.register_decoration("default:dirt_with_grass","grassland","btmt:lantana")
btmt.register_decoration("default:dirt_with_grass","grassland","btmt:lavender")
btmt.register_decoration("default:dirt_with_grass","grassland","btmt:clover")

--- LARGES MUSHROOMS : =============================================================================
minetest.register_node("btmt:large_red_mushrooms", {
	description = "Large Red Mushroom",
	tiles = {"large_red_mushrooms.png"},
	inventory_image = "large_red_mushrooms.png",
	wield_image = "large_red_mushrooms.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	visual_scale = 1.5,
	groups = {mushroom = 1, snappy = 3, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(-5),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	}
})

minetest.register_node("btmt:large_brown_mushrooms", {
	description = "Large Brown Mushroom",
	tiles = {"large_brown_mushrooms.png"},
	inventory_image = "large_brown_mushrooms.png",
	wield_image = "large_brown_mushrooms.png",
	drawtype = "plantlike",
	paramtype = "light",
	sunlight_propagates = true,
	walkable = false,
	buildable_to = true,
	visual_scale = 1.5,
	groups = {mushroom = 1, food_mushroom = 1,snappy = 3, attached_node = 1, flammable = 1},
	sounds = default.node_sound_leaves_defaults(),
	on_use = minetest.item_eat(1),
	selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	}
})

local function l_mushrooms_deco(n_mush)
minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:dirt_with_grass", "default:dirt_with_coniferous_litter","default:tree","default:aspen_tree"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"deciduous_forest", "coniferous_forest"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.004,
    y_max = 200,
    y_min = 1,
    decoration = n_mush,
})
end

l_mushrooms_deco("btmt:large_red_mushrooms")
l_mushrooms_deco("btmt:large_brown_mushrooms")

-- RECIPES : ==============================================
core.register_craft({
    --type = "shaped",
    output = "dye:orange 4",
    recipe = {
        {"","",""},
        {"","btmt:flame_lily",""},
        {"","",""}
    }
})

core.register_craft({
    --type = "shaped",
    output = "dye:pink 4",
    recipe = {
        {"","",""},
        {"","btmt:foxglove",""},
        {"","",""}
    }
})

core.register_craft({
    --type = "shaped",
    output = "dye:magenta 4",
    recipe = {
        {"","",""},
        {"","btmt:lantana",""},
        {"","",""}
    }
})

core.register_craft({
    --type = "shaped",
    output = "dye:violet 4",
    recipe = {
        {"","",""},
        {"","btmt:lavender",""},
        {"","",""}
    }
})

