-- CORAIS : ===================================================================
core.register_node("btmt:tubular_coral", {
	description = "Tubular Coral",
	drawtype = "plantlike_rooted",
	waving = 1,
	paramtype = "light",
	tiles = {"tubular_coral_block.png"},
	special_tiles = {{name = "tubular_coral.png", tileable_vertical = true}},
	inventory_image = "tubular_coral.png",
	wield_image = "tubular_coral.png",
	groups = {snappy = 3},
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "default:coral_skeleton",
	node_placement_prediction = "",
	sounds = default.node_sound_stone_defaults({
		dig = {name = "default_dig_snappy", gain = 0.2},
		dug = {name = "default_grass_footstep", gain = 0.25},
	}),
	
	on_place = function(itemstack, placer, pointed_thing)
		
		local above = core.get_node(pointed_thing.above)
		local below = core.get_node(pointed_thing.under)
		if above.name == "default:water_source" and below.name == "default:coral_skeleton" then
		  core.set_node(pointed_thing.under, {name = "btmt:tubular_coral"})
		  itemstack:take_item()
		else
		end
		return itemstack
	  end,

	after_destruct  = function(pos, oldnode)
		core.set_node(pos, {name = "default:coral_skeleton"})
	end,
})

core.register_node("btmt:staghorn_coral", {
	description = "Staghorn Coral",
	drawtype = "plantlike_rooted",
	waving = 1,
	paramtype = "light",
	tiles = {"Staghorn_coral_block.png"},
	special_tiles = {{name = "Staghorn_coral.png", tileable_vertical = true}},
	inventory_image = "Staghorn_coral.png",
	wield_image = "Staghorn_coral.png",
	groups = {snappy = 3},	
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "default:coral_skeleton",
	node_placement_prediction = "",
	sounds = default.node_sound_stone_defaults({
		dig = {name = "default_dig_snappy", gain = 0.2},
		dug = {name = "default_grass_footstep", gain = 0.25},
	}),

	on_place = function(itemstack, placer, pointed_thing)
		
		local above = core.get_node(pointed_thing.above)
		local below = core.get_node(pointed_thing.under)
		if above.name == "default:water_source" and below.name == "default:coral_skeleton" then
		  core.set_node(pointed_thing.under, {name = "btmt:staghorn_coral"})
		  itemstack:take_item()
		else
		end
		return itemstack
	  end,

	after_destruct  = function(pos, oldnode)
		core.set_node(pos, {name = "default:coral_skeleton"})
	end,
})

core.register_node("btmt:fire_coral", {
	description = "Fire Coral",
	drawtype = "plantlike_rooted",
	waving = 1,
	paramtype = "light",
	tiles = {"fire_coral_block.png"},
	special_tiles = {{name = "fire_coral.png", tileable_vertical = true}},
	inventory_image = "fire_coral.png",
	wield_image = "fire_coral.png",
	groups = {snappy = 3},
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "default:coral_skeleton",
	node_placement_prediction = "",
	sounds = default.node_sound_stone_defaults({
		dig = {name = "default_dig_snappy", gain = 0.2},
		dug = {name = "default_grass_footstep", gain = 0.25},
	}),

	on_place = function(itemstack, placer, pointed_thing)
		
		local above = core.get_node(pointed_thing.above)
		local below = core.get_node(pointed_thing.under)
		if above.name == "default:water_source" and below.name == "default:coral_skeleton" then
		  core.set_node(pointed_thing.under, {name = "btmt:fire_coral"})
		  itemstack:take_item()
		else	
		end
		return itemstack
	  end,

	after_destruct  = function(pos, oldnode)
		core.set_node(pos, {name = "default:coral_skeleton"})
	end,
})

core.register_node("btmt:bubble_coral", {
	description = "Bubble Coral",
	drawtype = "plantlike_rooted",
	waving = 1,
	paramtype = "light",
	tiles = {"bubble_coral_block.png"},
	special_tiles = {{name = "bubble_coral.png", tileable_vertical = true}},
	inventory_image = "bubble_coral.png",
	wield_image = "bubble_coral.png",
	groups = {snappy = 3},
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "default:coral_skeleton",
	node_placement_prediction = "",
	sounds = default.node_sound_stone_defaults({
		dig = {name = "default_dig_snappy", gain = 0.2},
		dug = {name = "default_grass_footstep", gain = 0.25},
	}),

	on_place = function(itemstack, placer, pointed_thing)
		
		local above = core.get_node(pointed_thing.above)
		local below = core.get_node(pointed_thing.under)
		if above.name == "default:water_source" and below.name == "default:coral_skeleton" then
		  core.set_node(pointed_thing.under, {name = "btmt:bubble_coral"})
		  itemstack:take_item()
		else
		end
		return itemstack
	  end,


	after_destruct  = function(pos, oldnode)
		core.set_node(pos, {name = "default:coral_skeleton"})
	end,
})

core.register_node("btmt:brain_coral", {
	description = "Brain Coral",
	drawtype = "plantlike_rooted",
	waving = 1,
	paramtype = "light",
	tiles = {"brain_coral_block.png"},
	special_tiles = {{name = "brain_coral.png", tileable_vertical = true}},
	inventory_image = "brain_coral.png",
	wield_image = "brain_coral.png",
	groups = {snappy = 3},
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "default:coral_skeleton",
	node_placement_prediction = "",
	sounds = default.node_sound_stone_defaults({
		dig = {name = "default_dig_snappy", gain = 0.2},
		dug = {name = "default_grass_footstep", gain = 0.25},
	}),

	on_place = function(itemstack, placer, pointed_thing)
		
		local above = core.get_node(pointed_thing.above)
		local below = core.get_node(pointed_thing.under)
		if above.name == "default:water_source" and below.name == "default:coral_skeleton" then
		  core.set_node(pointed_thing.under, {name = "btmt:brain_coral"})
		  itemstack:take_item()
		else
		end
		return itemstack
	  end,


	after_destruct  = function(pos, oldnode)
		core.set_node(pos, {name = "default:coral_skeleton"})
	end,
})

-- CORAIS BLOCK : ==============================================================
core.register_node("btmt:tubular_coral_block", {
	description = "Tubular Coral Block",
	tiles = {"tubular_coral_block.png"},
	groups = {cracky = 3},
	drop = "default:coral_skeleton",
	sounds = default.node_sound_stone_defaults(),
})


core.register_node("btmt:staghorn_coral_block", {
	description = "Staghorn Coral Block",
	tiles = {"Staghorn_coral_block.png"},
	groups = {cracky = 3},
	drop = "default:coral_skeleton",
	sounds = default.node_sound_stone_defaults(),
})


core.register_node("btmt:fire_coral_block", {
	description = "Fire Coral Block",
	tiles = {"fire_coral_block.png"},
	groups = {cracky = 3},
	drop = "default:coral_skeleton",
	sounds = default.node_sound_stone_defaults(),
})


core.register_node("btmt:bubble_coral_block", {
	description = "Bubble Coral Block",
	tiles = {"bubble_coral_block.png"},
	groups = {cracky = 3},
	drop = "default:coral_skeleton",
	sounds = default.node_sound_stone_defaults(),
})


core.register_node("btmt:brain_coral_block", {
	description = "Brain Coral Block",
	tiles = {"brain_coral_block.png"},
	groups = {cracky = 3},
	drop = "default:coral_skeleton",
	sounds = default.node_sound_stone_defaults(),
})

--- CORIS DECORAÇÃO : ==============================================================
core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/coral_bubble.mts",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
        "savanna_shore",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/corals_brain.mts",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
        "savanna_shore",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/corals_fire.mts",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
        "savanna_shore",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/corals_tubular.mts",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
        "savanna_shore",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/staghorn_corals.mts",
    rotation = "random",
})

core.register_decoration({
    deco_type = "schematic",
    place_on = {"default:sand"},
    sidelen = 16,
    fill_ratio = 0.002,
    biomes = {
        "grassland_ocean",
        "desert_ocean",
        "savanna_ocean",
        "rainforest_ocean",
        "sandstone_desert_ocean",
        "savanna_shore",
    },
    flags = "place_center_x,place_center_z,force_placement",
    y_max = -7,
    y_min = -30,
    place_offset_y=1,
    schematic = core.get_modpath("btmt").."/schematics/ocean/corais.mts",
    rotation = "random",
})
----- SEAGRASS
core.register_node("btmt:seagrass", {
	description = "Sea Grass",
	tiles = {"seagrass.png"},
	inventory_image = "seagrass.png",
	wield_image = "seagrass.png",
	drawtype = "plantlike",
	paramtype = "light",
	visual_scale = 2.0,
	sunlight_propagates = true,
	walkable = false,
	drops = "",
	groups = {snappy = 3,flora = 1,grass = 1},
        sounds = default.node_sound_leaves_defaults(),			
  	selection_box = {type = "fixed",fixed =  {-0.3, -0.5, -0.3, 0.3, 0.5,0.3}},	
	node_box = {type = "fixed", fixed =  {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16}},		  
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"default:sand"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {
        "taiga_ocean",
	"snowy_grassland_ocean",
	"grassland_ocean",
	"coniferous_forest_ocean",
	"deciduous_forest_ocean",
	"sandstone_desert_ocean",
	"cold_desert_ocean",
    },
    flags = "force_placement,all_floors",
    fill_ratio = 0.009,
    y_max = -5,
    y_min = -30,
    decoration ="btmt:seagrass",
})
