-- JUNGLE/CATTAIL:
core.register_node("btmt:cattail", {
    description = "Cattail",
    drawtype = "plantlike",
    tiles = {"cattail.png"},
    visual_scale = 1.5,
    paramtype = "light",
    sunlight_propagates = true,
    liquids_pointable = true,
    walkable = false,   
    groups = {snappy = 3, cattail = 1,flora = 1,flammable = 1},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",
    selection_box = {
        type = "fixed",
        fixed = {-0.2,-0.5,-0.2,0.2,0.2,0.2},
    },  	
})

-- swmp: 9777676251462126404
minetest.register_decoration({
    name = "btmt:cattail_juungle",
    deco_type = "simple",
    place_on = {"default:dirt_with_rainforest_litter"},
    noise_params = {
        offset = 0,                     
	scale = 3,                      
	spread = {x = 5, y = 5, z = 5}, 
	seed = 12345,                   
	octaves = 1,                    
	persist = 0.5,                  
    },
    biomes = {"rainforest_swamp","rainforest"},
    y_max = 200,
    y_min = 1,
    decoration = "btmt:cattail",
    spawn_by = {"default:water_source", "default:river_water_source"},
    num_spawn_by = 1,
})

--[[
minetest.register_decoration({
    name = "btmt:cattail_swamp",
    deco_type = "simple",
    place_on = {"default:dirt"},
    noise_params = {
        offset = 0,                     
	scale = 3,                      
	spread = {x = 5, y = 5, z = 5}, 
	seed = 12345,                   
	octaves = 1,                    
	persist = 0.5,                  
    },
    biomes = {"rainforest_swamp","rainforest"},
    y_max = 1,
    y_min = -1,
    decoration = "btmt:cattail",
    spawn_by = {"default:dirt_with_rainforest_litter", "default:dirt"},
    num_spawn_by = 1,
})
]]

--[[
core.register_node("btmt:vine", {
    description = "vine",
    drawtype = "nodebox",
    tiles = {"ethereal_vine.png"},  
    sunlight_propagates = true,
    use_texture_alpha = "clip", 
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,   
    groups = {snappy = 3, flammable = 3, flora = 1, grass = 1, marram_grass = 1},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",
    node_box = {
        type = "fixed",
        fixed = {-0.5, -0.5, 0.45, 0.5, 0.5, 0.5},
    },  
    
    on_place = minetest.rotate_node,	
})
]]

-- DESERT/CACTUS FLOWER :
core.register_node("btmt:cactus_flower", {
    description = "Cactus Flower",
    drawtype = "plantlike",
    tiles = {"Cactus_Flower.png"},
    paramtype = "light",
    sunlight_propagates = true,
    liquids_pointable = true,
    walkable = false,   
    groups = {snappy = 3, flora = 1, flammable = 1},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",
    selection_box = {
        type = "fixed",
        fixed = {-0.5,-0.5,-0.5,0.5,-0.45,0.5},
    },
    	
})

core.register_decoration({ 
    name = "btmt:cactus_w_flower",
    deco_type = "schematic",
    place_on = { "default:desert_sand"},
    biomes = {"desert"},
    sidelen = 16,
    fill_ratio = 0.0001,
    y_max = 200,
    y_min = 0,
    schematic = minetest.get_modpath("btmt") .. "/schematics/cactus_w_flower.mts",
    place_offset_y = 0,
    flags = "place_center_x,place_center_z,all_floors",
    rotation = "random",
})

core.register_decoration({ 
    name = "btmt:small_cactus_w_flower",
    deco_type = "schematic",
    place_on = { "default:desert_sand"},
    biomes = {"desert"},
    sidelen = 16,
    fill_ratio = 0.0001,
    y_max = 200,
    y_min = 0,
    schematic = minetest.get_modpath("btmt") .. "/schematics/small_cactus_w_flower.mts",
    place_offset_y = 0,
    flags = "place_center_x,place_center_z,all_floors",
    rotation = "random",
})

-- TAIGA/GRASS :
core.register_node("btmt:frosted_grass", {
    description = "Frosted Grass",
    drawtype = "plantlike",
    tiles = {"frosted_grass.png"},  
    visual_scale = 1.5,  
    paramtype = "light",
    sunlight_propagates = true,
    walkable = false,   
    groups = {snappy = 3, flammable = 3, flora = 1, grass = 1, marram_grass = 1,attached_node = 1},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",
    selection_box = {
        type = "fixed",
        fixed = {-0.4,-0.5,-0.4,0.4,0.005,0.4},
    },  	
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:dirt_with_snow"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"taiga"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.005,
    y_max = 200,
    y_min = 1,
    decoration = "btmt:frosted_grass",
})

-- DECIDUOUS
core.register_node("btmt:dead_fallen_leaves", {
    description = "Dead Fallen Leaves",
    tiles = {"dead_fallen_leaves.png","dead_fallen_leaves.png","nodes_blank.png"},
    drawtype = "nodebox",
    paramtype = "light",
    use_texture_alpha = "clip",
    groups = {dig_immediate=3,flora=1},
    drops = "btmt:dead_fallen_leaves",
    node_box = {
        type = "fixed",
        fixed = {
            {-0.5, -0.5, -0.5, 0.5, -0.49, 0.5},
            
        },
    }
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:dirt_with_grass"},
    sidelen = 16,
    biomes = {"deciduous_forest"},
    fill_ratio = 0.05,
    y_max = 200,
    y_min = 0,
    spawn_by = {"default:aspen_tree", "default:tree"},
    check_offset = 1,
    decoration = "btmt:dead_fallen_leaves",
})

---- fairy helmet
core.register_node("btmt:fair_helmet", {
    description = "fair_helmet",
    drawtype = "plantlike",
    tiles = {"fair_helmet.png"},
    paramtype = "light",
    sunlight_propagates = true,
    liquids_pointable = true,
    walkable = false, 
    light_source = 4,  
    groups = {snappy = 3,flora = 1},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",
    selection_box = {
        type = "fixed",
        fixed = {-0.5,-0.5,-0.5,0.5,-0.45,0.5},
    },   	
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:dirt_with_rainforest_litter"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"rainforest","icesheet"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.009,
    y_max = 5,
    y_min = 0,
    decoration = "btmt:fair_helmet",
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:stone"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"underground"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.009,
    y_max = -2,
    y_min = -200,
    decoration = "btmt:fair_helmet",
})

-- mos :
minetest.register_node("btmt:moss", {
	description = "Moss",
	inventory_image = "moss_inv.png",
	wield_image = "moss_inv.png",
	drawtype = "mesh",
	mesh = "vegetation_overlap.obj",
	tiles = {"moss.png"},
	groups = {snappy = 3,plants = 1},
        --drop ="" ,
	sounds = default.node_sound_leaves_defaults(),       
        paramtype = "light",
        use_texture_alpha = "clip",
	walkable = false,		
	selection_box = {type = "fixed",fixed = {-0.5, -0.5, -0.5, 0.5, -0.45, 0.5}},	
	node_box = {type = "fixed", fixed = {-0.5, -0.5, -0.5, 0.5, -0.45, 0.5}},	
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:mossycobble","default:tree","default:aspen_tree"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"coniferous_forest","deciduous_forest","grassland","rainforest","underground"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.5,
    y_max = 200,
    y_min = -500,
    decoration = "btmt:moss",
})

minetest.register_node("btmt:tallgrass", {
	description = "Tallgrass",
	tiles = {"tallgrass.png"},
	inventory_image = "tallgrass.png",
	wield_image = "tallgrass.png",
	drawtype = "plantlike",
	paramtype = "light",
	visual_scale = 2.0,
	sunlight_propagates = true,
	walkable = false,
	groups = {snappy = 3,flammable = 1},
        drop = "btmt:tallgrass",
        sounds = default.node_sound_leaves_defaults(),	
  	selection_box = {type = "fixed",fixed =  {-0.3, -0.5, -0.3, 0.3, 0.5,0.3}},	
	node_box = {type = "fixed",fixed =  {-6 / 16, -0.5, -6 / 16, 6 / 16, 0.5, 6 / 16}},  
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:mossycobble","default:dirt_with_grass"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"coniferous_forest","deciduous_forest","grassland","rainforest","underground"},
    flags = "place_center_x,place_center_z,force_placement,all_floors",
    fill_ratio = 0.005,
    y_max = 200,
    y_min = -500,
    decoration = "btmt:tallgrass",
})

-- VINES SIMPLES : 7860769037114009884
minetest.register_node("btmt:vine", {
	description = "Vine",
	drawtype = "plantlike",
	tiles = {"btmt_vine.png"},
	inventory_image = "btmt_vine.png",		
	walkable = false,
	climbable = true,
	paramtype = "light",
	sunlight_propagates = true,
	--visual_scale = 1.5,
	range = 6.0,	
	groups = {snappy = 3},	
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.2, -0.5, -0.2, 0.2, 0.5, 0.2},
		},
	},
	sounds = default.node_sound_stone_defaults(),
})

core.register_decoration({ 
    name = "btmt:vine_l",
    deco_type = "schematic",
     place_on = {"default:jungleleaves","default:mossycobble"},
    biomes = {"rainforest"},
    sidelen = 16,
    fill_ratio = 0.001,
    y_max = 200,
    y_min = 1,
    schematic = minetest.get_modpath("btmt") .. "/schematics/vine_long.mts",
    place_offset_y = 1,
    flags = "place_center_x,place_center_z,all_ceilings",
    rotation = "random",
})

core.register_decoration({ 
    name = "btmt:vine_m",
    deco_type = "schematic",
     place_on = {"default:jungleleaves","default:mossycobble"},
    biomes = {"rainforest"},
    sidelen = 16,
    fill_ratio = 0.05,
    y_max = 200,
    y_min = -32,
    schematic = minetest.get_modpath("btmt") .. "/schematics/vine_m.mts",
    place_offset_y = 1,
    flags = "place_center_x,place_center_z,all_ceilings",
    rotation = "random",
})

core.register_decoration({ 
    name = "btmt:vine_p",
    deco_type = "schematic",
     place_on = {"default:jungleleaves","default:mossycobble"},
    biomes = {"rainforest","rainforest_swamp"},
    sidelen = 16,
    fill_ratio = 0.001,
    y_max = 200,
    y_min = -32,
    schematic = minetest.get_modpath("btmt") .. "/schematics/vine_p.mts",
    place_offset_y = 1,
    flags = "place_center_x,place_center_z,all_ceilings",
    rotation = "random",
})

-- DUCKWEED :
core.register_node("btmt:duckweed", {
    description = "Duckweed",
    drawtype = "nodebox",
    tiles = {"duckweed.png"},
    paramtype = "light",
    sunlight_propagates = true,
    liquids_pointable = true,
    walkable = false,   
    use_texture_alpha = "clip",
    groups = {snappy = 3},
    sounds = default.node_sound_leaves_defaults(),	
    drops = " ",

   node_box = {
	type = "fixed",
	fixed = {
	{-0.5,-0.5,-0.5,0.5,-0.49,0.5}
	}
    },
    	
})

minetest.register_decoration({
		name = "btmt:duckweed_swamp",
		deco_type = "simple",
		place_on = {"default:dirt"},
		sidelen = 16,
		noise_params = {
			offset = -0.12,
			scale = 0.3,
			spread = {x = 100, y = 100, z = 100},
			seed = 34,
			octaves = 3,
			persist = 1.2
		},
		biomes = {"rainforest_swamp"},
		y_max = 0,
		y_min = 0,
		decoration = "btmt:duckweed",
		param2 = 0,
		param2_max = 3,
		place_offset_y = 1,
})

