mobs:register_mob("btmt:pig", {
	stepheight = 0.6,
	type = "animal",
	passive = true,
	attack_type = "dogfight",
	group_attack = true,
	owner_loyal = true,
	attack_npcs = false,
	reach = 2,
	damage = 2, attack_chance = 95,
	hp_min = 10,
	hp_max = 15,
	armor = 100,
	collisionbox = {-0.4, -0.01, -0.4, 0.4, 0.95, 0.4},
	visual = "mesh",
	mesh = "btmt_pig.glb",
	textures = {{"btmt_pig.png"}},
	visual_size = {x = 10, y = 10},
	makes_footstep_sound = true,
	sounds = {
		random = "mobs_pig",
		attack = "mobs_pig_angry"
	},
	walk_velocity = 2,
	run_velocity = 3,
	jump = true,
	jump_height = 6,
	pushable = true,
	follow = {"default:apple", "farming:potato"},
	view_range = 10,
	drops = {
		{name = "mobs:meat", chance = 1, min = 1, max = 3}
	},
	water_damage = 0.01,
	lava_damage = 5,
	light_damage = 0,
	fear_height = 2,
	animation = {
		speed_normal = 5,
		stand_start = 1, stand_end = 19,
		walk_start = 24, walk_end = 35,
		punch_start = 40, punch_end = 52,
		--die_start = 1, die_end = 2, die_speed = 1,
		die_loop = false, die_rotate = true
	},

	on_rightclick = function(self, clicker)

		if mobs:feed_tame(self, clicker, 8, true, true) then return end
		if mobs:protect(self, clicker) then return end
		if mobs:capture_mob(self, clicker, 0, 5, 50, false, nil) then return end
	end
})

if not mobs.custom_spawn_animal then

	local spawn_on = {"default:dirt_with_grass", "default:dry_dirt_with_dry_grass"}
	local spawn_by = {"group:grass"}

	if core.get_modpath("ethereal") then
		spawn_on = {"ethereal:mushroom_dirt"}
		spawn_by = {"flowers:mushroom_brown", "flowers:mushroom_red"}
	end

	mobs:spawn({
		name = "btmt:pig",
		nodes = spawn_on,
		neighbors = spawn_by,
		min_light = 14,
		interval = 60,
		chance = 8000,
		min_height = 0,
		max_height = 200,
		day_toggle = true
	})
end

mobs:register_egg("btmt:pig", "Pig", "btmt_pig_inv.png")

