local loots_urn = {
	{name = "default:torch", chance = 1, count = 3},
        {name = "default:apple", chance =2, count = 5},
        {name = "default:coal_lump", chance = 1, count = 3},
        {name = "default:steel_ingot", chance =1, count = 2},
        {name = "farming:bread", chance =1, count =5},        
        {name = "default:gold_ingot", chance =1, count = 1},
        {name = "default:tin_ingot", chance =1, count = 1},       
        {name = "default:bronze_ingot", chance =1, count = 2},
        {name = "default:obsidian_shard", chance = 1, count = 2},
        {name = "default:paper", chance = 1, count = 3},                			
}

minetest.register_node("btmt:urns_brown", {
	description = "Brown Urn",
	drawtype = "mesh",
	mesh = "urns.obj",
	tiles = {"urns_brown.png"},
	groups = {dig_immediate=3,urns=1},
        drop =" " ,
        
        paramtype = "light",
        use_texture_alpha = "clip",
		walkable = true, 
		selection_box = {
		type = "fixed",
		fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16},
	},
	
	node_box = {type = "fixed", fixed = {-4 / 16, -0.5, -4 / 16, 4 / 16, -1 / 16, 4 / 16}},
		
	after_dig_node = function(pos,node,digger)
           pos.y = pos.y + 0.5
           local item = loots_urn[math.random(1, #loots_urn)]
	   minetest.add_item(pos,item)
	   minetest.sound_play("break_vase", {pos = pos,gain = 1.0,max_hear_distance = 5,})	  
	end,	       	
})

minetest.register_decoration({
    deco_type = "simple",
    place_on = {"default:stone","default:mossycobble","default:ice","default:desert_sandstone"},
    sidelen = 16,
    place_offset_y = 0,
    biomes = {"underground","rainforest","icesheet","desert"},
    flags = "force_placement,all_floors",
    fill_ratio = 0.004,
    y_max = -5,
    y_min = -2000,
    decoration ="btmt:urns_brown",
})
