core.register_node("oceanblock:supply_crate", {
    description = "Supply Crate",
    tiles = {"Crate.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},
    
    drop = {
        max_items = 2,
        items = {
            {items = {'default:apple 1'}, rarity = 1},
            {items = {'default:wood 2'}, rarity = 2},
            {items = {'farming:string 2'}, rarity = 2},
            {items = {'farming:bread 1'}, rarity = 4},
        }
    },
          
})

-- Hook :
core.register_tool("oceanblock:hook", { 
    description = "Hook \n[Click on the item to pick it up]\n",
    inventory_image = "oceanblock_hook.png",
    range = 10,
    
    on_secondary_use = function (itemstack, user, pointed_thing) 
     itemstack:add_wear_by_uses(3*40)
     return itemstack
    end
})

core.register_craft({
	output = "oceanblock:hook",
	recipe = {
		{"default:steel_ingot","default:steel_ingot","default:steel_ingot"},
		{"","farming:string",""},
		{"","farming:string",""},
	}
})

-- crowbar
core.register_tool("oceanblock:crowbar", { 
    description = "Crowbar",
    inventory_image = "crowbar.png",  
})

core.register_craft({
	output = "oceanblock:crowbar",
	recipe = {
		{"","","default:steel_ingot"},
		{"","dye:red",""},
		{"default:steel_ingot","",""},
	}
})

-- FLINT TOOLS :
core.register_tool("oceanblock:flint_spear", {
	description = "Flint Spear",
	inventory_image = "flint_spear.png",
	range = 3,
	tool_capabilities = {
		full_punch_interval = 1.2,
		max_drop_level=0,
		groupcaps={
			snappy={times={[2]=1.6, [3]=0.40}, uses=15, maxlevel=1},
		},
		damage_groups = {fleshy=3},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {sword = 1},	
})

core.register_craft({
	output = "oceanblock:flint_spear",
	recipe = {
		{"","","default:flint"},
		{"","default:stick",""},
		{"default:stick","",""},
	}
})

core.register_tool("oceanblock:flint_hatchet", {
	description = "Flint Hatchet",
	inventory_image = "flint_axe.png",
	tool_capabilities = {
		full_punch_interval = 1.0,
		max_drop_level=0,
		groupcaps={
			choppy = {times={[2]=2.00, [3]=1.30}, uses=10, maxlevel=1},
		},
		damage_groups = {fleshy=2},
	},
	sound = {breaks = "default_tool_breaks"},
	groups = {axe = 1, flammable = 2}
})

core.register_craft({
     output = "oceanblock:flint_hatchet",
     recipe = {
	{"default:flint", "default:flint",""},
	{"default:flint","group:stick",""},
	{"","group:stick",""}
    }
})
-- PEDRINHAS : ============================================================================
core.register_craftitem("oceanblock:pebbles", {
    description = "Pebble",
    inventory_image = "pebble.png"
})

core.register_craft({
	output = "default:cobble",
	recipe = {
		{"oceanblock:pebbles","oceanblock:pebbles"},
		{"oceanblock:pebbles","oceanblock:pebbles"},
	}
})

core.register_craftitem("oceanblock:pebble_desert", {
    description = "Desert Pebble",
    inventory_image = "pebble_desert.png"
})

core.register_craft({
	output = "default:desert_cobble",
	recipe = {
		{"oceanblock:pebble_desert","oceanblock:pebble_desert"},
		{"oceanblock:pebble_desert","oceanblock:pebble_desert"},
	}
})

core.register_craftitem("oceanblock:pebble_silver_sand", {
    description = "Silver Sandstone Pebble",
    inventory_image = "pebble_silver_sand.png"
})

core.register_craft({
	output = "default:silver_sandstone",
	recipe = {
		{"oceanblock:pebble_silver_sand","oceanblock:pebble_silver_sand"},
		{"oceanblock:pebble_silver_sand","oceanblock:pebble_silver_sand"},
	}
})

core.register_craftitem("oceanblock:pebble_desert_sandstone", {
    description = "Desert Sandstone Pebble",
    inventory_image = "pebble_desert_sandstone.png"
})

core.register_craft({
	output = "default:desert_sandstone",
	recipe = {
		{"oceanblock:pebble_desert_sandstone","oceanblock:pebble_desert_sandstone"},
		{"oceanblock:pebble_desert_sandstone","oceanblock:pebble_desert_sandstone"},
	}
})

-- Rede :====================================================================================
core.register_craftitem("oceanblock:cloth_mesh", {
    description = "Cloth Mesh",
    inventory_image = "cloth_mesh.png"
})

core.register_craft({
	output = "oceanblock:cloth_mesh",
	recipe = {
		{"group:stick","farming:string","group:stick"},
		{"farming:string","farming:string","farming:string"},
		{"group:stick","farming:string","group:stick"},
	}
})

-- chunk:
core.register_craftitem("oceanblock:tin_chunk", {
    description = "Tin Chunk",
    inventory_image = "tin_chunk.png"
})

core.register_craftitem("oceanblock:copper_chunk", {
    description = "Copper Chunk",
    inventory_image = "copper_chunk.png"
})


core.register_craftitem("oceanblock:gold_chunk", {
    description = "Gold Chunk",
    inventory_image = "gold_chunk.png"
})

core.register_craftitem("oceanblock:iron_chunk", {
    description = "Iron Chunk",
    inventory_image = "iron_chunk.png"
})

core.register_craftitem("oceanblock:tiny_coal", {
    description = "Tiny Coal",
    inventory_image = "tiny_coal.png"
})

core.register_craftitem("oceanblock:diamond_chunk", {
    description =  "Diamond Chunk",
    inventory_image = "diamond_chunk.png"
})

local function craft_lumps (output,material)
core.register_craft({
	output = output,
	recipe = {
		{material,material},
		{material,material},
	}
})
end

craft_lumps ("default:tin_lump","oceanblock:tin_chunk")
craft_lumps ("default:copper_lump","oceanblock:copper_chunk")
craft_lumps ("default:gold_lump","oceanblock:gold_chunk")
craft_lumps ("default:iron_lump","oceanblock:iron_chunk")
craft_lumps ("default:coal_lump","oceanblock:tiny_coal")
craft_lumps ("default:diamond","oceanblock:diamond_chunk")

core.register_craftitem("oceanblock:cast_steel_ingot", {
    description = "Cast steel ingot",
    inventory_image = "default_steel_ingot.png^[colorize:#000000:190"
})

core.register_craft({
	type = "cooking",
	output = "oceanblock:cast_steel_ingot",
	recipe = "default:steel_ingot",
})

core.register_craftitem("oceanblock:dried_kelp", {
    description = "Dried Kelp",
    inventory_image = "default_kelp.png^[colorize:#24160d:190"
})

core.register_craft({
	type = "cooking",
	output = "oceanblock:dried_kelp",
	recipe = "default:sand_with_kelp",
})

core.register_craftitem("oceanblock:oceanite", {
    description = "Oceanite",
    inventory_image = "oceanite.png"
})
----------  ENTIDADES NODES : =====================================================================
local function register_item_entity(id,drop)
    core.register_entity(id, {
        physical = true,
	collide_with_objects = true,
	collisionbox = {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	visual = "wielditem",
	visual_size = {x=0.5, y=0.5},
	textures = {drop},
        automatic_rotate = 1,
        
        on_activate = function(self)
            core.after(10, function()
                if self.object then
                    self.object:remove()
                end
            end)   
        end,
        
        on_rightclick = function(self, clicker)
            local wielded = clicker:get_wielded_item()
            local name = wielded:get_name()
            local pname = clicker:get_player_name() 
            if name == "" or name == "oceanblock:hook" then
                local inv = clicker:get_inventory()
                if inv then
                    inv:add_item("main", drop)
                    self.object:remove()
                    awards.unlock(pname,"supply_crate") 
                end
            else
              core.chat_send_player(clicker:get_player_name(),core.colorize("#d00d21","Use a hook to pick it up or empty hands"))
            end
        end,
    })
end

register_item_entity("oceanblock:supply_crate_en", "oceanblock:supply_crate")


