-- LOOTS : ====================================================================================================================
local ocean_loots  ={
"bonemeal:bonemeal 2",
"oceanblock:tiny_coal",
"default:copper_lump ",
"default:gold_lump",
"default:ice",
"default:book",
"default:stick",
"default:paper",
"pixelfurniture:lantern",
"marinaramobs:raw_exotic_fish",
"default:diamond",
"default:iron_lump",
"oceanblock:oceanite",
"marinaramobs:raw_exotic_fish",
}

core.register_node("oceanblock:ocean_loot", {
	description = "Ocean Loot",
	tiles = {
		"default_chest_top.png",
		"default_chest_top.png",
		"default_chest_side.png",
		"default_chest_side.png",
		"default_chest_side.png",
		"default_chest_front.png",
	},
	
	paramtype = "light",
	paramtype2 = "facedir",
	sounds = default.node_sound_wood_defaults(),
	groups = {choppy = 2, oddly_breakable_by_hand = 2},
	drop = "default:chest",	
	
	selection_box = {
		type = "fixed",
		fixed = {-0.4, -0.5, -0.4, 0.4, 0.5, 0.4},
	},
	
	node_box = {
		type = "fixed", 
		fixed = {-0.4, -0.5, -0.4, 0.4, 0.5, 0.4},
	},
	
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
             local meta = core.get_meta(pos)   
	     local inv = meta:get_inventory()   
	     local p_name = clicker:get_player_name()
	     local lpos = pos.x .. "," .. pos.y .. "," .. pos.z
	     local wielded = clicker:get_wielded_item()
             local name = wielded:get_name()
             
             if name ~= "oceanblock:crowbar" then
               core.chat_send_player(clicker:get_player_name(),core.colorize("#d00d21","You need a crowbar to open it."))
               return
             end

	     core.sound_play("default_chest_open", {pos = pos,gain = 1.0,max_hear_distance = 5,})

             if meta:get_string("opened") ~= "true"  then
                inv:set_size("main", 8*4)
	     
	      	if inv:is_empty("main") then	      	   	   	       
	          for i = 1,32 do 
		    local item = ocean_loots[math.random(1, #ocean_loots)]
		    local stack =math.random(1,32) 
                    inv:set_stack("main", stack, item)
                  end
                end
                
                meta:set_string("opened", "true")
           end
           
           local formspec = "size[8,9]" ..
                     "list[nodemeta:" .. lpos .. ";main;0,0.3;8,4;]" ..
                     "listcolors[#000000BB;#000000BB]"..
                     "list[current_name;main;0,0;8,4;]" ..  
                     "list[current_player;main;0,5;8,4;]" ..
                     "listring[nodemeta:" .. lpos .. ";main]" ..
		      "listring[current_player;main]"
                     core.show_formspec(p_name, "oceanblock:ocean_loot", formspec)         
          end,
          
        can_dig = function(pos,player)
         local meta = core.get_meta(pos)
         local inv = meta:get_inventory()
          return inv:is_empty("main")
        end,	
})
