local cauldron = {
 {click_item = "default:obsidian",pos_node = "oceanblock:cauldron",swap_node = "oceanblock:cauldron_lava",returns_item = "",light_source_c},
 {click_item = "bucket:bucket_empty",pos_node = "oceanblock:cauldron_lava",swap_node = "oceanblock:cauldron",returns_item = "bucket:bucket_lava"},
}

local function register_cauldrons (id,descriptions,tiles_top,tiles_bottom,tiles_side)
core.register_node(id, {
    description = descriptions,
    tiles = {
	tiles_top, 
	tiles_bottom, 
	tiles_side, 
	tiles_side, 
	tiles_side, 
	tiles_side, 
    }, 
    groups = {cracky = 2},
    light_source = light_source_c,
    sounds = default.node_sound_metal_defaults(), 
    
    after_place_node = function(pos, placer, itemstack, pointed_thing)
     local guide_simple = "\nClick while wielding Obsidian to create lava, \nand use an empty bucket to collect it."
     core.chat_send_player(placer:get_player_name(),core.colorize("#ecb42b",guide_simple))
    end,
    
    on_rightclick = function(pos, node, player, itemstack, pointed_thing)
    
      local wielded = player:get_wielded_item()
      local name = wielded:get_name()
      local inv = player:get_inventory()
      local node = minetest.get_node (pos)
      local node_flame = minetest.get_node ({x = pos.x , y=pos.y- 1 ,z = pos.z})
      
      if node_flame.name ~= "fire:basic_flame" and node.name == "oceanblock:cauldron" then 
         return core.chat_send_player(player:get_player_name(),core.colorize("#ec2b34", "\nFire is needed below the cauldron for it to work."))
      end

      for _,c in pairs (cauldron) do
          if name == c.click_item and node.name == c.pos_node then
               itemstack:take_item()
               inv:add_item("main",c.returns_item)
               core.swap_node(pos, {name = c.swap_node})             
          end
       end
         
    end,   
})

end

register_cauldrons ("oceanblock:cauldron","Empty Cauldron","cauldrontopempty.png","cauldronbottom.png","cauldronsides.png",0)
register_cauldrons ("oceanblock:cauldron_lava","Cauldron with lava","default_lava.png^cauldrontoptrans.png","cauldronbottom.png","cauldronsides.png",10)

core.register_craft({
	output = "oceanblock:cauldron",
	recipe = {
		{"oceanblock:cast_steel_ingot", "", "oceanblock:cast_steel_ingot"},
		{"oceanblock:cast_steel_ingot", "", "oceanblock:cast_steel_ingot"},
		{"oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot"},
	}
})

