core.register_node("oceanblock:cobblestone_generator", {
    description = "Cobblestone Generator",
     tiles = {
	"cobblestone_generator_side.png", 
	"cobblestone_generator_side.png",
	"cobblestone_generator_side.png", 
	"cobblestone_generator_side.png", 
	"cobblestone_generator_side.png",
	"cobblestone_generator_front.png", 
    }, 
    paramtype2 = "facedir",
    light_source = 10,
    groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},  
    
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("output", 1)
        meta:set_string("formspec",            
	    "size[8,9]" ..
            "list[current_name;output;3.5,1.5;1,1;]" ..
            "list[current_player;main;0,5;8,4;]"
        )
        
         core.get_node_timer(pos):start(5.0)  
   end,
 
   on_timer = function(pos,node,elapsed)
         local meta = minetest.get_meta(pos)
         local inv = meta:get_inventory() 
               inv:add_item("output","default:cobble")
               core.get_node_timer(pos):start(5.0)     
   end,
     
   can_dig = function(pos,player)
         local meta = core.get_meta(pos)
         local inv = meta:get_inventory()
          return inv:is_empty("output")
   end,
})

core.register_craft({
	output = "oceanblock:cobblestone_generator",
	recipe = {
		{"oceanblock:caststeelblock","oceanblock:caststeelblock","oceanblock:caststeelblock"},
		{"bucket:bucket_lava","","bucket:bucket_water"},
		{"oceanblock:caststeelblock","default:mese","oceanblock:caststeelblock"},
	}
})

hopper:add_container({
	{"top", "oceanblock:cobblestone_generator", "output"},
})
