local grinder_items = {
       {imput_item = "default:cobble",output_item = "default:gravel"},
       {imput_item = "default:gravel",output_item = "default:dirt"},
       {imput_item = "default:dirt",output_item = "default:sand"},
       {imput_item = "default:sand",output_item = "default:clay"}
      }
           
core.register_node("oceanblock:grinder", {
    description = "Grinder",
    tiles = {
	"grinder_top.png", 
	"grinder_bottom.png", 
	"grinder_sides.png", 
	"grinder_sides.png",  
	"grinder_sides.png", 
	"grinder_sides.png",  
     }, 
     groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},  
    
     on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("input", 1)
        inv:set_size("output", 1)
        meta:set_string("formspec",            
	    "size[8,9]" ..
            "list[current_name;input;2,1;1,1;]" ..
            "list[current_name;output;5,1;1,1;]" ..
            "list[current_player;main;0,5;8,4;]"
        )
        meta:set_string("infotext", "Grinder\nClick while holding these items to: \nCobble --> Gravel\nGravel --> Dirt\nDirt --> Sand\nSand --> Clay\n")
    end ,
 
     on_metadata_inventory_put = function(pos)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
           
      for _, grinder in pairs (grinder_items) do  
        if inv:get_stack("input", 1):get_name() == grinder.imput_item then   
          core.get_node_timer(pos):start(1.0)
       end
      end
       
     end,
    
     on_timer = function(pos,node,elapsed)
         local meta = minetest.get_meta(pos)
         local inv = meta:get_inventory() 
          
       for _, grinder in pairs (grinder_items) do
       
          if inv:get_stack("input", 1):get_name() == grinder.imput_item then             
                inv:remove_item("input", grinder.imput_item)
                inv:add_item("output",grinder.output_item)
                core.get_node_timer(pos):start(1.0)     
         end
       end
       
     end,
     
     can_dig = function(pos,player)
         local meta = core.get_meta(pos)
         local inv = meta:get_inventory()
          return inv:is_empty("output")
    end,
})

core.register_craft({
	output = "oceanblock:grinder",
	recipe = {
		{"stairs:slab_stone","stairs:slab_stone","stairs:slab_stone"},
		{"default:acacia_wood","stairs:slab_stone","default:acacia_wood"},
		{"default:acacia_wood","default:acacia_wood","default:acacia_wood"},
	}
})

--[[
hopper:add_container({
	{"bottom", "oceanblock:grinder", "input"},
})
]]

hopper:add_container({
	{"side", "oceanblock:grinder", "input"},
})

hopper:add_container({
	{"top", "oceanblock:grinder", "output"},
})
	
