local item_sieve = {
   "oceanblock:tin_chunk",
   "oceanblock:copper_chunk",
   "oceanblock:gold_chunk",
   "oceanblock:iron_chunk",
}

local item_sieve_dirt = {
"farming:seed_wheat",
"pixel_farming:seed_tomato",
"pixel_farming:seed_corn",
"pixel_farming:seed_melon",
"pixel_farming:seed_carrot",
"pixel_farming:seed_potato",
"pixel_farming:seed_pumpkin",
"default:cactus",
"default:papyrus",
}

local item_steel_sieve = {
   "oceanblock:copper_chunk",
   "oceanblock:gold_chunk",
   "oceanblock:iron_chunk",
   "default:mese_crystal_fragment",
   "mystical_agriculture:inferium_essence",
   "bonemeal:bonemeal",
   "oceanblock:diamond_chunk",
   "oceanblock:tin_chunk"
}
---- WOODEN SIEVE : ====================================================================	      
core.register_node("oceanblock:sieve", {
    description = "Wodden Sieve",
    tiles = {
        "gravelsieve_top.png",
        "gravelsieve_top.png",
	"gravelsieve_sieve.png",
	"gravelsieve_sieve.png",
	"gravelsieve_sieve.png",
	"gravelsieve_sieve.png"	
    },
    groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},  
    drawtype = "nodebox",
    use_texture_alpha = "clip",
    
    node_box = {
	type = "fixed",
	fixed ={
		{ -8/16, -8/16, -8/16,   8/16, 4/16, -6/16 },
		{ -8/16, -8/16,  6/16,   8/16, 4/16,  8/16 },
		{ -8/16, -8/16, -8/16,  -6/16, 4/16,  8/16 },
		{  6/16, -8/16, -8/16,   8/16, 4/16,  8/16 },
		{ -6/16, -2/16, -6/16,  6/16, 3/16, 6/16 },
	},
    },
		
   selection_box = {
	type = "fixed",
	fixed = { -8/16, -8/16, -8/16,   8/16, 4/16, 8/16 },
    },
      
      on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local meta = core.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("input", 1)
        meta:set_string("infotext", "Sieve\n[Place Gravel and collect chunks ore,\nor dirt to collect seeds]")
      end , 

      on_rightclick = function(pos, node, player, itemstack, pointed_thing)
            local wielded = player:get_wielded_item()
            local name = wielded:get_name()
            local inv = player:get_inventory()
            
            if name == "default:gravel" then
               itemstack:take_item()
               core.add_item(pos, item_sieve[math.random(1,#item_sieve)])
               
               elseif name == "default:dirt" then
               itemstack:take_item()
               core.add_item(pos, item_sieve_dirt[math.random(1,#item_sieve_dirt)])
               
            end
      end,  
      
      on_metadata_inventory_put = function(pos)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
         
      if inv:get_stack("input", 1):get_name() == "default:gravel" or inv:get_stack("input", 1):get_name() == "default:dirt" then  
        core.get_node_timer(pos):start(3.0)
      end 
     end,
     
     on_timer = function(pos,node,elapsed)
         local meta = minetest.get_meta(pos)
         local inv = meta:get_inventory() 

          if inv:get_stack("input", 1):get_name() == "default:gravel" then             
              inv:remove_item("input", "default:gravel")
              core.add_item(pos, item_sieve[math.random(1,#item_sieve)])
              core.get_node_timer(pos):start(3.0)  
              
              elseif inv:get_stack("input", 1):get_name() == "default:dirt" then
              inv:remove_item("input", "default:dirt")
              core.add_item(pos, item_sieve_dirt[math.random(1,#item_sieve_dirt)])
              core.get_node_timer(pos):start(3.0)
               
         end
     end,
})

------ STEEL SIEVE : ============================================================================
core.register_node("oceanblock:steel_sieve", {
    description = "Steel Sieve",
    tiles = {
        "gravelsteel_sieve_top.png",
        "gravelsteel_sieve_top.png",
	"gravelsteel_sieve_steel_sieve.png",
	"gravelsteel_sieve_steel_sieve.png",
	"gravelsteel_sieve_steel_sieve.png",
	"gravelsteel_sieve_steel_sieve.png"	
    },
    groups = {choppy=2, oddly_breakable_by_hand=1},  
    drawtype = "nodebox",
    use_texture_alpha = "clip",
    node_box = {
	type = "fixed",
	fixed ={
		{ -8/16, -8/16, -8/16,   8/16, 4/16, -6/16 },
		{ -8/16, -8/16,  6/16,   8/16, 4/16,  8/16 },
		{ -8/16, -8/16, -8/16,  -6/16, 4/16,  8/16 },
		{  6/16, -8/16, -8/16,   8/16, 4/16,  8/16 },
		{ -6/16, -2/16, -6/16,  6/16, 3/16, 6/16 },
	},
    },
		
   selection_box = {
	type = "fixed",
	fixed = { -8/16, -8/16, -8/16,   8/16, 4/16, 8/16 },
    },

    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("input", 1)
        meta:set_string("infotext", "Steel Sieve\n[Place gravel and collect chunks, shards, and ore fragments]")
    end , 
      
   on_rightclick = function(pos, node, player, itemstack, pointed_thing)
      local wielded = player:get_wielded_item()
      local name = wielded:get_name()
      local inv = player:get_inventory()
            
            if name == "default:gravel" then
               itemstack:take_item()
               core.add_item(pos, item_steel_sieve[math.random(1,#item_steel_sieve)])
               
               elseif name == "default:dirt" then
               itemstack:take_item()
               core.add_item(pos, item_sieve_dirt[math.random(1,#item_sieve_dirt)])
               
            end
    end, 
    
    on_metadata_inventory_put = function(pos)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
         
      if inv:get_stack("input", 1):get_name() == "default:gravel" or inv:get_stack("input", 1):get_name() == "default:dirt" then  
         core.get_node_timer(pos):start(2.0)
         core.log("teste")
      end
       
     end,
    
    on_timer = function(pos,node,elapsed)
         local meta = minetest.get_meta(pos)
         local inv = meta:get_inventory() 

          if inv:get_stack("input", 1):get_name() == "default:gravel" then             
               inv:remove_item("input", "default:gravel")
               core.add_item(pos, item_steel_sieve[math.random(1,#item_steel_sieve)])
               core.get_node_timer(pos):start(2.0)
               
              elseif inv:get_stack("input", 1):get_name() == "default:dirt" then
              inv:remove_item("input", "default:dirt")
              core.add_item(pos, item_sieve_dirt[math.random(1,#item_sieve_dirt)])
              core.get_node_timer(pos):start(3.0)
                  
          end
    end,
     
    can_dig = function(pos,player)
         local meta = core.get_meta(pos)
         local inv = meta:get_inventory()
          return inv:is_empty("output")
   end,  
})

core.register_craft({
	output = "oceanblock:steel_sieve",
	recipe = {
		{"","default:steel_ingot",""},
		{"default:steel_ingot","oceanblock:sieve","default:steel_ingot"},
		{"","default:steel_ingot",""},
	}
})

core.register_craft({
	output = "oceanblock:sieve",
	recipe = {
		{"default:aspen_wood","oceanblock:cloth_mesh","default:aspen_wood"},
		{"default:aspen_wood","","default:aspen_wood"},
		{"default:stick","","default:stick"},
	}
})

hopper:add_container({
	{"bottom", "oceanblock:sieve", "input"},
})

hopper:add_container({
	{"bottom", "oceanblock:steel_sieve", "input"},
})

