--- Water Strainer : ===============================================================================
local item_water_strainer = {
--- falta s fishs
{drop = "oceanblock:pebbles", chance = 8},
{drop = "oceanblock:pebble_desert_sandstone", chance =8},
{drop = "oceanblock:pebble_silver_sand", chance = 8},
{drop = "oceanblock:pebble_desert", chance = 8},
{drop = "oceanblock:tiny_coal", chance =7},
{drop = "default:flint", chance = 7},
{drop = "default:sapling", chance = 7},
{drop = "flowers:waterlily", chance = 6},
{drop = "default:junglesapling", chance = 6},
{drop = "default:pine_sapling", chance =6},
{drop = "default:acacia_sapling", chance = 6},
{drop = "default:aspen_sapling", chance = 5},
{drop = "marinaramobs:raw_exotic_fish", chance = 5},
--{-drop = "default:papyrus", chance = 4},
{drop = "oceanblock:pebbles", chance = 4},
{drop = "default:junglegrass", chance = 3},
{drop = "default:grass_5", chance = 3},
{drop = "default:dry_grass_5", chance = 3},
{drop = "default:fern_3", chance = 3},
{drop = "default:marram_grass_3", chance = 3},
--{drop = "default:cactus", chance = 3},
{drop = "default:stick", chance = 3},
-- marinara:
{drop = "marinaramobs:raw_exotic_fish", chance = 7},
{drop = "marinaramobs:octopus_raw", chance = 7},
{drop = "marinaramobs:seaurchin_cooked", chance = 7},

}
 
core.register_node("oceanblock:water_strainer", {
    description = "Water Strainer\n[Place next to the water]",
    tiles = {
	"water_strainer_top.png", 
	"water_strainer_top.png", 
	"water_strainer_side.png", 
	"water_strainer_side.png", 
	"water_strainer_side.png", 
	"water_strainer_side.png", 
    },
    groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},  
    use_texture_alpha = "blend",
    waving = 1, 
    drawtype = "nodebox",
    paramtype2 = "leveled",
    node_box = {
        type = "fixed",
        fixed = {
           {-0.5, -0.5, -0.5, 0.5, 0.35, 0.5},
           {-0.5, -0.5, 0.45, -0.45, 0.5, 0.5},
           {0.45, -0.5, -0.5, 0.5, 0.5, -0.45},
           {0.45, -0.5, 0.45, 0.5, 0.5, 0.5},
           {-0.5, -0.5, -0.5, -0.45, 0.5, -0.45},

        }},
        
     on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        local inv = meta:get_inventory()
        inv:set_size("input", 12) -- 18 
        meta:set_string("formspec",            
	   "size[8,9]" ..
           "list[current_name;input;1,1;6,2;]" ..
           "list[current_player;main;0,5;8,4;]"
        )
        meta:set_string("infotext", "Water Strainer")

        if core.get_node({x=pos.x+1,y=pos.y,z=pos.z}).name=="default:water_source"
	or core.get_node({x=pos.x-1,y=pos.y,z=pos.z}).name=="default:water_source"
	or core.get_node({x=pos.x,y=pos.y,z=pos.z+1}).name=="default:water_source"
	or core.get_node({x=pos.x,y=pos.y,z=pos.z-1}).name=="default:water_source" then
	    --return core.log("sim")
	    core.get_node_timer(pos):start(25.0)
	end 
     end ,

     on_timer = function(pos,node,elapsed)
	    local meta = minetest.get_meta(pos)
	    local inv = meta:get_inventory()

	    if core.get_node({x=pos.x+1,y=pos.y,z=pos.z}).name=="default:water_source"
	    or core.get_node({x=pos.x-1,y=pos.y,z=pos.z}).name=="default:water_source"
	    or core.get_node({x=pos.x,y=pos.y,z=pos.z+1}).name=="default:water_source"
	    or core.get_node({x=pos.x,y=pos.y,z=pos.z-1}).name=="default:water_source" then

		for _, ws in ipairs(item_water_strainer) do
		     local chances = math.random(1000)
		     if chances <= (ws.chance * 10) then
			inv:add_item("input", ws.drop)
			break 
		    end
		    chances = chances - ws.chance
		end
		
		core.get_node_timer(pos):start(25.0)
	    end
      end,
      
    can_dig = function(pos,player)
         local meta = core.get_meta(pos)
         local inv = meta:get_inventory()
         return inv:is_empty("input")
   end,

})

core.register_craft({
	output = "oceanblock:water_strainer",
	recipe = {
		{"group:stick","","group:stick"},
		{"oceanblock:cloth_mesh","","oceanblock:cloth_mesh"},
		{"group:wood","oceanblock:cloth_mesh","group:wood"},
	}
})

