local fly_w = {
"default:water_source",
}
---- Shark : ===============================================================================
mobs:register_mob("oceanblock:shark", {
	type = "monster",
	attack_type = "dogfight",
	passive = false,
	attack_animals = true , 
	attack_players = true,
	pathfinding = true,
	reach = 1,
	damage = 3,
	hp_min = 45,
	hp_max = 45,
	armor = 100,
	collisionbox = {-0.4, -0.0, -0.4, 0.4, 0.5, 0.4},
	visual = "mesh",
	mesh = "shark.b3d",
	textures = {{"shark.png"}},
	makes_footstep_sound = false,
	sounds = {},
	fly = true , 
	fly_in = fly_w,
	walk_velocity = 2,
	run_velocity = 4,
	jump_height = 0,
	stepheight = 0.0,
	fall_speed = 0,
	-- floats = 0,
	view_range = 35,
	drops = {	
	    --{name = "oceanblock:shark_tooth", chance = 5, min = 1, max = 1},		
	},
	water_damage = 0,
	lava_damage = 6,
	light_damage = 0,
	animation = {
		speed_normal = 20,
		stand_start = 1,
		stand_end = 20,
		fly_start = 30,			
		fly_end = 50,
		walk_start = 30,
		walk_end = 50,
		run_start = 30,
		run_end = 50,
		punch_start = 55,
		punch_end = 75,
	},
	
})
	
mobs:register_egg("oceanblock:shark","Shark","shark_egg.png", 0)
--- GUARDIANS : ============================================================================
mobs:register_mob("oceanblock:ocean_guardian", {
	type = "monster",
	attack_type = "dogfight",
	passive = false,
	attack_animals = true , 
	attack_players = true,
	pathfinding = true,
	reach = 3,
	damage = 5,
	hp_min = 45,
	hp_max = 45,
	armor = 80,
	collisionbox = {-0.4, -0.0, -0.4, 0.4, 0.5, 0.4},
	visual = "mesh",
	mesh = "ocean_guardian.b3d",
	textures = {{"ocean_guadian.png"}},
	visual_size = {x = 12, y = 12},
	makes_footstep_sound = false,
	sounds = {},
	fly = true , 
	fly_in = fly_w,
	walk_velocity = 2,
	run_velocity = 4,
	jump_height = 0,
	stepheight = 0.0,
	fall_speed = 0,
	view_range = 35,
	glow = 8,
	stay_near = {{"oceanblock:ocean_rock","oceanblock:ocean_rock_brick"}, 5},
	drops = {	
	    --{name = "oceanblock:shark_tooth", chance = 5, min = 1, max = 1},		
	},
	water_damage = 0,
	lava_damage = 6,
	light_damage = 0,
	animation = {
		speed_normal = 25,
		stand_start = 0,
		stand_end = 39,
		fly_start = 0,			
		fly_end = 39,
		walk_start = 0,
		walk_end = 39,
		run_start = 0,
		run_end = 39,
		punch_start = 45,
		punch_end = 65,
	},	
})
	
mobs:register_egg("oceanblock:ocean_guardian","Ghost Fish","shark_egg.png", 0)

--- BOSS Kraken: ==================================================================================
-- voice : https://freesound.org/people/cmusounddesign/sounds/126311/
local function black_cloud(pos_node)
      local pos = pos_node

        core.add_particlespawner({
            amount = 30,
            time = 3,

            minpos = {x = pos.x + math.random(3,5) , y = pos.y, z = pos.z +  math.random(3,5)},
            maxpos = {x = pos.x -  math.random(3,5) , y = pos.y+3, z = pos.z -  math.random(3,5)},

            minvel = {x = 2, y = 2, z = 2},
            maxvel = {x = -2, y = 0, z = -2},

            minacc = {x = 0, y = 0, z = 0},
            maxacc = {x = 0, y = 0, z = 0},

            minexptime = 1,
            maxexptime = 1,

            minsize = 10,
            maxsize = 12,

            collisiondetection = false,
            vertical = true,
            texture = "dark_smoke.png",

            glow = 4,
        })
end

mobs:register_mob("oceanblock:kraken", { 
	type = "monster",
	passive = false,
	attack_type = "dogshoot",
        dogshoot_switch = 1,
        dogshoot_count_max = 12, 
	dogshoot_count2_max = 3, 
	shoot_interval = 2.5,
	reach = 8,
	damage = 70,
	arrow = "oceanblock:black_cloud",
	shoot_offset = 1,
	attack_npcs = false,
	pathfinding = false,
	hp_min = 500,
	hp_max = 500,
	armor = 80,
	collisionbox = {-2.5, -2.5, -2.5, 2.5, 2.5, 2.5},
	visual = "mesh",
	mesh = "kraken.b3d",
	glow = 4,
	textures = {
		{"kraken.png"},
	},
	visual_size = {x = 4, y = 4},
	makes_footstep_sound = true,
	sounds = {
		attack = "kraken",
		--death = "",
	},
	drops = {
		{name = "oceanblock:kraken_deco", chance = 1, min = 1, max = 1},
		{name = "oceanblock:oceanite", chance = 1, min = 10, max = 20},
	},
	pathfinding = 1,
	fear_height = 6,
	stepheight = 1.1,
	walk_velocity = 0,
	run_velocity = 0,
	walk_chance = 0,
	stand_chance = 50,
	jump = false,
	jump_height = 0,
	floats = 0,
	view_range = 25,
	glow = 2,
	knock_back = false,
	die_rotate = true,	
	water_damage = 0,
	lava_damage = 1,
	light_damage = 0,
	animation = {
		speed_normal = 1,speed_run = 1,stand_start = 1,stand_end = 19,
		stand_start = 0,stand_end = 40,
		shoot_start = 60, shoot_end = 120,
		punch_start = 140,punch_end = 180,punch_speed = 15,
		--punch2_start = 80,punch2_end = 115,punch2_speed = 15,			
	},
	
       on_spawn = function(self)
        core.chat_send_all(core.colorize("#d0910d","A kraken awoke from its slumber..."))
       end,
    
       on_die = function(self,pos)
          for _,players in pairs(minetest.get_objects_inside_radius(pos,64)) do
		if players:is_player() then
		   awards.unlock(players:get_player_name(), "kraken") 
		end
	   end
      end			
})

mobs:register_arrow("oceanblock:black_cloud", {  
   visual = "cube",
   visual_size = {x=0.5, y=0.5},
   velocity = 13,
   textures = {"bomba_de_tinta.png","bomba_de_tinta.png","bomba_de_tinta.png","bomba_de_tinta.png","bomba_de_tinta.png","bomba_de_tinta.png","bomba_de_tinta.png"},  
   damage = 3,

	hit_player = function(self, player)
	local pos = player:get_pos()
	black_cloud(pos)
	player:punch(self.object, 1.0, {
	       full_punch_interval = 0.5,
		damage_groups = {fleshy = 50},
		}, nil)
	
	end,

	hit_mob = function(self, player)
	end,

	hit_node = function(self, pos, node)
	  local pos = self.object:get_pos()
	  black_cloud(pos)
	end
})

mobs:register_egg("oceanblock:kraken","Kraken","kraken.png", 1)


---- SPAWNS ; ======================================================================================
if not mobs.custom_spawn_oceanblock then
mobs:spawn({
	name = "oceanblock:shark",
	nodes = {"default:water_source"},
	neighbors = {"marinara:hardcoral_pink", "marinara:hardcoral_yellow"},
	min_light = 0,
	interval = 60,
	chance = 2, 
	active_object_count = 4,
	min_height = -30,
	max_height = 0,
	day_toggle = true,
})

mobs:spawn({
	name = "oceanblock:ocean_guardian",
	nodes = {"default:water_source"},
	neighbors =  {"oceanblock:ocean_rock","oceanblock:ocean_rock_brick","default:sand"},
	min_light = 0,
	interval = 60,
	chance = 2, 
	active_object_count = 3,
	min_height = -30,
	max_height = 0,
	day_toggle = true,
        --[[
	on_spawn = function(self, pos)
         core.log("spawn teste")
         
          local pos2 = {x = pos.x - 1, y = pos.y , z = pos.z - 3}
          local pos3 = {x = pos.x + 1, y = pos.y , z = pos.z + 3}
          mobs:add_mob(pos2, {name = "oceanblock:ocean_guardian",child = false})
	  mobs:add_mob(pos3, {name = "oceanblock:ocean_guardian",child = false})		
        end
        ]]
})


mobs:spawn({
	name = "oceanblock:shark",
	nodes = {"default:water_source"},
	--neighbors = {"marinara:hardcoral_pink", "marinara:hardcoral_yellow"},
	min_light = 0,
	interval = 60,
	chance = 1000, 
	active_object_count = 1,
	min_height = -30,
	max_height = -10,
	--day_toggle = true,
	
	--on_spawn = function(self, pos)
	 --core.log("spawn kraken")
	--end
})

end


