core.register_node("oceanblock:rock", {
    description = "Bedrock",
    tiles = {"default_coal_block.png"},
    --groups = {choppy=2, oddly_breakable_by_hand=1, flammable=2},   
})

core.register_node("oceanblock:caststeelblock", {
	description = "Cast Steel Block",
	inventory_image = "default_steel_block.png^[colorize:#000000:190",
	tiles = {"default_steel_block.png^[colorize:#000000:190"},
	is_ground_content = false,
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_metal_defaults(),
})

core.register_craft({
	output = "oceanblock:caststeelblock",
	recipe = {
		{"oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot"},
		{"oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot"},
		{"oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot", "oceanblock:cast_steel_ingot"},
	}
})

core.register_node("oceanblock:oceanite_block", {
	description = "Oceanite Block",
	tiles = {"oceanite_block.png"}, 
	paramtype = "light",
	groups = {cracky = 1, level = 2},
	sounds = default.node_sound_stone_defaults(),
	--light_source = 12,
})

core.register_craft({
	output = "oceanblock:oceanite_block",
	recipe = {
		{"oceanblock:oceanite", "oceanblock:oceanite", "oceanblock:oceanite"},
		{"oceanblock:oceanite", "oceanblock:oceanite", "oceanblock:oceanite"},
		{"oceanblock:oceanite", "oceanblock:oceanite", "oceanblock:oceanite"},
	}
})


core.register_node("oceanblock:ocean_rock", {
	description = "Ocean Rock",
	tiles = {"default_cobble.png^[colorize:#047743:120"},
	is_ground_content = false,
	groups = {cracky = 1,level = 3},
	sounds = default.node_sound_stone_defaults(),
	--_tnt_loss = 4,
})

core.register_node("oceanblock:ocean_rock_brick", {
	description = "Ocean Rock Brick",
	paramtype2 = "facedir",
	place_param2 = 0,
	tiles = {"default_stone_brick.png^[colorize:#047743:120"},
	is_ground_content = false,
	groups = {cracky = 1,level = 3},
	sounds = default.node_sound_stone_defaults(),
})

if minetest.get_modpath("stairs") ~= nil then

    stairs.register_stair_and_slab("ocean_rock","oceanblock:ocean_rock",
        {cracky = 3},
        {"default_cobble.png^[colorize:#047743:120"},
        "Ocean Rock Stair",
        "Ocean Rock Slab",
        default.node_sound_stone_defaults()
    )

    stairs.register_stair_and_slab("ocean_rock_brick","oceanblock:ocean_rock_brick",
        {cracky = 3},
        {"default_stone_brick.png^[colorize:#047743:120"},
        "Ocean Rock Brick Stair",
        "Ocean Rock Brick Slab",
        default.node_sound_stone_defaults()  
    )
end
    
    
if minetest.get_modpath("walls") ~= nil then
    
    walls.register("oceanblock:ocean_rock_wall", "Ocean Rock Brick Wall","default_cobble.png^[colorize:#047743:120",
            "oceanblock:ocean_rock", default.node_sound_stone_defaults())
    
    walls.register("oceanblock:ocean_rock_brick_wall", "Ocean Rock BrickWall","default_stone_brick.png^[colorize:#047743:120",
    "oceanblock:ocean_rock_brick", default.node_sound_stone_defaults())
    
end

----- SEAGRASS
minetest.register_node("oceanblock:seagrass", {
	description = "Sea Grass",
	drawtype = "plantlike_rooted",
	waving = 1,
        visual_scale = 2.0,
	paramtype = "light",
	tiles = {"default_sand.png"},
        special_tiles = {{name = "seagrass.png", tileable_vertical = true, waving = 1, animation = {type="vertical_frames", length = 3}}},
	inventory_image = "seagrass.png",
	wield_image = "seagrass.png",
	groups = {snappy = 3},
	selection_box = {
		type = "fixed",
		fixed = {
				{-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
				{-4/16, 0.5, -4/16, 4/16, 1.5, 4/16},
		},
	},
	node_dig_prediction = "oceanblock:seagrass",
	node_placement_prediction = "",
})

core.register_decoration({
    deco_type = "simple",
    place_on = {"default:sand"},
    sidelen = 16,
    place_offset_y = -1,
    biomes = {
        "taiga_ocean",
	"snowy_grassland_ocean",
	"grassland_ocean",
	"coniferous_forest_ocean",
	"deciduous_forest_ocean",
	"sandstone_desert_ocean",
	"cold_desert_ocean",
    },
    flags = "force_placement,all_floors",
    fill_ratio = 0.009,
    y_max = -5,
    y_min = -30,
    decoration ="oceanblock:seagrass",
})


core.register_node("oceanblock:kraken_deco", { 
	description = "Kraken Decorative",
	drawtype = "mesh",
	mesh = "kraken.obj",	
	tiles = {"kraken.png"},
	use_texture_alpha = "blend",
	paramtype = "light",
	paramtype2 = "facedir",
	sunlight_propagates = true,
	walkable = false, 
	floodable = false,
	groups = {dig_immediate=3},

	selection_box = {type = "fixed",fixed = {-0.3, -0.5, -0.3, 0.3, 0.1, 0.3},
	},
	
	node_box = {type = "fixed",fixed = {-0.3, -0.5, -0.3, 0.3, 0.1, 0.3},
	},
	
	on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
	  local pn = vector.floor(clicker:get_pos())
	  local pns  = core.pos_to_string(pn)
	  core.chat_send_player(clicker:get_player_name(),core.colorize("#dac838", "Pos : "..pns))
        end   
})

