-- sound : https://freesound.org/people/mrbubble110/sounds/70333/
mobs:register_mob("pixel_animals:tiger", {
	type = "monster",
        damage = 5,
	attack_type = "dogfight",
	attack_animals = true,
	pathfinding = true, 
	reach = 3,
	passive = false,
	hp_min = 30,
	hp_max = 30,
	armor = 100,
	collisionbox = {-0.6, 0, -0.6, 0.6, 1.6, 0.6},
	visual = "mesh",
	visual_size = {x = 10, y = 10},
	mesh = "Tiger.b3d",
	textures = {{"tiger.png"}},
	makes_footstep_sound = false,
	sounds = {
		random = "bear_roar",
	},
	walk_velocity = 2,
	walk_chance = 15,
	run_velocity = 4,
	runaway = true,
	jump = true,
	jump_height = 3,
	stepheight = 2,
	fall_damage = 1,
	drops = {
		--{name = "mobs:leather", chance = 2, min = 1, max = 1},
	},
	water_damage = 0,
	lava_damage = 5,
	fear_height = 3,
	animation = {
		--speed_normal = 15,
		--speed_run = 15,
		stand_start = 1,
		stand_end = 40,
		--stand1_start = 100,
		--stand1_end = 100,
		walk_start = 60,
		walk_end = 140,
		run_start = 160,
		run_end = 180,
		--stoodup_speed = 5,
		--stoodup_start = 1,
		--stoodup_end = 40,
		--punch_start = 190, 
		--punch_end =250,
		--punch_speed = 23, 
	},
	view_range = 15, 	
})

mobs:spawn({
	name = "pixel_animals:tiger",
	nodes = {"default:dirt_with_rainforest_litter","mcl_core:dirt_with_grass"},
	neighbors = {"default:jungle_tree","mcl_trees:tree_jungle"},
	min_light = 8,
	--max_light = 14,
	chance = 12000,
	min_height = 0,
	max_height = 200,	
})

mobs:register_egg("pixel_animals:tiger", "Tiger", "tiger_egg.png", 0)
