
local S = minetest.get_translator("pixel_farming") 

farming.register_plant("pixel_farming:melon", {
	description = S("Melon Seed"),
	harvest_description = "melon",
	paramtype = "light",
	paramtype2 = "plantlike",  
	inventory_image = "melon_seed.png",
	steps = 5, --estagios
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland"},
	groups = {flammable = 4,not_in_creative_inventory = 1},
	place_param2 = 3,
	drop = "",
	
	
})

core.register_node("pixel_farming:melon_5", {
	description = S("Melon"),
	inventory_image = "melon.png",
	tiles = {
		"pixel_farming_melon_top.png",
		"pixel_farming_melon_bottom.png",
		"pixel_farming_melon_side.png"
	},
	groups = {
		food_melon = 1, choppy = 2, oddly_breakable_by_hand = 1,
		flammable = 2, crops = 1
	},
	drop = "pixel_farming:melon_5",
	sounds = default.node_sound_wood_defaults(),
	paramtype2 = "facedir",
	on_place = minetest.rotate_node
})

core.register_craftitem("pixel_farming:melon_slice", {
	description = S("Melon slice"),
	inventory_image = "pixel_farming_melon_slice.png",
	on_use = minetest.item_eat(2)
})

core.register_craft({  -- Melancia para melancia fatiada
    type = "shapeless",
    output = "pixel_farming:melon_slice 4",
    recipe = {
        "pixel_farming:melon_5",
    },
})

core.register_craft({
    type = "shapeless",
    output = "pixel_farming:seed_melon 1",
    recipe = {
        "pixel_farming:melon_slice",
    },
})

core.register_decoration({
	name = "pixel_farming:melon_5_dec",
	deco_type = "simple",
	place_on = {"default:dirt_with_rainforest_litter"},
	sidelen = 16,
	fill_ratio = 0.005,	
	biomes = {"rainforest"},
	spawn_by = {"default:junglegrass","default:jungletree"},
        num_spawn_by = 3,
	
	y_min = 1,
	y_max = 31000,
	decoration = "pixel_farming:melon_5",
})

