
local S = minetest.get_translator("pixel_farming") 

farming.register_plant("pixel_farming:potato", {
	description = S("Potato Seed"),
	harvest_description = "potato",
	paramtype = "light",
	paramtype2 = "plantlike",  
	inventory_image = "pixel_farming_potato.png",
	steps = 5, --estagios
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland"},
	groups = {flammable = 4,not_in_creative_inventory = 1},
	place_param2 = 3,
	drop = "",
	
	
})

core.register_craftitem("pixel_farming:potato", {
	description = S("Potato"),
	inventory_image = "potato.png",
	on_use = minetest.item_eat(2),
})

core.register_craftitem("pixel_farming:potato_baked", {
	description = S("Potato Baked"),
	inventory_image = "potato_baked.png",
	on_use = minetest.item_eat(5),
})

minetest.register_craft({
	type = "cooking",
	output = "pixel_farming:potato_baked", 
	recipe = "pixel_farming:potato"
})

--[[
minetest.override_item("pixel_farming:potato_5", {
	drop = "pixel_farming:potato",
})
]]

core.register_decoration({
	name = "pixel_farming:potato_5_dec",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.001,	
	biomes = {"deciduous_forest"},	
	y_min = 1,
	y_max = 31000,
	decoration = "pixel_farming:potato_5",
})
