
local S = core.get_translator("pixel_farming") 
farming.register_plant("pixel_farming:pumpkin", {
	description = S("Pumpkin Seed"),
	harvest_description = "pumpkin",
	paramtype = "light",
	paramtype2 = "plantlike",  
	inventory_image = "pixel_farming_pumpkin.png",
	steps = 5, --estagios
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland"},
	groups = {flammable = 4,not_in_creative_inventory = 1},
	place_param2 = 3,
	drop = "",
	
	
})

core.register_node("pixel_farming:pumpkin_5", {
	description = S("Pumpkin"),
	inventory_image = "pumpkin.png",
	tiles = {
		"pixel_farming_pumpkin_top.png",
		"pixel_farming_pumpkin_bottom.png",
		"pixel_farming_pumpkin_side.png"
	},
	groups = {
		food_pumpkin = 1, choppy = 1, oddly_breakable_by_hand = 3,
		flammable = 2, crops = 1
	},
	drop = "pixel_farming:pumpkin_5",
	sounds = default.node_sound_wood_defaults(),
	paramtype2 = "facedir",
	on_place = core.rotate_node
})

core.register_craftitem("pixel_farming:pumpkin_slice", {
	description = S("Pumpkin Slice"),
	inventory_image = "pixel_farming_pumpkin_slice.png",
	on_use = core.item_eat(1)
})


core.register_craftitem("pixel_farming:pumpkin_baked", {
	description = S("Pumpkin Baked"),
	inventory_image = "pixel_farming_pumpkin_baked.png",
	on_use = core.item_eat(3)
})

core.register_craft({ 
    type = "shapeless",
    output = "pixel_farming:pumpkin_slice 4",
    recipe = {
        "pixel_farming:pumpkin_5",
    },
})

core.register_craft({
	type = "cooking",
	output = "pixel_farming:pumpkin_baked", 
	recipe = "pixel_farming:pumpkin_slice"
})

core.register_craft({
    type = "shapeless",
    output = "pixel_farming:seed_pumpkin 1",
    recipe = {
        "pixel_farming:pumpkin_slice",
    },
})

core.register_decoration({
	name = "pixel_farming:pumpkin_5_dec",
	deco_type = "simple",
	place_on = {"default:dry_dirt_with_dry_grass"},
	sidelen = 16,
	fill_ratio = 0.005,	
	biomes = {"savanna"},
	spawn_by = {"default:dry_grass_1","default:dry_grass_3","default:acacia_tree"},
        num_spawn_by = 2,
	
	y_min = 1,
	y_max = 31000,
	decoration = "pixel_farming:pumpkin_5",
})

