local S = core.get_translator("pixel_farming") 
farming.register_plant("pixel_farming:sunflower", {
	description = S("Sunflower Seed"),
	harvest_description = "Sunflower Petal",
	paramtype = "light",
	paramtype2 = "plantlike",  
	inventory_image = "sunflower_seed.png",
	steps = 4, --estagios
	minlight = 13,
	maxlight = default.LIGHT_MAX,
	fertility = {"grassland"},
	groups = {flammable = 4,not_in_creative_inventory = 1},
	place_param2 = 3,
	drop = "pixel_farming:seed_sunflower",
		
})

core.register_node("pixel_farming:sunflower_4", {
	description = S("Sunflower"),
	inventory_image = "sunflower.png",
	drawtype = "plantlike",
	paramtype = "light",
	paramtype2 = "plantlike",
	tiles = {"pixel_farming_sunflower_4.png"},
	visual_scale = 1.5, 
	groups = {snappy = 3,flammable = 1,flora=1},
	drop = "pixel_farming:sunflower_4",
	paramtype2 = "facedir",
	walkable = false, 
	on_place = core.rotate_node,
		
	selection_box = {
        type = "fixed",
        fixed = {-0.5, -0.5, -0.5, 0.5, -5/16, 0.5}, 
        },
        collision_box = {
        type = "fixed",
        fixed = {-0.5, -0.5, -0.5, 0.5, -5/16, 0.5}, 
        },
})

core.register_craft({
    type = "shapeless",
    output = "pixel_farming:seed_sunflower 2",
    recipe = {
        "pixel_farming:sunflower_4",
    },
})

core.register_craft({
    type = "shapeless",
    output = "pixel_farming:seed_sunflower 1",
    recipe = {
        "pixel_farming:sunflower",
    },
})

core.register_decoration({
	name = "pixel_farming:sunflower_4_dec",
	deco_type = "simple",
	place_on = {"default:dirt_with_grass"},
	sidelen = 16,
	fill_ratio = 0.005,
	
	biomes = {
	"deciduous_forest",
	"grassland"
	},
	
	y_min = 1,
	y_max = 31000,
	decoration = "pixel_farming:sunflower_4",
})

--[[
core.register_craftitem("pixel_farming:sunflower_Oil", {
	description = S("Sunflower Oil"),
	inventory_image = "pixel_farming_Oil.png",
	
})

core.register_craft({
    output = "pixel_farming:sunflower_Oil",
    recipe = {
        {"pixel_farming:seed_sunflower"},
        {"vessels:glass_bottle"},
        
    }
})
]]

if core.get_modpath("flowerpot") then
	flowerpot.register_node("pixel_farming:sunflower_4")
end

--core.register_alias("pixel_farming:sunflower", "pixel_farming:seed_sunflower")
