# 🤖 IntelligenceFramework API 🤖
# Have you ever wanted to integrate AI into your mod directly? It is possible now with IntelligenceFramework.



# How to access IntelligenceFramework from your mod:
# First of all, your mod has to know where IntelligenceFramework is located. This is simple, as you can do it by just adding this line of code at the top of your mod's init.lua:
local RNN = dofile(core.get_modpath("intelligenceframework") .. "/init.lua")


# You can create a RNN instance by using:
local your_ai_name = RNN.new({
    hidden_size = 32, -- Example: larger hidden size
    learning_rate = 0.01, -- Example: different learning rate
    charset = "abcdefghijklmnopqrstuvwxyz .,!?'0123456789" -- Example: extended charset
})


# You can add training data to your RNN by using:
your_ai_name:add_training_data({
    "the quick brown fox jumps over the lazy dog",
    "hello world, this is a test",
    "luanti is a great game engine",
})


# You can let your mod train the RNN (it is highly recommended, if you don't train it, it will produce random characters and symbols) by using:
core.after(1, function()
    local success, message = your_ai_name:train(5000, function(epoch, loss)
    end)
end)


# And you can register a command to interact with the AI by using:
core.register_chatcommand("myai", {
    params = "<seed>",
    description = "Generate AI text based on seed using a RNN.",
    func = function(name, param)
        if param == "" then
            return false, "Please provide a seed text"
        end
        local result = your_ai_name:generate(param:lower(), 50) -- Generate 50 characters
        return true, "MyAI: " .. result
    end,
})

# Please notice: you are not limited to a command. You can use your_ai_name:generate(param:lower(), 50) anywhere you want.


# Full Example Code:


local RNN = dofile(core.get_modpath("intelligenceframework") .. "/init.lua")

-- Create an RNN instance
local your_ai_name = RNN.new({
    hidden_size = 32, -- Example: larger hidden size
    learning_rate = 0.01, -- Example: different learning rate
    charset = "abcdefghijklmnopqrstuvwxyz .,!?'0123456789" -- Example: extended charset
})

-- Add training data
your_ai_name:add_training_data({
    "the quick brown fox jumps over the lazy dog",
    "hello world, this is a test",
    "luanti is a great game engine",
})

-- Train the model (can be done on server startup or via a command)
core.after(1, function()
    local success, message = your_ai_name:train(5000, function(epoch, loss)
    end)
end)

-- Register a chat command to use the RNN
core.register_chatcommand("myai", {
    params = "<seed>",
    description = "Generate AI text based on seed using MyRNN",
    func = function(name, param)
        if param == "" then
            return false, "Please provide a seed text"
        end
        local result = your_ai_name:generate(param:lower(), 50) -- Generate 50 characters
        return true, "MyAI: " .. result
    end,
})
