import type { MinetestGlobal as MinetestGlobal_, MtVec3 } from "@repcomm/mt-api";
import type { VoxelManip } from "./voxel_manip";

interface MinetestGlobal extends MinetestGlobal_ {
    log(this: void, kind: string, value?: string): void;
    register_on_generated(this: void, on_generated: (this: void, vmanip: VoxelManip, minp: MtVec3, maxp: MtVec3, blockseed: any) => void): void;
    register_on_generated(this: void, on_generated: (this: void, minp: MtVec3, maxp: MtVec3, blockseed: any) => void): void;
    register_mapgen_script(this: void, path: string): void
    set_mapgen_setting(this: void, name: string, value: number | boolean | string, override_meta?: boolean): void
    get_seed(this: void): number;
    get_mapgen_object(this: void, name: "voxelmanip"): LuaMultiReturn<[VoxelManip, MtVec3, MtVec3]>;
}

declare global {
    const core: MinetestGlobal;
    const dump: (this: void, v: any) => string;
}
