--[[ Generated with https://github.com/TypeScriptToLua/TypeScriptToLua ]]

local ____modules = {}
local ____moduleCache = {}
local ____originalRequire = require
local function require(file, ...)
    if ____moduleCache[file] then
        return ____moduleCache[file].value
    end
    if ____modules[file] then
        local module = ____modules[file]
        local value = nil
        if (select("#", ...) > 0) then value = module(...) else value = module(file) end
        ____moduleCache[file] = { value = value }
        return value
    else
        if ____originalRequire then
            return ____originalRequire(file)
        else
            error("module '" .. file .. "' not found")
        end
    end
end
____modules = {
["lualib_bundle"] = function(...) 
local function __TS__ArrayAt(self, relativeIndex)
    local absoluteIndex = relativeIndex < 0 and #self + relativeIndex or relativeIndex
    if absoluteIndex >= 0 and absoluteIndex < #self then
        return self[absoluteIndex + 1]
    end
    return nil
end

local function __TS__ArrayIsArray(value)
    return type(value) == "table" and (value[1] ~= nil or next(value) == nil)
end

local function __TS__ArrayConcat(self, ...)
    local items = {...}
    local result = {}
    local len = 0
    for i = 1, #self do
        len = len + 1
        result[len] = self[i]
    end
    for i = 1, #items do
        local item = items[i]
        if __TS__ArrayIsArray(item) then
            for j = 1, #item do
                len = len + 1
                result[len] = item[j]
            end
        else
            len = len + 1
            result[len] = item
        end
    end
    return result
end

local __TS__Symbol, Symbol
do
    local symbolMetatable = {__tostring = function(self)
        return ("Symbol(" .. (self.description or "")) .. ")"
    end}
    function __TS__Symbol(description)
        return setmetatable({description = description}, symbolMetatable)
    end
    Symbol = {
        asyncDispose = __TS__Symbol("Symbol.asyncDispose"),
        dispose = __TS__Symbol("Symbol.dispose"),
        iterator = __TS__Symbol("Symbol.iterator"),
        hasInstance = __TS__Symbol("Symbol.hasInstance"),
        species = __TS__Symbol("Symbol.species"),
        toStringTag = __TS__Symbol("Symbol.toStringTag")
    }
end

local function __TS__ArrayEntries(array)
    local key = 0
    return {
        [Symbol.iterator] = function(self)
            return self
        end,
        next = function(self)
            local result = {done = array[key + 1] == nil, value = {key, array[key + 1]}}
            key = key + 1
            return result
        end
    }
end

local function __TS__ArrayEvery(self, callbackfn, thisArg)
    for i = 1, #self do
        if not callbackfn(thisArg, self[i], i - 1, self) then
            return false
        end
    end
    return true
end

local function __TS__ArrayFill(self, value, start, ____end)
    local relativeStart = start or 0
    local relativeEnd = ____end or #self
    if relativeStart < 0 then
        relativeStart = relativeStart + #self
    end
    if relativeEnd < 0 then
        relativeEnd = relativeEnd + #self
    end
    do
        local i = relativeStart
        while i < relativeEnd do
            self[i + 1] = value
            i = i + 1
        end
    end
    return self
end

local function __TS__ArrayFilter(self, callbackfn, thisArg)
    local result = {}
    local len = 0
    for i = 1, #self do
        if callbackfn(thisArg, self[i], i - 1, self) then
            len = len + 1
            result[len] = self[i]
        end
    end
    return result
end

local function __TS__ArrayForEach(self, callbackFn, thisArg)
    for i = 1, #self do
        callbackFn(thisArg, self[i], i - 1, self)
    end
end

local function __TS__ArrayFind(self, predicate, thisArg)
    for i = 1, #self do
        local elem = self[i]
        if predicate(thisArg, elem, i - 1, self) then
            return elem
        end
    end
    return nil
end

local function __TS__ArrayFindIndex(self, callbackFn, thisArg)
    for i = 1, #self do
        if callbackFn(thisArg, self[i], i - 1, self) then
            return i - 1
        end
    end
    return -1
end

local __TS__Iterator
do
    local function iteratorGeneratorStep(self)
        local co = self.____coroutine
        local status, value = coroutine.resume(co)
        if not status then
            error(value, 0)
        end
        if coroutine.status(co) == "dead" then
            return
        end
        return true, value
    end
    local function iteratorIteratorStep(self)
        local result = self:next()
        if result.done then
            return
        end
        return true, result.value
    end
    local function iteratorStringStep(self, index)
        index = index + 1
        if index > #self then
            return
        end
        return index, string.sub(self, index, index)
    end
    function __TS__Iterator(iterable)
        if type(iterable) == "string" then
            return iteratorStringStep, iterable, 0
        elseif iterable.____coroutine ~= nil then
            return iteratorGeneratorStep, iterable
        elseif iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            return iteratorIteratorStep, iterator
        else
            return ipairs(iterable)
        end
    end
end

local __TS__ArrayFrom
do
    local function arrayLikeStep(self, index)
        index = index + 1
        if index > self.length then
            return
        end
        return index, self[index]
    end
    local function arrayLikeIterator(arr)
        if type(arr.length) == "number" then
            return arrayLikeStep, arr, 0
        end
        return __TS__Iterator(arr)
    end
    function __TS__ArrayFrom(arrayLike, mapFn, thisArg)
        local result = {}
        if mapFn == nil then
            for ____, v in arrayLikeIterator(arrayLike) do
                result[#result + 1] = v
            end
        else
            local i = 0
            for ____, v in arrayLikeIterator(arrayLike) do
                local ____mapFn_3 = mapFn
                local ____thisArg_1 = thisArg
                local ____v_2 = v
                local ____i_0 = i
                i = ____i_0 + 1
                result[#result + 1] = ____mapFn_3(____thisArg_1, ____v_2, ____i_0)
            end
        end
        return result
    end
end

local function __TS__ArrayIncludes(self, searchElement, fromIndex)
    if fromIndex == nil then
        fromIndex = 0
    end
    local len = #self
    local k = fromIndex
    if fromIndex < 0 then
        k = len + fromIndex
    end
    if k < 0 then
        k = 0
    end
    for i = k + 1, len do
        if self[i] == searchElement then
            return true
        end
    end
    return false
end

local function __TS__ArrayIndexOf(self, searchElement, fromIndex)
    if fromIndex == nil then
        fromIndex = 0
    end
    local len = #self
    if len == 0 then
        return -1
    end
    if fromIndex >= len then
        return -1
    end
    if fromIndex < 0 then
        fromIndex = len + fromIndex
        if fromIndex < 0 then
            fromIndex = 0
        end
    end
    for i = fromIndex + 1, len do
        if self[i] == searchElement then
            return i - 1
        end
    end
    return -1
end

local function __TS__ArrayJoin(self, separator)
    if separator == nil then
        separator = ","
    end
    local parts = {}
    for i = 1, #self do
        parts[i] = tostring(self[i])
    end
    return table.concat(parts, separator)
end

local function __TS__ArrayMap(self, callbackfn, thisArg)
    local result = {}
    for i = 1, #self do
        result[i] = callbackfn(thisArg, self[i], i - 1, self)
    end
    return result
end

local function __TS__ArrayPush(self, ...)
    local items = {...}
    local len = #self
    for i = 1, #items do
        len = len + 1
        self[len] = items[i]
    end
    return len
end

local function __TS__ArrayPushArray(self, items)
    local len = #self
    for i = 1, #items do
        len = len + 1
        self[len] = items[i]
    end
    return len
end

local function __TS__CountVarargs(...)
    return select("#", ...)
end

local function __TS__ArrayReduce(self, callbackFn, ...)
    local len = #self
    local k = 0
    local accumulator = nil
    if __TS__CountVarargs(...) ~= 0 then
        accumulator = ...
    elseif len > 0 then
        accumulator = self[1]
        k = 1
    else
        error("Reduce of empty array with no initial value", 0)
    end
    for i = k + 1, len do
        accumulator = callbackFn(
            nil,
            accumulator,
            self[i],
            i - 1,
            self
        )
    end
    return accumulator
end

local function __TS__ArrayReduceRight(self, callbackFn, ...)
    local len = #self
    local k = len - 1
    local accumulator = nil
    if __TS__CountVarargs(...) ~= 0 then
        accumulator = ...
    elseif len > 0 then
        accumulator = self[k + 1]
        k = k - 1
    else
        error("Reduce of empty array with no initial value", 0)
    end
    for i = k + 1, 1, -1 do
        accumulator = callbackFn(
            nil,
            accumulator,
            self[i],
            i - 1,
            self
        )
    end
    return accumulator
end

local function __TS__ArrayReverse(self)
    local i = 1
    local j = #self
    while i < j do
        local temp = self[j]
        self[j] = self[i]
        self[i] = temp
        i = i + 1
        j = j - 1
    end
    return self
end

local function __TS__ArrayUnshift(self, ...)
    local items = {...}
    local numItemsToInsert = #items
    if numItemsToInsert == 0 then
        return #self
    end
    for i = #self, 1, -1 do
        self[i + numItemsToInsert] = self[i]
    end
    for i = 1, numItemsToInsert do
        self[i] = items[i]
    end
    return #self
end

local function __TS__ArraySort(self, compareFn)
    if compareFn ~= nil then
        table.sort(
            self,
            function(a, b) return compareFn(nil, a, b) < 0 end
        )
    else
        table.sort(self)
    end
    return self
end

local function __TS__ArraySlice(self, first, last)
    local len = #self
    first = first or 0
    if first < 0 then
        first = len + first
        if first < 0 then
            first = 0
        end
    else
        if first > len then
            first = len
        end
    end
    last = last or len
    if last < 0 then
        last = len + last
        if last < 0 then
            last = 0
        end
    else
        if last > len then
            last = len
        end
    end
    local out = {}
    first = first + 1
    last = last + 1
    local n = 1
    while first < last do
        out[n] = self[first]
        first = first + 1
        n = n + 1
    end
    return out
end

local function __TS__ArraySome(self, callbackfn, thisArg)
    for i = 1, #self do
        if callbackfn(thisArg, self[i], i - 1, self) then
            return true
        end
    end
    return false
end

local function __TS__ArraySplice(self, ...)
    local args = {...}
    local len = #self
    local actualArgumentCount = __TS__CountVarargs(...)
    local start = args[1]
    local deleteCount = args[2]
    if start < 0 then
        start = len + start
        if start < 0 then
            start = 0
        end
    elseif start > len then
        start = len
    end
    local itemCount = actualArgumentCount - 2
    if itemCount < 0 then
        itemCount = 0
    end
    local actualDeleteCount
    if actualArgumentCount == 0 then
        actualDeleteCount = 0
    elseif actualArgumentCount == 1 then
        actualDeleteCount = len - start
    else
        actualDeleteCount = deleteCount or 0
        if actualDeleteCount < 0 then
            actualDeleteCount = 0
        end
        if actualDeleteCount > len - start then
            actualDeleteCount = len - start
        end
    end
    local out = {}
    for k = 1, actualDeleteCount do
        local from = start + k
        if self[from] ~= nil then
            out[k] = self[from]
        end
    end
    if itemCount < actualDeleteCount then
        for k = start + 1, len - actualDeleteCount do
            local from = k + actualDeleteCount
            local to = k + itemCount
            if self[from] then
                self[to] = self[from]
            else
                self[to] = nil
            end
        end
        for k = len - actualDeleteCount + itemCount + 1, len do
            self[k] = nil
        end
    elseif itemCount > actualDeleteCount then
        for k = len - actualDeleteCount, start + 1, -1 do
            local from = k + actualDeleteCount
            local to = k + itemCount
            if self[from] then
                self[to] = self[from]
            else
                self[to] = nil
            end
        end
    end
    local j = start + 1
    for i = 3, actualArgumentCount do
        self[j] = args[i]
        j = j + 1
    end
    for k = #self, len - actualDeleteCount + itemCount + 1, -1 do
        self[k] = nil
    end
    return out
end

local function __TS__ArrayToObject(self)
    local object = {}
    for i = 1, #self do
        object[i - 1] = self[i]
    end
    return object
end

local function __TS__ArrayFlat(self, depth)
    if depth == nil then
        depth = 1
    end
    local result = {}
    local len = 0
    for i = 1, #self do
        local value = self[i]
        if depth > 0 and __TS__ArrayIsArray(value) then
            local toAdd
            if depth == 1 then
                toAdd = value
            else
                toAdd = __TS__ArrayFlat(value, depth - 1)
            end
            for j = 1, #toAdd do
                local val = toAdd[j]
                len = len + 1
                result[len] = val
            end
        else
            len = len + 1
            result[len] = value
        end
    end
    return result
end

local function __TS__ArrayFlatMap(self, callback, thisArg)
    local result = {}
    local len = 0
    for i = 1, #self do
        local value = callback(thisArg, self[i], i - 1, self)
        if __TS__ArrayIsArray(value) then
            for j = 1, #value do
                len = len + 1
                result[len] = value[j]
            end
        else
            len = len + 1
            result[len] = value
        end
    end
    return result
end

local function __TS__ArraySetLength(self, length)
    if length < 0 or length ~= length or length == math.huge or math.floor(length) ~= length then
        error(
            "invalid array length: " .. tostring(length),
            0
        )
    end
    for i = length + 1, #self do
        self[i] = nil
    end
    return length
end

local __TS__Unpack = table.unpack or unpack

local function __TS__ArrayToReversed(self)
    local copy = {__TS__Unpack(self)}
    __TS__ArrayReverse(copy)
    return copy
end

local function __TS__ArrayToSorted(self, compareFn)
    local copy = {__TS__Unpack(self)}
    __TS__ArraySort(copy, compareFn)
    return copy
end

local function __TS__ArrayToSpliced(self, start, deleteCount, ...)
    local copy = {__TS__Unpack(self)}
    __TS__ArraySplice(copy, start, deleteCount, ...)
    return copy
end

local function __TS__ArrayWith(self, index, value)
    local copy = {__TS__Unpack(self)}
    copy[index + 1] = value
    return copy
end

local function __TS__New(target, ...)
    local instance = setmetatable({}, target.prototype)
    instance:____constructor(...)
    return instance
end

local function __TS__InstanceOf(obj, classTbl)
    if type(classTbl) ~= "table" then
        error("Right-hand side of 'instanceof' is not an object", 0)
    end
    if classTbl[Symbol.hasInstance] ~= nil then
        return not not classTbl[Symbol.hasInstance](classTbl, obj)
    end
    if type(obj) == "table" then
        local luaClass = obj.constructor
        while luaClass ~= nil do
            if luaClass == classTbl then
                return true
            end
            luaClass = luaClass.____super
        end
    end
    return false
end

local function __TS__Class(self)
    local c = {prototype = {}}
    c.prototype.__index = c.prototype
    c.prototype.constructor = c
    return c
end

local __TS__Promise
do
    local function makeDeferredPromiseFactory()
        local resolve
        local reject
        local function executor(____, res, rej)
            resolve = res
            reject = rej
        end
        return function()
            local promise = __TS__New(__TS__Promise, executor)
            return promise, resolve, reject
        end
    end
    local makeDeferredPromise = makeDeferredPromiseFactory()
    local function isPromiseLike(value)
        return __TS__InstanceOf(value, __TS__Promise)
    end
    local function doNothing(self)
    end
    local ____pcall = _G.pcall
    __TS__Promise = __TS__Class()
    __TS__Promise.name = "__TS__Promise"
    function __TS__Promise.prototype.____constructor(self, executor)
        self.state = 0
        self.fulfilledCallbacks = {}
        self.rejectedCallbacks = {}
        self.finallyCallbacks = {}
        local success, ____error = ____pcall(
            executor,
            nil,
            function(____, v) return self:resolve(v) end,
            function(____, err) return self:reject(err) end
        )
        if not success then
            self:reject(____error)
        end
    end
    function __TS__Promise.resolve(value)
        if __TS__InstanceOf(value, __TS__Promise) then
            return value
        end
        local promise = __TS__New(__TS__Promise, doNothing)
        promise.state = 1
        promise.value = value
        return promise
    end
    function __TS__Promise.reject(reason)
        local promise = __TS__New(__TS__Promise, doNothing)
        promise.state = 2
        promise.rejectionReason = reason
        return promise
    end
    __TS__Promise.prototype["then"] = function(self, onFulfilled, onRejected)
        local promise, resolve, reject = makeDeferredPromise()
        self:addCallbacks(
            onFulfilled and self:createPromiseResolvingCallback(onFulfilled, resolve, reject) or resolve,
            onRejected and self:createPromiseResolvingCallback(onRejected, resolve, reject) or reject
        )
        return promise
    end
    function __TS__Promise.prototype.addCallbacks(self, fulfilledCallback, rejectedCallback)
        if self.state == 1 then
            return fulfilledCallback(nil, self.value)
        end
        if self.state == 2 then
            return rejectedCallback(nil, self.rejectionReason)
        end
        local ____self_fulfilledCallbacks_0 = self.fulfilledCallbacks
        ____self_fulfilledCallbacks_0[#____self_fulfilledCallbacks_0 + 1] = fulfilledCallback
        local ____self_rejectedCallbacks_1 = self.rejectedCallbacks
        ____self_rejectedCallbacks_1[#____self_rejectedCallbacks_1 + 1] = rejectedCallback
    end
    function __TS__Promise.prototype.catch(self, onRejected)
        return self["then"](self, nil, onRejected)
    end
    function __TS__Promise.prototype.finally(self, onFinally)
        if onFinally then
            local ____self_finallyCallbacks_2 = self.finallyCallbacks
            ____self_finallyCallbacks_2[#____self_finallyCallbacks_2 + 1] = onFinally
            if self.state ~= 0 then
                onFinally(nil)
            end
        end
        return self
    end
    function __TS__Promise.prototype.resolve(self, value)
        if isPromiseLike(value) then
            return value:addCallbacks(
                function(____, v) return self:resolve(v) end,
                function(____, err) return self:reject(err) end
            )
        end
        if self.state == 0 then
            self.state = 1
            self.value = value
            return self:invokeCallbacks(self.fulfilledCallbacks, value)
        end
    end
    function __TS__Promise.prototype.reject(self, reason)
        if self.state == 0 then
            self.state = 2
            self.rejectionReason = reason
            return self:invokeCallbacks(self.rejectedCallbacks, reason)
        end
    end
    function __TS__Promise.prototype.invokeCallbacks(self, callbacks, value)
        local callbacksLength = #callbacks
        local finallyCallbacks = self.finallyCallbacks
        local finallyCallbacksLength = #finallyCallbacks
        if callbacksLength ~= 0 then
            for i = 1, callbacksLength - 1 do
                callbacks[i](callbacks, value)
            end
            if finallyCallbacksLength == 0 then
                return callbacks[callbacksLength](callbacks, value)
            end
            callbacks[callbacksLength](callbacks, value)
        end
        if finallyCallbacksLength ~= 0 then
            for i = 1, finallyCallbacksLength - 1 do
                finallyCallbacks[i](finallyCallbacks)
            end
            return finallyCallbacks[finallyCallbacksLength](finallyCallbacks)
        end
    end
    function __TS__Promise.prototype.createPromiseResolvingCallback(self, f, resolve, reject)
        return function(____, value)
            local success, resultOrError = ____pcall(f, nil, value)
            if not success then
                return reject(nil, resultOrError)
            end
            return self:handleCallbackValue(resultOrError, resolve, reject)
        end
    end
    function __TS__Promise.prototype.handleCallbackValue(self, value, resolve, reject)
        if isPromiseLike(value) then
            local nextpromise = value
            if nextpromise.state == 1 then
                return resolve(nil, nextpromise.value)
            elseif nextpromise.state == 2 then
                return reject(nil, nextpromise.rejectionReason)
            else
                return nextpromise:addCallbacks(resolve, reject)
            end
        else
            return resolve(nil, value)
        end
    end
end

local __TS__AsyncAwaiter, __TS__Await
do
    local ____coroutine = _G.coroutine or ({})
    local cocreate = ____coroutine.create
    local coresume = ____coroutine.resume
    local costatus = ____coroutine.status
    local coyield = ____coroutine.yield
    function __TS__AsyncAwaiter(generator)
        return __TS__New(
            __TS__Promise,
            function(____, resolve, reject)
                local fulfilled, step, resolved, asyncCoroutine
                function fulfilled(self, value)
                    local success, resultOrError = coresume(asyncCoroutine, value)
                    if success then
                        return step(resultOrError)
                    end
                    return reject(nil, resultOrError)
                end
                function step(result)
                    if resolved then
                        return
                    end
                    if costatus(asyncCoroutine) == "dead" then
                        return resolve(nil, result)
                    end
                    return __TS__Promise.resolve(result):addCallbacks(fulfilled, reject)
                end
                resolved = false
                asyncCoroutine = cocreate(generator)
                local success, resultOrError = coresume(
                    asyncCoroutine,
                    function(____, v)
                        resolved = true
                        return __TS__Promise.resolve(v):addCallbacks(resolve, reject)
                    end
                )
                if success then
                    return step(resultOrError)
                else
                    return reject(nil, resultOrError)
                end
            end
        )
    end
    function __TS__Await(thing)
        return coyield(thing)
    end
end

local function __TS__ClassExtends(target, base)
    target.____super = base
    local staticMetatable = setmetatable({__index = base}, base)
    setmetatable(target, staticMetatable)
    local baseMetatable = getmetatable(base)
    if baseMetatable then
        if type(baseMetatable.__index) == "function" then
            staticMetatable.__index = baseMetatable.__index
        end
        if type(baseMetatable.__newindex) == "function" then
            staticMetatable.__newindex = baseMetatable.__newindex
        end
    end
    setmetatable(target.prototype, base.prototype)
    if type(base.prototype.__index) == "function" then
        target.prototype.__index = base.prototype.__index
    end
    if type(base.prototype.__newindex) == "function" then
        target.prototype.__newindex = base.prototype.__newindex
    end
    if type(base.prototype.__tostring) == "function" then
        target.prototype.__tostring = base.prototype.__tostring
    end
end

local function __TS__CloneDescriptor(____bindingPattern0)
    local value
    local writable
    local set
    local get
    local configurable
    local enumerable
    enumerable = ____bindingPattern0.enumerable
    configurable = ____bindingPattern0.configurable
    get = ____bindingPattern0.get
    set = ____bindingPattern0.set
    writable = ____bindingPattern0.writable
    value = ____bindingPattern0.value
    local descriptor = {enumerable = enumerable == true, configurable = configurable == true}
    local hasGetterOrSetter = get ~= nil or set ~= nil
    local hasValueOrWritableAttribute = writable ~= nil or value ~= nil
    if hasGetterOrSetter and hasValueOrWritableAttribute then
        error("Invalid property descriptor. Cannot both specify accessors and a value or writable attribute.", 0)
    end
    if get or set then
        descriptor.get = get
        descriptor.set = set
    else
        descriptor.value = value
        descriptor.writable = writable == true
    end
    return descriptor
end

local function __TS__Decorate(self, originalValue, decorators, context)
    local result = originalValue
    do
        local i = #decorators
        while i >= 0 do
            local decorator = decorators[i + 1]
            if decorator ~= nil then
                local ____decorator_result_0 = decorator(self, result, context)
                if ____decorator_result_0 == nil then
                    ____decorator_result_0 = result
                end
                result = ____decorator_result_0
            end
            i = i - 1
        end
    end
    return result
end

local function __TS__ObjectAssign(target, ...)
    local sources = {...}
    for i = 1, #sources do
        local source = sources[i]
        for key in pairs(source) do
            target[key] = source[key]
        end
    end
    return target
end

local function __TS__ObjectGetOwnPropertyDescriptor(object, key)
    local metatable = getmetatable(object)
    if not metatable then
        return
    end
    if not rawget(metatable, "_descriptors") then
        return
    end
    return rawget(metatable, "_descriptors")[key]
end

local __TS__DescriptorGet
do
    local getmetatable = _G.getmetatable
    local ____rawget = _G.rawget
    function __TS__DescriptorGet(self, metatable, key)
        while metatable do
            local rawResult = ____rawget(metatable, key)
            if rawResult ~= nil then
                return rawResult
            end
            local descriptors = ____rawget(metatable, "_descriptors")
            if descriptors then
                local descriptor = descriptors[key]
                if descriptor ~= nil then
                    if descriptor.get then
                        return descriptor.get(self)
                    end
                    return descriptor.value
                end
            end
            metatable = getmetatable(metatable)
        end
    end
end

local __TS__DescriptorSet
do
    local getmetatable = _G.getmetatable
    local ____rawget = _G.rawget
    local rawset = _G.rawset
    function __TS__DescriptorSet(self, metatable, key, value)
        while metatable do
            local descriptors = ____rawget(metatable, "_descriptors")
            if descriptors then
                local descriptor = descriptors[key]
                if descriptor ~= nil then
                    if descriptor.set then
                        descriptor.set(self, value)
                    else
                        if descriptor.writable == false then
                            error(
                                ((("Cannot assign to read only property '" .. key) .. "' of object '") .. tostring(self)) .. "'",
                                0
                            )
                        end
                        descriptor.value = value
                    end
                    return
                end
            end
            metatable = getmetatable(metatable)
        end
        rawset(self, key, value)
    end
end

local __TS__SetDescriptor
do
    local getmetatable = _G.getmetatable
    local function descriptorIndex(self, key)
        return __TS__DescriptorGet(
            self,
            getmetatable(self),
            key
        )
    end
    local function descriptorNewIndex(self, key, value)
        return __TS__DescriptorSet(
            self,
            getmetatable(self),
            key,
            value
        )
    end
    function __TS__SetDescriptor(target, key, desc, isPrototype)
        if isPrototype == nil then
            isPrototype = false
        end
        local ____isPrototype_0
        if isPrototype then
            ____isPrototype_0 = target
        else
            ____isPrototype_0 = getmetatable(target)
        end
        local metatable = ____isPrototype_0
        if not metatable then
            metatable = {}
            setmetatable(target, metatable)
        end
        local value = rawget(target, key)
        if value ~= nil then
            rawset(target, key, nil)
        end
        if not rawget(metatable, "_descriptors") then
            metatable._descriptors = {}
        end
        metatable._descriptors[key] = __TS__CloneDescriptor(desc)
        metatable.__index = descriptorIndex
        metatable.__newindex = descriptorNewIndex
    end
end

local function __TS__DecorateLegacy(decorators, target, key, desc)
    local result = target
    do
        local i = #decorators
        while i >= 0 do
            local decorator = decorators[i + 1]
            if decorator ~= nil then
                local oldResult = result
                if key == nil then
                    result = decorator(nil, result)
                elseif desc == true then
                    local value = rawget(target, key)
                    local descriptor = __TS__ObjectGetOwnPropertyDescriptor(target, key) or ({configurable = true, writable = true, value = value})
                    local desc = decorator(nil, target, key, descriptor) or descriptor
                    local isSimpleValue = desc.configurable == true and desc.writable == true and not desc.get and not desc.set
                    if isSimpleValue then
                        rawset(target, key, desc.value)
                    else
                        __TS__SetDescriptor(
                            target,
                            key,
                            __TS__ObjectAssign({}, descriptor, desc)
                        )
                    end
                elseif desc == false then
                    result = decorator(nil, target, key, desc)
                else
                    result = decorator(nil, target, key)
                end
                result = result or oldResult
            end
            i = i - 1
        end
    end
    return result
end

local function __TS__DecorateParam(paramIndex, decorator)
    return function(____, target, key) return decorator(nil, target, key, paramIndex) end
end

local function __TS__StringIncludes(self, searchString, position)
    if not position then
        position = 1
    else
        position = position + 1
    end
    local index = string.find(self, searchString, position, true)
    return index ~= nil
end

local Error, RangeError, ReferenceError, SyntaxError, TypeError, URIError
do
    local function getErrorStack(self, constructor)
        if debug == nil then
            return nil
        end
        local level = 1
        while true do
            local info = debug.getinfo(level, "f")
            level = level + 1
            if not info then
                level = 1
                break
            elseif info.func == constructor then
                break
            end
        end
        if __TS__StringIncludes(_VERSION, "Lua 5.0") then
            return debug.traceback(("[Level " .. tostring(level)) .. "]")
        else
            return debug.traceback(nil, level)
        end
    end
    local function wrapErrorToString(self, getDescription)
        return function(self)
            local description = getDescription(self)
            local caller = debug.getinfo(3, "f")
            local isClassicLua = __TS__StringIncludes(_VERSION, "Lua 5.0") or _VERSION == "Lua 5.1"
            if isClassicLua or caller and caller.func ~= error then
                return description
            else
                return (description .. "\n") .. tostring(self.stack)
            end
        end
    end
    local function initErrorClass(self, Type, name)
        Type.name = name
        return setmetatable(
            Type,
            {__call = function(____, _self, message) return __TS__New(Type, message) end}
        )
    end
    local ____initErrorClass_1 = initErrorClass
    local ____class_0 = __TS__Class()
    ____class_0.name = ""
    function ____class_0.prototype.____constructor(self, message)
        if message == nil then
            message = ""
        end
        self.message = message
        self.name = "Error"
        self.stack = getErrorStack(nil, self.constructor.new)
        local metatable = getmetatable(self)
        if metatable and not metatable.__errorToStringPatched then
            metatable.__errorToStringPatched = true
            metatable.__tostring = wrapErrorToString(nil, metatable.__tostring)
        end
    end
    function ____class_0.prototype.__tostring(self)
        return self.message ~= "" and (self.name .. ": ") .. self.message or self.name
    end
    Error = ____initErrorClass_1(nil, ____class_0, "Error")
    local function createErrorClass(self, name)
        local ____initErrorClass_3 = initErrorClass
        local ____class_2 = __TS__Class()
        ____class_2.name = ____class_2.name
        __TS__ClassExtends(____class_2, Error)
        function ____class_2.prototype.____constructor(self, ...)
            ____class_2.____super.prototype.____constructor(self, ...)
            self.name = name
        end
        return ____initErrorClass_3(nil, ____class_2, name)
    end
    RangeError = createErrorClass(nil, "RangeError")
    ReferenceError = createErrorClass(nil, "ReferenceError")
    SyntaxError = createErrorClass(nil, "SyntaxError")
    TypeError = createErrorClass(nil, "TypeError")
    URIError = createErrorClass(nil, "URIError")
end

local function __TS__ObjectGetOwnPropertyDescriptors(object)
    local metatable = getmetatable(object)
    if not metatable then
        return {}
    end
    return rawget(metatable, "_descriptors") or ({})
end

local function __TS__Delete(target, key)
    local descriptors = __TS__ObjectGetOwnPropertyDescriptors(target)
    local descriptor = descriptors[key]
    if descriptor then
        if not descriptor.configurable then
            error(
                __TS__New(
                    TypeError,
                    ((("Cannot delete property " .. tostring(key)) .. " of ") .. tostring(target)) .. "."
                ),
                0
            )
        end
        descriptors[key] = nil
        return true
    end
    target[key] = nil
    return true
end

local function __TS__StringAccess(self, index)
    if index >= 0 and index < #self then
        return string.sub(self, index + 1, index + 1)
    end
end

local function __TS__DelegatedYield(iterable)
    if type(iterable) == "string" then
        for index = 0, #iterable - 1 do
            coroutine.yield(__TS__StringAccess(iterable, index))
        end
    elseif iterable.____coroutine ~= nil then
        local co = iterable.____coroutine
        while true do
            local status, value = coroutine.resume(co)
            if not status then
                error(value, 0)
            end
            if coroutine.status(co) == "dead" then
                return value
            else
                coroutine.yield(value)
            end
        end
    elseif iterable[Symbol.iterator] then
        local iterator = iterable[Symbol.iterator](iterable)
        while true do
            local result = iterator:next()
            if result.done then
                return result.value
            else
                coroutine.yield(result.value)
            end
        end
    else
        for ____, value in ipairs(iterable) do
            coroutine.yield(value)
        end
    end
end

local function __TS__FunctionBind(fn, ...)
    local boundArgs = {...}
    return function(____, ...)
        local args = {...}
        __TS__ArrayUnshift(
            args,
            __TS__Unpack(boundArgs)
        )
        return fn(__TS__Unpack(args))
    end
end

local __TS__Generator
do
    local function generatorIterator(self)
        return self
    end
    local function generatorNext(self, ...)
        local co = self.____coroutine
        if coroutine.status(co) == "dead" then
            return {done = true}
        end
        local status, value = coroutine.resume(co, ...)
        if not status then
            error(value, 0)
        end
        return {
            value = value,
            done = coroutine.status(co) == "dead"
        }
    end
    function __TS__Generator(fn)
        return function(...)
            local args = {...}
            local argsLength = __TS__CountVarargs(...)
            return {
                ____coroutine = coroutine.create(function() return fn(__TS__Unpack(args, 1, argsLength)) end),
                [Symbol.iterator] = generatorIterator,
                next = generatorNext
            }
        end
    end
end

local function __TS__InstanceOfObject(value)
    local valueType = type(value)
    return valueType == "table" or valueType == "function"
end

local function __TS__LuaIteratorSpread(self, state, firstKey)
    local results = {}
    local key, value = self(state, firstKey)
    while key do
        results[#results + 1] = {key, value}
        key, value = self(state, key)
    end
    return __TS__Unpack(results)
end

local Map
do
    Map = __TS__Class()
    Map.name = "Map"
    function Map.prototype.____constructor(self, entries)
        self[Symbol.toStringTag] = "Map"
        self.items = {}
        self.size = 0
        self.nextKey = {}
        self.previousKey = {}
        if entries == nil then
            return
        end
        local iterable = entries
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                local value = result.value
                self:set(value[1], value[2])
            end
        else
            local array = entries
            for ____, kvp in ipairs(array) do
                self:set(kvp[1], kvp[2])
            end
        end
    end
    function Map.prototype.clear(self)
        self.items = {}
        self.nextKey = {}
        self.previousKey = {}
        self.firstKey = nil
        self.lastKey = nil
        self.size = 0
    end
    function Map.prototype.delete(self, key)
        local contains = self:has(key)
        if contains then
            self.size = self.size - 1
            local next = self.nextKey[key]
            local previous = self.previousKey[key]
            if next ~= nil and previous ~= nil then
                self.nextKey[previous] = next
                self.previousKey[next] = previous
            elseif next ~= nil then
                self.firstKey = next
                self.previousKey[next] = nil
            elseif previous ~= nil then
                self.lastKey = previous
                self.nextKey[previous] = nil
            else
                self.firstKey = nil
                self.lastKey = nil
            end
            self.nextKey[key] = nil
            self.previousKey[key] = nil
        end
        self.items[key] = nil
        return contains
    end
    function Map.prototype.forEach(self, callback)
        for ____, key in __TS__Iterator(self:keys()) do
            callback(nil, self.items[key], key, self)
        end
    end
    function Map.prototype.get(self, key)
        return self.items[key]
    end
    function Map.prototype.has(self, key)
        return self.nextKey[key] ~= nil or self.lastKey == key
    end
    function Map.prototype.set(self, key, value)
        local isNewValue = not self:has(key)
        if isNewValue then
            self.size = self.size + 1
        end
        self.items[key] = value
        if self.firstKey == nil then
            self.firstKey = key
            self.lastKey = key
        elseif isNewValue then
            self.nextKey[self.lastKey] = key
            self.previousKey[key] = self.lastKey
            self.lastKey = key
        end
        return self
    end
    Map.prototype[Symbol.iterator] = function(self)
        return self:entries()
    end
    function Map.prototype.entries(self)
        local items = self.items
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = {key, items[key]}}
                key = nextKey[key]
                return result
            end
        }
    end
    function Map.prototype.keys(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Map.prototype.values(self)
        local items = self.items
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = items[key]}
                key = nextKey[key]
                return result
            end
        }
    end
    Map[Symbol.species] = Map
end

local function __TS__MapGroupBy(items, keySelector)
    local result = __TS__New(Map)
    local i = 0
    for ____, item in __TS__Iterator(items) do
        local key = keySelector(nil, item, i)
        if result:has(key) then
            local ____temp_0 = result:get(key)
            ____temp_0[#____temp_0 + 1] = item
        else
            result:set(key, {item})
        end
        i = i + 1
    end
    return result
end

local __TS__Match = string.match

local __TS__MathAtan2 = math.atan2 or math.atan

local __TS__MathModf = math.modf

local function __TS__NumberIsNaN(value)
    return value ~= value
end

local function __TS__MathSign(val)
    if __TS__NumberIsNaN(val) or val == 0 then
        return val
    end
    if val < 0 then
        return -1
    end
    return 1
end

local function __TS__NumberIsFinite(value)
    return type(value) == "number" and value == value and value ~= math.huge and value ~= -math.huge
end

local function __TS__MathTrunc(val)
    if not __TS__NumberIsFinite(val) or val == 0 then
        return val
    end
    return val > 0 and math.floor(val) or math.ceil(val)
end

local function __TS__Number(value)
    local valueType = type(value)
    if valueType == "number" then
        return value
    elseif valueType == "string" then
        local numberValue = tonumber(value)
        if numberValue then
            return numberValue
        end
        if value == "Infinity" then
            return math.huge
        end
        if value == "-Infinity" then
            return -math.huge
        end
        local stringWithoutSpaces = string.gsub(value, "%s", "")
        if stringWithoutSpaces == "" then
            return 0
        end
        return 0 / 0
    elseif valueType == "boolean" then
        return value and 1 or 0
    else
        return 0 / 0
    end
end

local function __TS__NumberIsInteger(value)
    return __TS__NumberIsFinite(value) and math.floor(value) == value
end

local function __TS__StringSubstring(self, start, ____end)
    if ____end ~= ____end then
        ____end = 0
    end
    if ____end ~= nil and start > ____end then
        start, ____end = ____end, start
    end
    if start >= 0 then
        start = start + 1
    else
        start = 1
    end
    if ____end ~= nil and ____end < 0 then
        ____end = 0
    end
    return string.sub(self, start, ____end)
end

local __TS__ParseInt
do
    local parseIntBasePattern = "0123456789aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPqQrRsStTvVwWxXyYzZ"
    function __TS__ParseInt(numberString, base)
        if base == nil then
            base = 10
            local hexMatch = __TS__Match(numberString, "^%s*-?0[xX]")
            if hexMatch ~= nil then
                base = 16
                numberString = (__TS__Match(hexMatch, "-")) and "-" .. __TS__StringSubstring(numberString, #hexMatch) or __TS__StringSubstring(numberString, #hexMatch)
            end
        end
        if base < 2 or base > 36 then
            return 0 / 0
        end
        local allowedDigits = base <= 10 and __TS__StringSubstring(parseIntBasePattern, 0, base) or __TS__StringSubstring(parseIntBasePattern, 0, 10 + 2 * (base - 10))
        local pattern = ("^%s*(-?[" .. allowedDigits) .. "]*)"
        local number = tonumber((__TS__Match(numberString, pattern)), base)
        if number == nil then
            return 0 / 0
        end
        if number >= 0 then
            return math.floor(number)
        else
            return math.ceil(number)
        end
    end
end

local function __TS__ParseFloat(numberString)
    local infinityMatch = __TS__Match(numberString, "^%s*(-?Infinity)")
    if infinityMatch ~= nil then
        return __TS__StringAccess(infinityMatch, 0) == "-" and -math.huge or math.huge
    end
    local number = tonumber((__TS__Match(numberString, "^%s*(-?%d+%.?%d*)")))
    return number or 0 / 0
end

local __TS__NumberToString
do
    local radixChars = "0123456789abcdefghijklmnopqrstuvwxyz"
    function __TS__NumberToString(self, radix)
        if radix == nil or radix == 10 or self == math.huge or self == -math.huge or self ~= self then
            return tostring(self)
        end
        radix = math.floor(radix)
        if radix < 2 or radix > 36 then
            error("toString() radix argument must be between 2 and 36", 0)
        end
        local integer, fraction = __TS__MathModf(math.abs(self))
        local result = ""
        if radix == 8 then
            result = string.format("%o", integer)
        elseif radix == 16 then
            result = string.format("%x", integer)
        else
            repeat
                do
                    result = __TS__StringAccess(radixChars, integer % radix) .. result
                    integer = math.floor(integer / radix)
                end
            until not (integer ~= 0)
        end
        if fraction ~= 0 then
            result = result .. "."
            local delta = 1e-16
            repeat
                do
                    fraction = fraction * radix
                    delta = delta * radix
                    local digit = math.floor(fraction)
                    result = result .. __TS__StringAccess(radixChars, digit)
                    fraction = fraction - digit
                end
            until not (fraction >= delta)
        end
        if self < 0 then
            result = "-" .. result
        end
        return result
    end
end

local function __TS__NumberToFixed(self, fractionDigits)
    if math.abs(self) >= 1e+21 or self ~= self then
        return tostring(self)
    end
    local f = math.floor(fractionDigits or 0)
    if f < 0 or f > 99 then
        error("toFixed() digits argument must be between 0 and 99", 0)
    end
    return string.format(
        ("%." .. tostring(f)) .. "f",
        self
    )
end

local function __TS__ObjectDefineProperty(target, key, desc)
    local luaKey = type(key) == "number" and key + 1 or key
    local value = rawget(target, luaKey)
    local hasGetterOrSetter = desc.get ~= nil or desc.set ~= nil
    local descriptor
    if hasGetterOrSetter then
        if value ~= nil then
            error(
                "Cannot redefine property: " .. tostring(key),
                0
            )
        end
        descriptor = desc
    else
        local valueExists = value ~= nil
        local ____desc_set_4 = desc.set
        local ____desc_get_5 = desc.get
        local ____desc_configurable_0 = desc.configurable
        if ____desc_configurable_0 == nil then
            ____desc_configurable_0 = valueExists
        end
        local ____desc_enumerable_1 = desc.enumerable
        if ____desc_enumerable_1 == nil then
            ____desc_enumerable_1 = valueExists
        end
        local ____desc_writable_2 = desc.writable
        if ____desc_writable_2 == nil then
            ____desc_writable_2 = valueExists
        end
        local ____temp_3
        if desc.value ~= nil then
            ____temp_3 = desc.value
        else
            ____temp_3 = value
        end
        descriptor = {
            set = ____desc_set_4,
            get = ____desc_get_5,
            configurable = ____desc_configurable_0,
            enumerable = ____desc_enumerable_1,
            writable = ____desc_writable_2,
            value = ____temp_3
        }
    end
    __TS__SetDescriptor(target, luaKey, descriptor)
    return target
end

local function __TS__ObjectEntries(obj)
    local result = {}
    local len = 0
    for key in pairs(obj) do
        len = len + 1
        result[len] = {key, obj[key]}
    end
    return result
end

local function __TS__ObjectFromEntries(entries)
    local obj = {}
    local iterable = entries
    if iterable[Symbol.iterator] then
        local iterator = iterable[Symbol.iterator](iterable)
        while true do
            local result = iterator:next()
            if result.done then
                break
            end
            local value = result.value
            obj[value[1]] = value[2]
        end
    else
        for ____, entry in ipairs(entries) do
            obj[entry[1]] = entry[2]
        end
    end
    return obj
end

local function __TS__ObjectGroupBy(items, keySelector)
    local result = {}
    local i = 0
    for ____, item in __TS__Iterator(items) do
        local key = keySelector(nil, item, i)
        if result[key] ~= nil then
            local ____result_key_0 = result[key]
            ____result_key_0[#____result_key_0 + 1] = item
        else
            result[key] = {item}
        end
        i = i + 1
    end
    return result
end

local function __TS__ObjectKeys(obj)
    local result = {}
    local len = 0
    for key in pairs(obj) do
        len = len + 1
        result[len] = key
    end
    return result
end

local function __TS__ObjectRest(target, usedProperties)
    local result = {}
    for property in pairs(target) do
        if not usedProperties[property] then
            result[property] = target[property]
        end
    end
    return result
end

local function __TS__ObjectValues(obj)
    local result = {}
    local len = 0
    for key in pairs(obj) do
        len = len + 1
        result[len] = obj[key]
    end
    return result
end

local function __TS__PromiseAll(iterable)
    local results = {}
    local toResolve = {}
    local numToResolve = 0
    local i = 0
    for ____, item in __TS__Iterator(iterable) do
        if __TS__InstanceOf(item, __TS__Promise) then
            if item.state == 1 then
                results[i + 1] = item.value
            elseif item.state == 2 then
                return __TS__Promise.reject(item.rejectionReason)
            else
                numToResolve = numToResolve + 1
                toResolve[i] = item
            end
        else
            results[i + 1] = item
        end
        i = i + 1
    end
    if numToResolve == 0 then
        return __TS__Promise.resolve(results)
    end
    return __TS__New(
        __TS__Promise,
        function(____, resolve, reject)
            for index, promise in pairs(toResolve) do
                promise["then"](
                    promise,
                    function(____, data)
                        results[index + 1] = data
                        numToResolve = numToResolve - 1
                        if numToResolve == 0 then
                            resolve(nil, results)
                        end
                    end,
                    function(____, reason)
                        reject(nil, reason)
                    end
                )
            end
        end
    )
end

local function __TS__PromiseAllSettled(iterable)
    local results = {}
    local toResolve = {}
    local numToResolve = 0
    local i = 0
    for ____, item in __TS__Iterator(iterable) do
        if __TS__InstanceOf(item, __TS__Promise) then
            if item.state == 1 then
                results[i + 1] = {status = "fulfilled", value = item.value}
            elseif item.state == 2 then
                results[i + 1] = {status = "rejected", reason = item.rejectionReason}
            else
                numToResolve = numToResolve + 1
                toResolve[i] = item
            end
        else
            results[i + 1] = {status = "fulfilled", value = item}
        end
        i = i + 1
    end
    if numToResolve == 0 then
        return __TS__Promise.resolve(results)
    end
    return __TS__New(
        __TS__Promise,
        function(____, resolve)
            for index, promise in pairs(toResolve) do
                promise["then"](
                    promise,
                    function(____, data)
                        results[index + 1] = {status = "fulfilled", value = data}
                        numToResolve = numToResolve - 1
                        if numToResolve == 0 then
                            resolve(nil, results)
                        end
                    end,
                    function(____, reason)
                        results[index + 1] = {status = "rejected", reason = reason}
                        numToResolve = numToResolve - 1
                        if numToResolve == 0 then
                            resolve(nil, results)
                        end
                    end
                )
            end
        end
    )
end

local function __TS__PromiseAny(iterable)
    local rejections = {}
    local pending = {}
    for ____, item in __TS__Iterator(iterable) do
        if __TS__InstanceOf(item, __TS__Promise) then
            if item.state == 1 then
                return __TS__Promise.resolve(item.value)
            elseif item.state == 2 then
                rejections[#rejections + 1] = item.rejectionReason
            else
                pending[#pending + 1] = item
            end
        else
            return __TS__Promise.resolve(item)
        end
    end
    if #pending == 0 then
        return __TS__Promise.reject("No promises to resolve with .any()")
    end
    local numResolved = 0
    return __TS__New(
        __TS__Promise,
        function(____, resolve, reject)
            for ____, promise in ipairs(pending) do
                promise["then"](
                    promise,
                    function(____, data)
                        resolve(nil, data)
                    end,
                    function(____, reason)
                        rejections[#rejections + 1] = reason
                        numResolved = numResolved + 1
                        if numResolved == #pending then
                            reject(nil, {name = "AggregateError", message = "All Promises rejected", errors = rejections})
                        end
                    end
                )
            end
        end
    )
end

local function __TS__PromiseRace(iterable)
    local pending = {}
    for ____, item in __TS__Iterator(iterable) do
        if __TS__InstanceOf(item, __TS__Promise) then
            if item.state == 1 then
                return __TS__Promise.resolve(item.value)
            elseif item.state == 2 then
                return __TS__Promise.reject(item.rejectionReason)
            else
                pending[#pending + 1] = item
            end
        else
            return __TS__Promise.resolve(item)
        end
    end
    return __TS__New(
        __TS__Promise,
        function(____, resolve, reject)
            for ____, promise in ipairs(pending) do
                promise["then"](
                    promise,
                    function(____, value) return resolve(nil, value) end,
                    function(____, reason) return reject(nil, reason) end
                )
            end
        end
    )
end

local Set
do
    Set = __TS__Class()
    Set.name = "Set"
    function Set.prototype.____constructor(self, values)
        self[Symbol.toStringTag] = "Set"
        self.size = 0
        self.nextKey = {}
        self.previousKey = {}
        if values == nil then
            return
        end
        local iterable = values
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                self:add(result.value)
            end
        else
            local array = values
            for ____, value in ipairs(array) do
                self:add(value)
            end
        end
    end
    function Set.prototype.add(self, value)
        local isNewValue = not self:has(value)
        if isNewValue then
            self.size = self.size + 1
        end
        if self.firstKey == nil then
            self.firstKey = value
            self.lastKey = value
        elseif isNewValue then
            self.nextKey[self.lastKey] = value
            self.previousKey[value] = self.lastKey
            self.lastKey = value
        end
        return self
    end
    function Set.prototype.clear(self)
        self.nextKey = {}
        self.previousKey = {}
        self.firstKey = nil
        self.lastKey = nil
        self.size = 0
    end
    function Set.prototype.delete(self, value)
        local contains = self:has(value)
        if contains then
            self.size = self.size - 1
            local next = self.nextKey[value]
            local previous = self.previousKey[value]
            if next ~= nil and previous ~= nil then
                self.nextKey[previous] = next
                self.previousKey[next] = previous
            elseif next ~= nil then
                self.firstKey = next
                self.previousKey[next] = nil
            elseif previous ~= nil then
                self.lastKey = previous
                self.nextKey[previous] = nil
            else
                self.firstKey = nil
                self.lastKey = nil
            end
            self.nextKey[value] = nil
            self.previousKey[value] = nil
        end
        return contains
    end
    function Set.prototype.forEach(self, callback)
        for ____, key in __TS__Iterator(self:keys()) do
            callback(nil, key, key, self)
        end
    end
    function Set.prototype.has(self, value)
        return self.nextKey[value] ~= nil or self.lastKey == value
    end
    Set.prototype[Symbol.iterator] = function(self)
        return self:values()
    end
    function Set.prototype.entries(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = {key, key}}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.keys(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.values(self)
        local nextKey = self.nextKey
        local key = self.firstKey
        return {
            [Symbol.iterator] = function(self)
                return self
            end,
            next = function(self)
                local result = {done = not key, value = key}
                key = nextKey[key]
                return result
            end
        }
    end
    function Set.prototype.union(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            result:add(item)
        end
        return result
    end
    function Set.prototype.intersection(self, other)
        local result = __TS__New(Set)
        for ____, item in __TS__Iterator(self) do
            if other:has(item) then
                result:add(item)
            end
        end
        return result
    end
    function Set.prototype.difference(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            result:delete(item)
        end
        return result
    end
    function Set.prototype.symmetricDifference(self, other)
        local result = __TS__New(Set, self)
        for ____, item in __TS__Iterator(other) do
            if self:has(item) then
                result:delete(item)
            else
                result:add(item)
            end
        end
        return result
    end
    function Set.prototype.isSubsetOf(self, other)
        for ____, item in __TS__Iterator(self) do
            if not other:has(item) then
                return false
            end
        end
        return true
    end
    function Set.prototype.isSupersetOf(self, other)
        for ____, item in __TS__Iterator(other) do
            if not self:has(item) then
                return false
            end
        end
        return true
    end
    function Set.prototype.isDisjointFrom(self, other)
        for ____, item in __TS__Iterator(self) do
            if other:has(item) then
                return false
            end
        end
        return true
    end
    Set[Symbol.species] = Set
end

local function __TS__SparseArrayNew(...)
    local sparseArray = {...}
    sparseArray.sparseLength = __TS__CountVarargs(...)
    return sparseArray
end

local function __TS__SparseArrayPush(sparseArray, ...)
    local args = {...}
    local argsLen = __TS__CountVarargs(...)
    local listLen = sparseArray.sparseLength
    for i = 1, argsLen do
        sparseArray[listLen + i] = args[i]
    end
    sparseArray.sparseLength = listLen + argsLen
end

local function __TS__SparseArraySpread(sparseArray)
    local _unpack = unpack or table.unpack
    return _unpack(sparseArray, 1, sparseArray.sparseLength)
end

local WeakMap
do
    WeakMap = __TS__Class()
    WeakMap.name = "WeakMap"
    function WeakMap.prototype.____constructor(self, entries)
        self[Symbol.toStringTag] = "WeakMap"
        self.items = {}
        setmetatable(self.items, {__mode = "k"})
        if entries == nil then
            return
        end
        local iterable = entries
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                local value = result.value
                self.items[value[1]] = value[2]
            end
        else
            for ____, kvp in ipairs(entries) do
                self.items[kvp[1]] = kvp[2]
            end
        end
    end
    function WeakMap.prototype.delete(self, key)
        local contains = self:has(key)
        self.items[key] = nil
        return contains
    end
    function WeakMap.prototype.get(self, key)
        return self.items[key]
    end
    function WeakMap.prototype.has(self, key)
        return self.items[key] ~= nil
    end
    function WeakMap.prototype.set(self, key, value)
        self.items[key] = value
        return self
    end
    WeakMap[Symbol.species] = WeakMap
end

local WeakSet
do
    WeakSet = __TS__Class()
    WeakSet.name = "WeakSet"
    function WeakSet.prototype.____constructor(self, values)
        self[Symbol.toStringTag] = "WeakSet"
        self.items = {}
        setmetatable(self.items, {__mode = "k"})
        if values == nil then
            return
        end
        local iterable = values
        if iterable[Symbol.iterator] then
            local iterator = iterable[Symbol.iterator](iterable)
            while true do
                local result = iterator:next()
                if result.done then
                    break
                end
                self.items[result.value] = true
            end
        else
            for ____, value in ipairs(values) do
                self.items[value] = true
            end
        end
    end
    function WeakSet.prototype.add(self, value)
        self.items[value] = true
        return self
    end
    function WeakSet.prototype.delete(self, value)
        local contains = self:has(value)
        self.items[value] = nil
        return contains
    end
    function WeakSet.prototype.has(self, value)
        return self.items[value] == true
    end
    WeakSet[Symbol.species] = WeakSet
end

local function __TS__SourceMapTraceBack(fileName, sourceMap)
    _G.__TS__sourcemap = _G.__TS__sourcemap or ({})
    _G.__TS__sourcemap[fileName] = sourceMap
    if _G.__TS__originalTraceback == nil then
        local originalTraceback = debug.traceback
        _G.__TS__originalTraceback = originalTraceback
        debug.traceback = function(thread, message, level)
            local trace
            if thread == nil and message == nil and level == nil then
                trace = originalTraceback()
            elseif __TS__StringIncludes(_VERSION, "Lua 5.0") then
                trace = originalTraceback((("[Level " .. tostring(level)) .. "] ") .. tostring(message))
            else
                trace = originalTraceback(thread, message, level)
            end
            if type(trace) ~= "string" then
                return trace
            end
            local function replacer(____, file, srcFile, line)
                local fileSourceMap = _G.__TS__sourcemap[file]
                if fileSourceMap ~= nil and fileSourceMap[line] ~= nil then
                    local data = fileSourceMap[line]
                    if type(data) == "number" then
                        return (srcFile .. ":") .. tostring(data)
                    end
                    return (data.file .. ":") .. tostring(data.line)
                end
                return (file .. ":") .. line
            end
            local result = string.gsub(
                trace,
                "(%S+)%.lua:(%d+)",
                function(file, line) return replacer(nil, file .. ".lua", file .. ".ts", line) end
            )
            local function stringReplacer(____, file, line)
                local fileSourceMap = _G.__TS__sourcemap[file]
                if fileSourceMap ~= nil and fileSourceMap[line] ~= nil then
                    local chunkName = (__TS__Match(file, "%[string \"([^\"]+)\"%]"))
                    local sourceName = string.gsub(chunkName, ".lua$", ".ts")
                    local data = fileSourceMap[line]
                    if type(data) == "number" then
                        return (sourceName .. ":") .. tostring(data)
                    end
                    return (data.file .. ":") .. tostring(data.line)
                end
                return (file .. ":") .. line
            end
            result = string.gsub(
                result,
                "(%[string \"[^\"]+\"%]):(%d+)",
                function(file, line) return stringReplacer(nil, file, line) end
            )
            return result
        end
    end
end

local function __TS__Spread(iterable)
    local arr = {}
    if type(iterable) == "string" then
        for i = 0, #iterable - 1 do
            arr[i + 1] = __TS__StringAccess(iterable, i)
        end
    else
        local len = 0
        for ____, item in __TS__Iterator(iterable) do
            len = len + 1
            arr[len] = item
        end
    end
    return __TS__Unpack(arr)
end

local function __TS__StringCharAt(self, pos)
    if pos ~= pos then
        pos = 0
    end
    if pos < 0 then
        return ""
    end
    return string.sub(self, pos + 1, pos + 1)
end

local function __TS__StringCharCodeAt(self, index)
    if index ~= index then
        index = 0
    end
    if index < 0 then
        return 0 / 0
    end
    return string.byte(self, index + 1) or 0 / 0
end

local function __TS__StringEndsWith(self, searchString, endPosition)
    if endPosition == nil or endPosition > #self then
        endPosition = #self
    end
    return string.sub(self, endPosition - #searchString + 1, endPosition) == searchString
end

local function __TS__StringPadEnd(self, maxLength, fillString)
    if fillString == nil then
        fillString = " "
    end
    if maxLength ~= maxLength then
        maxLength = 0
    end
    if maxLength == -math.huge or maxLength == math.huge then
        error("Invalid string length", 0)
    end
    if #self >= maxLength or #fillString == 0 then
        return self
    end
    maxLength = maxLength - #self
    if maxLength > #fillString then
        fillString = fillString .. string.rep(
            fillString,
            math.floor(maxLength / #fillString)
        )
    end
    return self .. string.sub(
        fillString,
        1,
        math.floor(maxLength)
    )
end

local function __TS__StringPadStart(self, maxLength, fillString)
    if fillString == nil then
        fillString = " "
    end
    if maxLength ~= maxLength then
        maxLength = 0
    end
    if maxLength == -math.huge or maxLength == math.huge then
        error("Invalid string length", 0)
    end
    if #self >= maxLength or #fillString == 0 then
        return self
    end
    maxLength = maxLength - #self
    if maxLength > #fillString then
        fillString = fillString .. string.rep(
            fillString,
            math.floor(maxLength / #fillString)
        )
    end
    return string.sub(
        fillString,
        1,
        math.floor(maxLength)
    ) .. self
end

local __TS__StringReplace
do
    local sub = string.sub
    function __TS__StringReplace(source, searchValue, replaceValue)
        local startPos, endPos = string.find(source, searchValue, nil, true)
        if not startPos then
            return source
        end
        local before = sub(source, 1, startPos - 1)
        local replacement = type(replaceValue) == "string" and replaceValue or replaceValue(nil, searchValue, startPos - 1, source)
        local after = sub(source, endPos + 1)
        return (before .. replacement) .. after
    end
end

local __TS__StringSplit
do
    local sub = string.sub
    local find = string.find
    function __TS__StringSplit(source, separator, limit)
        if limit == nil then
            limit = 4294967295
        end
        if limit == 0 then
            return {}
        end
        local result = {}
        local resultIndex = 1
        if separator == nil or separator == "" then
            for i = 1, #source do
                result[resultIndex] = sub(source, i, i)
                resultIndex = resultIndex + 1
            end
        else
            local currentPos = 1
            while resultIndex <= limit do
                local startPos, endPos = find(source, separator, currentPos, true)
                if not startPos then
                    break
                end
                result[resultIndex] = sub(source, currentPos, startPos - 1)
                resultIndex = resultIndex + 1
                currentPos = endPos + 1
            end
            if resultIndex <= limit then
                result[resultIndex] = sub(source, currentPos)
            end
        end
        return result
    end
end

local __TS__StringReplaceAll
do
    local sub = string.sub
    local find = string.find
    function __TS__StringReplaceAll(source, searchValue, replaceValue)
        if type(replaceValue) == "string" then
            local concat = table.concat(
                __TS__StringSplit(source, searchValue),
                replaceValue
            )
            if #searchValue == 0 then
                return (replaceValue .. concat) .. replaceValue
            end
            return concat
        end
        local parts = {}
        local partsIndex = 1
        if #searchValue == 0 then
            parts[1] = replaceValue(nil, "", 0, source)
            partsIndex = 2
            for i = 1, #source do
                parts[partsIndex] = sub(source, i, i)
                parts[partsIndex + 1] = replaceValue(nil, "", i, source)
                partsIndex = partsIndex + 2
            end
        else
            local currentPos = 1
            while true do
                local startPos, endPos = find(source, searchValue, currentPos, true)
                if not startPos then
                    break
                end
                parts[partsIndex] = sub(source, currentPos, startPos - 1)
                parts[partsIndex + 1] = replaceValue(nil, searchValue, startPos - 1, source)
                partsIndex = partsIndex + 2
                currentPos = endPos + 1
            end
            parts[partsIndex] = sub(source, currentPos)
        end
        return table.concat(parts)
    end
end

local function __TS__StringSlice(self, start, ____end)
    if start == nil or start ~= start then
        start = 0
    end
    if ____end ~= ____end then
        ____end = 0
    end
    if start >= 0 then
        start = start + 1
    end
    if ____end ~= nil and ____end < 0 then
        ____end = ____end - 1
    end
    return string.sub(self, start, ____end)
end

local function __TS__StringStartsWith(self, searchString, position)
    if position == nil or position < 0 then
        position = 0
    end
    return string.sub(self, position + 1, #searchString + position) == searchString
end

local function __TS__StringSubstr(self, from, length)
    if from ~= from then
        from = 0
    end
    if length ~= nil then
        if length ~= length or length <= 0 then
            return ""
        end
        length = length + from
    end
    if from >= 0 then
        from = from + 1
    end
    return string.sub(self, from, length)
end

local function __TS__StringTrim(self)
    local result = string.gsub(self, "^[%s ﻿]*(.-)[%s ﻿]*$", "%1")
    return result
end

local function __TS__StringTrimEnd(self)
    local result = string.gsub(self, "[%s ﻿]*$", "")
    return result
end

local function __TS__StringTrimStart(self)
    local result = string.gsub(self, "^[%s ﻿]*", "")
    return result
end

local __TS__SymbolRegistryFor, __TS__SymbolRegistryKeyFor
do
    local symbolRegistry = {}
    function __TS__SymbolRegistryFor(key)
        if not symbolRegistry[key] then
            symbolRegistry[key] = __TS__Symbol(key)
        end
        return symbolRegistry[key]
    end
    function __TS__SymbolRegistryKeyFor(sym)
        for key in pairs(symbolRegistry) do
            if symbolRegistry[key] == sym then
                return key
            end
        end
        return nil
    end
end

local function __TS__TypeOf(value)
    local luaType = type(value)
    if luaType == "table" then
        return "object"
    elseif luaType == "nil" then
        return "undefined"
    else
        return luaType
    end
end

local function __TS__Using(self, cb, ...)
    local args = {...}
    local thrownError
    local ok, result = xpcall(
        function() return cb(__TS__Unpack(args)) end,
        function(err)
            thrownError = err
            return thrownError
        end
    )
    local argArray = {__TS__Unpack(args)}
    do
        local i = #argArray - 1
        while i >= 0 do
            local ____self_0 = argArray[i + 1]
            ____self_0[Symbol.dispose](____self_0)
            i = i - 1
        end
    end
    if not ok then
        error(thrownError, 0)
    end
    return result
end

local function __TS__UsingAsync(self, cb, ...)
    local args = {...}
    return __TS__AsyncAwaiter(function(____awaiter_resolve)
        local thrownError
        local ok, result = xpcall(
            function() return cb(
                nil,
                __TS__Unpack(args)
            ) end,
            function(err)
                thrownError = err
                return thrownError
            end
        )
        local argArray = {__TS__Unpack(args)}
        do
            local i = #argArray - 1
            while i >= 0 do
                if argArray[i + 1][Symbol.dispose] ~= nil then
                    local ____self_0 = argArray[i + 1]
                    ____self_0[Symbol.dispose](____self_0)
                end
                if argArray[i + 1][Symbol.asyncDispose] ~= nil then
                    local ____self_1 = argArray[i + 1]
                    __TS__Await(____self_1[Symbol.asyncDispose](____self_1))
                end
                i = i - 1
            end
        end
        if not ok then
            error(thrownError, 0)
        end
        return ____awaiter_resolve(nil, result)
    end)
end

return {
  __TS__ArrayAt = __TS__ArrayAt,
  __TS__ArrayConcat = __TS__ArrayConcat,
  __TS__ArrayEntries = __TS__ArrayEntries,
  __TS__ArrayEvery = __TS__ArrayEvery,
  __TS__ArrayFill = __TS__ArrayFill,
  __TS__ArrayFilter = __TS__ArrayFilter,
  __TS__ArrayForEach = __TS__ArrayForEach,
  __TS__ArrayFind = __TS__ArrayFind,
  __TS__ArrayFindIndex = __TS__ArrayFindIndex,
  __TS__ArrayFrom = __TS__ArrayFrom,
  __TS__ArrayIncludes = __TS__ArrayIncludes,
  __TS__ArrayIndexOf = __TS__ArrayIndexOf,
  __TS__ArrayIsArray = __TS__ArrayIsArray,
  __TS__ArrayJoin = __TS__ArrayJoin,
  __TS__ArrayMap = __TS__ArrayMap,
  __TS__ArrayPush = __TS__ArrayPush,
  __TS__ArrayPushArray = __TS__ArrayPushArray,
  __TS__ArrayReduce = __TS__ArrayReduce,
  __TS__ArrayReduceRight = __TS__ArrayReduceRight,
  __TS__ArrayReverse = __TS__ArrayReverse,
  __TS__ArrayUnshift = __TS__ArrayUnshift,
  __TS__ArraySort = __TS__ArraySort,
  __TS__ArraySlice = __TS__ArraySlice,
  __TS__ArraySome = __TS__ArraySome,
  __TS__ArraySplice = __TS__ArraySplice,
  __TS__ArrayToObject = __TS__ArrayToObject,
  __TS__ArrayFlat = __TS__ArrayFlat,
  __TS__ArrayFlatMap = __TS__ArrayFlatMap,
  __TS__ArraySetLength = __TS__ArraySetLength,
  __TS__ArrayToReversed = __TS__ArrayToReversed,
  __TS__ArrayToSorted = __TS__ArrayToSorted,
  __TS__ArrayToSpliced = __TS__ArrayToSpliced,
  __TS__ArrayWith = __TS__ArrayWith,
  __TS__AsyncAwaiter = __TS__AsyncAwaiter,
  __TS__Await = __TS__Await,
  __TS__Class = __TS__Class,
  __TS__ClassExtends = __TS__ClassExtends,
  __TS__CloneDescriptor = __TS__CloneDescriptor,
  __TS__CountVarargs = __TS__CountVarargs,
  __TS__Decorate = __TS__Decorate,
  __TS__DecorateLegacy = __TS__DecorateLegacy,
  __TS__DecorateParam = __TS__DecorateParam,
  __TS__Delete = __TS__Delete,
  __TS__DelegatedYield = __TS__DelegatedYield,
  __TS__DescriptorGet = __TS__DescriptorGet,
  __TS__DescriptorSet = __TS__DescriptorSet,
  Error = Error,
  RangeError = RangeError,
  ReferenceError = ReferenceError,
  SyntaxError = SyntaxError,
  TypeError = TypeError,
  URIError = URIError,
  __TS__FunctionBind = __TS__FunctionBind,
  __TS__Generator = __TS__Generator,
  __TS__InstanceOf = __TS__InstanceOf,
  __TS__InstanceOfObject = __TS__InstanceOfObject,
  __TS__Iterator = __TS__Iterator,
  __TS__LuaIteratorSpread = __TS__LuaIteratorSpread,
  Map = Map,
  __TS__MapGroupBy = __TS__MapGroupBy,
  __TS__Match = __TS__Match,
  __TS__MathAtan2 = __TS__MathAtan2,
  __TS__MathModf = __TS__MathModf,
  __TS__MathSign = __TS__MathSign,
  __TS__MathTrunc = __TS__MathTrunc,
  __TS__New = __TS__New,
  __TS__Number = __TS__Number,
  __TS__NumberIsFinite = __TS__NumberIsFinite,
  __TS__NumberIsInteger = __TS__NumberIsInteger,
  __TS__NumberIsNaN = __TS__NumberIsNaN,
  __TS__ParseInt = __TS__ParseInt,
  __TS__ParseFloat = __TS__ParseFloat,
  __TS__NumberToString = __TS__NumberToString,
  __TS__NumberToFixed = __TS__NumberToFixed,
  __TS__ObjectAssign = __TS__ObjectAssign,
  __TS__ObjectDefineProperty = __TS__ObjectDefineProperty,
  __TS__ObjectEntries = __TS__ObjectEntries,
  __TS__ObjectFromEntries = __TS__ObjectFromEntries,
  __TS__ObjectGetOwnPropertyDescriptor = __TS__ObjectGetOwnPropertyDescriptor,
  __TS__ObjectGetOwnPropertyDescriptors = __TS__ObjectGetOwnPropertyDescriptors,
  __TS__ObjectGroupBy = __TS__ObjectGroupBy,
  __TS__ObjectKeys = __TS__ObjectKeys,
  __TS__ObjectRest = __TS__ObjectRest,
  __TS__ObjectValues = __TS__ObjectValues,
  __TS__ParseFloat = __TS__ParseFloat,
  __TS__ParseInt = __TS__ParseInt,
  __TS__Promise = __TS__Promise,
  __TS__PromiseAll = __TS__PromiseAll,
  __TS__PromiseAllSettled = __TS__PromiseAllSettled,
  __TS__PromiseAny = __TS__PromiseAny,
  __TS__PromiseRace = __TS__PromiseRace,
  Set = Set,
  __TS__SetDescriptor = __TS__SetDescriptor,
  __TS__SparseArrayNew = __TS__SparseArrayNew,
  __TS__SparseArrayPush = __TS__SparseArrayPush,
  __TS__SparseArraySpread = __TS__SparseArraySpread,
  WeakMap = WeakMap,
  WeakSet = WeakSet,
  __TS__SourceMapTraceBack = __TS__SourceMapTraceBack,
  __TS__Spread = __TS__Spread,
  __TS__StringAccess = __TS__StringAccess,
  __TS__StringCharAt = __TS__StringCharAt,
  __TS__StringCharCodeAt = __TS__StringCharCodeAt,
  __TS__StringEndsWith = __TS__StringEndsWith,
  __TS__StringIncludes = __TS__StringIncludes,
  __TS__StringPadEnd = __TS__StringPadEnd,
  __TS__StringPadStart = __TS__StringPadStart,
  __TS__StringReplace = __TS__StringReplace,
  __TS__StringReplaceAll = __TS__StringReplaceAll,
  __TS__StringSlice = __TS__StringSlice,
  __TS__StringSplit = __TS__StringSplit,
  __TS__StringStartsWith = __TS__StringStartsWith,
  __TS__StringSubstr = __TS__StringSubstr,
  __TS__StringSubstring = __TS__StringSubstring,
  __TS__StringTrim = __TS__StringTrim,
  __TS__StringTrimEnd = __TS__StringTrimEnd,
  __TS__StringTrimStart = __TS__StringTrimStart,
  __TS__Symbol = __TS__Symbol,
  Symbol = Symbol,
  __TS__SymbolRegistryFor = __TS__SymbolRegistryFor,
  __TS__SymbolRegistryKeyFor = __TS__SymbolRegistryKeyFor,
  __TS__TypeOf = __TS__TypeOf,
  __TS__Unpack = __TS__Unpack,
  __TS__Using = __TS__Using,
  __TS__UsingAsync = __TS__UsingAsync
}
 end,
["init"] = function(...) 
local ____lualib = require("lualib_bundle")
local __TS__ArrayPush = ____lualib.__TS__ArrayPush
local __TS__Class = ____lualib.__TS__Class
local __TS__New = ____lualib.__TS__New
local __TS__SetDescriptor = ____lualib.__TS__SetDescriptor
local ____exports = {}
local intersect_cubes, Station
function intersect_cubes(self, minp1, maxp1, minp2, maxp2)
    local minp = vector.new(
        math.max(minp1.x, minp2.x),
        math.max(minp1.y, minp2.y),
        math.max(minp1.z, minp2.z)
    )
    local maxp = vector.new(
        math.min(maxp1.x, maxp2.x),
        math.min(maxp1.y, maxp2.y),
        math.min(maxp1.z, maxp2.z)
    )
    if maxp.x >= minp.x and maxp.y >= minp.y and maxp.z >= minp.z then
        return minp, maxp
    end
    return nil
end
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
if core.get_modpath("megamorph") ~= nil then
    megamorph.register_loot({name = "advtrains:engine_japan", level = 1, rarity = 7, number = {min = 1, max = 1}})
    local old_write_to_map = Geomorph.write_to_map
    Geomorph.write_to_map = function(self, ...)
        local station = Station:get(vector.multiply(
            vector.add(self.minp, self.maxp),
            0.5
        ))
        if station ~= nil and station:draws_in(self.minp, self.maxp) then
            return
        end
        return old_write_to_map(self, ...)
    end
end
advtrains.wagon_prototypes["advtrains:engine_japan"].drops = {"advtrains:engine_japan"}
core.set_mapgen_setting("chunksize", 5, true)
local CHUNK_SIZE = 80
local CHUNK_OFFSET = -32
local BIG_CHUNK_SIZE = 25 * CHUNK_SIZE
local LOW_RAIL_CHUNKS = 12
local RailLevel = RailLevel or ({})
RailLevel.Low = -992
RailLevel[RailLevel.Low] = "Low"
RailLevel.High = -192
RailLevel[RailLevel.High] = "High"
local KNOWN_RAIL_LEVELS = {RailLevel.Low, RailLevel.High}
local CENTRAL_EMPTY_ZONE = 512
local function get_rail_level(self, x, z)
    if x >= -CENTRAL_EMPTY_ZONE and x <= CENTRAL_EMPTY_ZONE and z >= -CENTRAL_EMPTY_ZONE and z <= CENTRAL_EMPTY_ZONE then
        return nil
    end
    local retval
    if false then
        if x ^ 2 + z ^ 2 <= BIG_CHUNK_SIZE * BIG_CHUNK_SIZE then
            retval = RailLevel.High
        else
            retval = RailLevel.Low
        end
    else
        local r = PcgRandom(x * 923284 + z * 263417623)
        if r:next(0, 5) <= 3 then
            local index = r:next(0, #KNOWN_RAIL_LEVELS - 1)
            retval = KNOWN_RAIL_LEVELS[index + 1]
        else
            retval = nil
        end
    end
    return retval
end
local CIRCLE_CACHE = {}
local function make_circle(self, radius)
    if not (radius > 0) then
        return {{x = 0, y = 0}}
    end
    local radius_sq = radius * radius
    local retval = {}
    local x = 0
    local y = math.floor(radius)
    while y >= x do
        __TS__ArrayPush(
            retval,
            {x = x, y = y},
            {x = y, y = -x},
            {x = -x, y = -y},
            {x = -y, y = x}
        )
        if y > x then
            __TS__ArrayPush(
                retval,
                {x = -x, y = y},
                {x = -y, y = -x},
                {x = x, y = -y},
                {x = y, y = x}
            )
        end
        x = x + 1
        if x * x + y * y > radius_sq then
            y = y - 1
        end
    end
    return retval
end
local function get_circle(self, radius)
    local retval = CIRCLE_CACHE[radius]
    if retval ~= nil then
        return retval
    end
    retval = make_circle(nil, radius)
    CIRCLE_CACHE[radius] = retval
    return retval
end
local XZRot = XZRot or ({})
XZRot.Rot0 = 0
XZRot[XZRot.Rot0] = "Rot0"
XZRot.Rot90 = 1
XZRot[XZRot.Rot90] = "Rot90"
XZRot.Rot180 = 2
XZRot[XZRot.Rot180] = "Rot180"
XZRot.Rot270 = 3
XZRot[XZRot.Rot270] = "Rot270"
local function xz_rot_reverse(self, v)
    repeat
        local ____switch21 = v
        local ____cond21 = ____switch21 == XZRot.Rot0
        if ____cond21 then
            return XZRot.Rot180
        end
        ____cond21 = ____cond21 or ____switch21 == XZRot.Rot90
        if ____cond21 then
            return XZRot.Rot270
        end
        ____cond21 = ____cond21 or ____switch21 == XZRot.Rot180
        if ____cond21 then
            return XZRot.Rot0
        end
        ____cond21 = ____cond21 or ____switch21 == XZRot.Rot270
        if ____cond21 then
            return XZRot.Rot90
        end
    until true
end
local XZ_ROT_VALUES = {XZRot.Rot0, XZRot.Rot90, XZRot.Rot180, XZRot.Rot270}
local function xz_rot(self, pos, center, angle)
    if angle == nil or center == nil then
        return pos
    end
    repeat
        local ____switch24 = angle
        local ____cond24 = ____switch24 == XZRot.Rot0
        if ____cond24 then
            return pos
        end
        ____cond24 = ____cond24 or ____switch24 == XZRot.Rot90
        if ____cond24 then
            return vector.new(center.x + (pos.z - center.z), pos.y, center.z - (pos.x - center.x))
        end
        ____cond24 = ____cond24 or ____switch24 == XZRot.Rot180
        if ____cond24 then
            return vector.new(center.x - (pos.x - center.x), pos.y, center.z - (pos.z - center.z))
        end
        ____cond24 = ____cond24 or ____switch24 == XZRot.Rot270
        if ____cond24 then
            return vector.new(center.x - (pos.z - center.z), pos.y, center.z + (pos.x - center.x))
        end
    until true
end
local function xz_rot_cube(self, minp, maxp, center, angle)
    if angle == nil or center == nil then
        return minp, maxp
    end
    repeat
        local ____switch27 = angle
        local ____cond27 = ____switch27 == XZRot.Rot0
        if ____cond27 then
            return minp, maxp
        end
        ____cond27 = ____cond27 or ____switch27 == XZRot.Rot90
        if ____cond27 then
            return vector.new(center.x + (minp.z - center.z), minp.y, center.z - (maxp.x - center.x)), vector.new(center.x + (maxp.z - center.z), maxp.y, center.z - (minp.x - center.x))
        end
        ____cond27 = ____cond27 or ____switch27 == XZRot.Rot180
        if ____cond27 then
            return vector.new(center.x - (maxp.x - center.x), minp.y, center.z - (maxp.z - center.z)), vector.new(center.x - (minp.x - center.x), maxp.y, center.z - (minp.z - center.z))
        end
        ____cond27 = ____cond27 or ____switch27 == XZRot.Rot270
        if ____cond27 then
            return vector.new(center.x - (maxp.z - center.z), minp.y, center.z + (minp.x - center.x)), vector.new(center.x - (minp.z - center.z), maxp.y, center.z + (maxp.x - center.x))
        end
    until true
end
local Drawer = __TS__Class()
Drawer.name = "Drawer"
function Drawer.prototype.____constructor(self, vm)
    self.vm = vm
    self.drew_anything = false
end
function Drawer.prototype.node(self, pos, node, rot_center, rot_angle)
    self.drew_anything = true
    local vm = self.vm
    if vm == nil then
        return
    end
    pos = xz_rot(nil, pos, rot_center, rot_angle)
    vm:set_node_at(pos, node)
end
function Drawer.prototype.cube(self, minp, maxp, node, rot_center_or_step, rot_angle, step)
    self.drew_anything = true
    local vm = self.vm
    if vm == nil then
        return
    end
    local rot_center = nil
    if rot_center_or_step == nil then
        step = 1
    elseif type(rot_center_or_step) == "number" then
        step = rot_center_or_step
    else
        rot_center = rot_center_or_step
        if step == nil then
            step = 1
        end
    end
    minp, maxp = xz_rot_cube(
        nil,
        minp,
        maxp,
        rot_center,
        rot_angle
    )
    local pos = vector.zero()
    for z = minp.z, maxp.z, step do
        pos.z = z
        for y = minp.y, maxp.y, step do
            pos.y = y
            for x = minp.x, maxp.x, step do
                pos.x = x
                vm:set_node_at(pos, node)
            end
        end
    end
end
function Drawer.prototype.circle(self, center, radius, plane, node)
    self.drew_anything = true
    local vm = self.vm
    if vm == nil then
        return
    end
    center = vector.floor(vector.add(center, 0.5))
    local pos = vector.copy(center)
    local circle = get_circle(nil, radius)
    for ____, ____value in ipairs(circle) do
        local x = ____value.x
        local y = ____value.y
        pos[plane[1]] = center[plane[1]] + x
        pos[plane[2]] = center[plane[2]] + y
        vm:set_node_at(pos, node)
    end
end
function Drawer.prototype.line(self, start, inc, count, node, rot_center, rot_angle)
    self.drew_anything = true
    local vm = self.vm
    if vm == nil then
        return
    end
    local pos = vector.copy(xz_rot(nil, start, rot_center, rot_angle))
    local inc2 = xz_rot(nil, {x = inc.x ~= nil and inc.x or 0, y = inc.y ~= nil and inc.y or 0, z = inc.z ~= nil and inc.z or 0}, {x = 0, y = 0, z = 0}, rot_angle)
    for _ = 1, count do
        vm:set_node_at(pos, node)
        pos.x = pos.x + inc2.x
        pos.y = pos.y + inc2.y
        pos.z = pos.z + inc2.z
    end
end
local function minp_size_to_minp_maxp(self, minp, size)
    return {
        vector.copy(minp),
        vector.add(
            vector.add(minp, size),
            -1
        )
    }
end
local TRACK_STEP_SIZE = 2
local TrackYStep = TrackYStep or ({})
TrackYStep.Down = -1
TrackYStep[TrackYStep.Down] = "Down"
TrackYStep.Same = 0
TrackYStep[TrackYStep.Same] = "Same"
TrackYStep.Up = 1
TrackYStep[TrackYStep.Up] = "Up"
local TRACK_Y_STEPS = {TrackYStep.Down, TrackYStep.Same, TrackYStep.Up}
local function make_track_nodes(self)
    local retval = {[TrackYStep.Down] = {}, [TrackYStep.Same] = {}, [TrackYStep.Up] = {}}
    for ____, xz_rot in ipairs(XZ_ROT_VALUES) do
        local up_param2
        local same_param2
        local down_param2
        repeat
            local ____switch50 = xz_rot
            local ____cond50 = ____switch50 == XZRot.Rot0
            if ____cond50 then
                up_param2 = 1
                same_param2 = 3
                down_param2 = 3
                break
            end
            ____cond50 = ____cond50 or ____switch50 == XZRot.Rot90
            if ____cond50 then
                up_param2 = 2
                same_param2 = 2
                down_param2 = 0
                break
            end
            ____cond50 = ____cond50 or ____switch50 == XZRot.Rot180
            if ____cond50 then
                up_param2 = 3
                same_param2 = 3
                down_param2 = 1
                break
            end
            ____cond50 = ____cond50 or ____switch50 == XZRot.Rot270
            if ____cond50 then
                up_param2 = 0
                same_param2 = 2
                down_param2 = 2
                break
            end
        until true
        retval[TrackYStep.Down][xz_rot] = {{name = "advtrains:dtrack_vst2", param1 = 0, param2 = down_param2}, {name = "advtrains:dtrack_vst1", param1 = 0, param2 = down_param2}}
        local same_node = {name = "advtrains:dtrack_st", param1 = 0, param2 = same_param2}
        retval[TrackYStep.Same][xz_rot] = {same_node, same_node}
        retval[TrackYStep.Up][xz_rot] = {{name = "advtrains:dtrack_vst1", param1 = 0, param2 = up_param2}, {name = "advtrains:dtrack_vst2", param1 = 0, param2 = up_param2}}
        for ____, track_y_step in ipairs(TRACK_Y_STEPS) do
            assert(#retval[track_y_step][xz_rot] == TRACK_STEP_SIZE)
        end
    end
    return retval
end
local TRACK_NODES = make_track_nodes(nil)
local TRACK_CEILING_Y = 9
local TRACK_FLOOR_Y = -1
local TRACK_WALL_MIN_Z = -3
local TRACK_WALL_MAX_Z = 3
local TRACK_WALL_LEN = BIG_CHUNK_SIZE - CHUNK_SIZE + 1
local TRACK_EXTRA_LEN = 10
--- inserts `key` into `set`, returns `true` if `key` was successfully inserted (was not present beforehand).
local function try_insert_in_mt_vec3_set(self, set, key)
    local yz = set[key.x]
    if yz == nil then
        local ____set_0 = set
        local ____key_x_1 = key.x
        yz = {}
        ____set_0[____key_x_1] = yz
    end
    local z = yz[key.y]
    if z == nil then
        local ____yz_2 = yz
        local ____key_y_3 = key.y
        z = {}
        ____yz_2[____key_y_3] = z
    end
    local retval = not (z[key.z] ~= nil)
    z[key.z] = true
    return retval
end
Station = __TS__Class()
Station.name = "Station"
function Station.prototype.____constructor(self, pos, rail_level)
    self.pos = pos
    pos.y = rail_level
    self.rail_level = rail_level
    self.minp = vector.offset(pos, 0, 0, 0)
    self.maxp = vector.offset(pos, CHUNK_SIZE - 1, CHUNK_SIZE - 1, CHUNK_SIZE - 1)
end
function Station.get(self, input_pos)
    local pos = vector.multiply(
        vector.subtract(input_pos, CHUNK_OFFSET),
        1 / BIG_CHUNK_SIZE
    )
    pos.y = 0
    pos = vector.add(
        vector.multiply(
            vector.floor(vector.add(pos, 0.5)),
            BIG_CHUNK_SIZE
        ),
        CHUNK_OFFSET
    )
    local rail_level = get_rail_level(nil, pos.x, pos.z)
    if rail_level ~= nil then
        return __TS__New(Station, pos, rail_level)
    else
        return nil
    end
end
function Station.prototype.draw_track_step(self, neighbor, drawer, minp, maxp, pos, rot_center, rot_angle, track_y_step)
    local step_minp, step_maxp = xz_rot_cube(
        nil,
        vector.offset(pos, 0, TRACK_FLOOR_Y, TRACK_WALL_MIN_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y, TRACK_WALL_MAX_Z),
        rot_center,
        rot_angle
    )
    local iminp, imaxp = intersect_cubes(
        nil,
        minp,
        maxp,
        step_minp,
        step_maxp
    )
    if iminp == nil then
        return
    end
    local track_nodes = TRACK_NODES[track_y_step][rot_angle]
    for i = 0, TRACK_STEP_SIZE - 1 do
        drawer:node(
            vector.offset(pos, i, 0, 0),
            track_nodes[i + 1],
            rot_center,
            rot_angle
        )
    end
end
function Station.prototype.draw_track_walls_step(self, neighbor, drawer, minp, maxp, pos, rot_center, rot_angle)
    local step_minp, step_maxp = xz_rot_cube(
        nil,
        vector.offset(pos, 0, TRACK_FLOOR_Y, TRACK_WALL_MIN_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y, TRACK_WALL_MAX_Z),
        rot_center,
        rot_angle
    )
    local iminp, imaxp = intersect_cubes(
        nil,
        minp,
        maxp,
        step_minp,
        step_maxp
    )
    if iminp == nil then
        return
    end
    drawer:cube(
        vector.offset(pos, 0, TRACK_FLOOR_Y, TRACK_WALL_MIN_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y, TRACK_WALL_MIN_Z),
        {name = "artifacts:moon_glass", param1 = 0, param2 = 0},
        rot_center,
        rot_angle
    )
    drawer:cube(
        vector.offset(pos, 0, TRACK_FLOOR_Y, TRACK_WALL_MAX_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y, TRACK_WALL_MAX_Z),
        {name = "artifacts:moon_glass", param1 = 0, param2 = 0},
        rot_center,
        rot_angle
    )
    drawer:cube(
        vector.offset(pos, 0, TRACK_FLOOR_Y, TRACK_WALL_MIN_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_FLOOR_Y, TRACK_WALL_MAX_Z),
        {name = "artifacts:moon_glass", param1 = 0, param2 = 0},
        rot_center,
        rot_angle
    )
    drawer:cube(
        vector.offset(pos, 0, TRACK_CEILING_Y, TRACK_WALL_MIN_Z),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y, TRACK_WALL_MAX_Z),
        {name = "artifacts:moon_glass", param1 = 0, param2 = 0},
        rot_center,
        rot_angle
    )
    drawer:cube(
        vector.offset(pos, 0, TRACK_FLOOR_Y + 1, TRACK_WALL_MIN_Z + 1),
        vector.offset(pos, TRACK_STEP_SIZE - 1, TRACK_CEILING_Y - 1, TRACK_WALL_MAX_Z - 1),
        {name = "air", param1 = 0, param2 = 0},
        rot_center,
        rot_angle
    )
end
function Station.prototype.draw_track(self, neighbor, drawer, minp, maxp, exit_tunnels_not_needed)
    local rot_angle
    if neighbor.pos.x > self.pos.x then
        rot_angle = XZRot.Rot0
    elseif neighbor.pos.x < self.pos.x then
        rot_angle = XZRot.Rot180
        assert(
            false,
            (("this = " .. tostring(self.pos)) .. ", neighbor = ") .. tostring(neighbor.pos)
        )
    elseif neighbor.pos.z < self.pos.z then
        rot_angle = XZRot.Rot90
        assert(
            false,
            (("this = " .. tostring(self.pos)) .. ", neighbor = ") .. tostring(neighbor.pos)
        )
    else
        rot_angle = XZRot.Rot270
    end
    local rot_center = self.inner_floor_midp
    for track_index = 0, 1 do
        local track_y_step = TrackYStep.Same
        if self.pos.y > neighbor.pos.y then
            track_y_step = TrackYStep.Down
        elseif self.pos.y < neighbor.pos.y then
            track_y_step = TrackYStep.Up
        end
        local wall_track_y_step = track_y_step
        local target_y = neighbor.track_starts[track_index + 1].y
        local pos = vector.copy(self.track_starts[track_index + 1])
        for i = 1, TRACK_WALL_LEN, TRACK_STEP_SIZE do
            if pos.y == target_y then
                wall_track_y_step = TrackYStep.Same
            end
            self:draw_track_walls_step(
                neighbor,
                drawer,
                minp,
                maxp,
                pos,
                rot_center,
                rot_angle
            )
            pos.x = pos.x + TRACK_STEP_SIZE
            pos.y = pos.y + wall_track_y_step
            if track_index == 0 then
                local final_pos = xz_rot(nil, pos, rot_center, rot_angle)
                local chunk_index = vector.floor(vector.multiply(
                    vector.subtract(final_pos, CHUNK_OFFSET - 0.001),
                    1 / CHUNK_SIZE
                ))
                local chunk_minp = vector.add(
                    vector.multiply(chunk_index, CHUNK_SIZE),
                    CHUNK_OFFSET
                )
                self:draw_exit_tunnels(
                    drawer,
                    minp,
                    maxp,
                    chunk_minp,
                    exit_tunnels_not_needed
                )
            end
        end
        pos = vector.copy(self.track_starts[track_index + 1])
        for i = 1, TRACK_WALL_LEN + TRACK_EXTRA_LEN, TRACK_STEP_SIZE do
            local draw_track_y_step = track_y_step
            if pos.y == target_y then
                track_y_step = TrackYStep.Same
            end
            if draw_track_y_step == TrackYStep.Down then
                if i == 1 then
                    draw_track_y_step = TrackYStep.Same
                end
            else
                draw_track_y_step = track_y_step
            end
            self:draw_track_step(
                neighbor,
                drawer,
                minp,
                maxp,
                pos,
                rot_center,
                rot_angle,
                draw_track_y_step
            )
            pos.x = pos.x + TRACK_STEP_SIZE
            pos.y = pos.y + track_y_step
        end
        pos = vector.copy(self.track_starts[track_index + 1])
        for i = 1, TRACK_EXTRA_LEN, TRACK_STEP_SIZE do
            pos.x = pos.x - TRACK_STEP_SIZE
            self:draw_track_step(
                neighbor,
                drawer,
                minp,
                maxp,
                pos,
                rot_center,
                rot_angle,
                TrackYStep.Same
            )
        end
    end
end
function Station.prototype.draw_exit_tunnels(self, drawer, minp, maxp, chunk_minp, exit_tunnels_not_needed)
    if not try_insert_in_mt_vec3_set(nil, exit_tunnels_not_needed, chunk_minp) then
        return
    end
    local iminp, imaxp = intersect_cubes(
        nil,
        minp,
        maxp,
        chunk_minp,
        vector.add(chunk_minp, CHUNK_SIZE - 1)
    )
    if iminp == nil then
        return
    end
    for ____, ____value in ipairs(Station.EXIT_TUNNELS) do
        local cube_minp = ____value[1]
        local cube_maxp = ____value[2]
        drawer:cube(
            vector.add(chunk_minp, cube_minp),
            vector.add(chunk_minp, cube_maxp),
            {name = "air", param1 = 0, param2 = 0}
        )
    end
end
function Station.prototype.draw_station(self, drawer, minp, maxp, exit_tunnels_not_needed)
    try_insert_in_mt_vec3_set(nil, exit_tunnels_not_needed, self.pos)
    local iminp, imaxp = intersect_cubes(
        nil,
        minp,
        maxp,
        self.minp,
        self.maxp
    )
    if iminp == nil then
        return
    end
    for ____, ____value in ipairs(Station.WALLS) do
        local exit_minp = ____value[1]
        local exit_maxp = ____value[2]
        drawer:cube(
            vector.add(self.pos, exit_minp),
            vector.add(self.pos, exit_maxp),
            {name = "artifacts:antiquorium", param1 = 0, param2 = 0}
        )
    end
    for ____, ____value in ipairs(Station.EXITS) do
        local exit_minp = ____value[1]
        local exit_maxp = ____value[2]
        drawer:cube(
            vector.add(self.pos, exit_minp),
            vector.add(self.pos, exit_maxp),
            {name = "air", param1 = 0, param2 = 0}
        )
    end
    drawer:cube(self.ceiling_minp, self.ceiling_maxp, {name = "artifacts:moon_glass", param1 = 0, param2 = 0})
    drawer:cube(self.floor_minp, self.floor_maxp, {name = "artifacts:antiquorium", param1 = 0, param2 = 0})
    drawer:cube(self.inner_minp, self.inner_maxp, {name = "air", param1 = 0, param2 = 0})
    for radius = 5, 30, 4 do
        drawer:circle(
            vector.offset(self.inner_floor_midp, 0, -1, 0),
            radius - 0.000001,
            {"x", "z"},
            {name = "artifacts:moon_glass", param1 = 0, param2 = 1}
        )
    end
    local rot_center = self.inner_floor_midp
    for ____, rot_angle in ipairs(XZ_ROT_VALUES) do
        drawer:line(
            vector.offset(self.pos, 10, 21, 30),
            {x = 1},
            61,
            {name = "advtrains:dtrack_st", param1 = 0, param2 = (rot_angle == XZRot.Rot0 or rot_angle == XZRot.Rot180) and 3 or 2},
            rot_center,
            rot_angle
        )
    end
    for ____, rot_angle in ipairs(XZ_ROT_VALUES) do
        drawer:node(
            vector.offset(self.pos, 30, 21, 30),
            {name = "advtrains:dtrack_xing_st", param1 = 0, param2 = 0},
            rot_center,
            rot_angle
        )
    end
end
function Station.prototype.draw_all(self, drawer, minp, maxp)
    local exit_tunnels_not_needed = {}
    self:draw_station(drawer, minp, maxp, exit_tunnels_not_needed)
    for ____, neighbor in ipairs(self.neighbors) do
        neighbor:draw_station(drawer, minp, maxp, exit_tunnels_not_needed)
    end
    for ____, neighbor in ipairs(self.neighbors) do
        if self.pos.x < neighbor.pos.x or self.pos.x == neighbor.pos.x and self.pos.z < neighbor.pos.z then
            self:draw_track(
                neighbor,
                drawer,
                minp,
                maxp,
                exit_tunnels_not_needed
            )
        else
            neighbor:draw_track(
                self,
                drawer,
                minp,
                maxp,
                exit_tunnels_not_needed
            )
        end
    end
end
function Station.prototype.draws_in(self, minp, maxp)
    local drawer = __TS__New(Drawer, nil)
    self:draw_all(drawer, minp, maxp)
    return drawer.drew_anything
end
__TS__SetDescriptor(
    Station.prototype,
    "floor_minp",
    {get = function(self)
        return vector.add(self.inner_minp, -1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "floor_maxp",
    {get = function(self)
        local inner_minp = self.inner_minp
        local inner_maxp = self.inner_maxp
        return vector.new(inner_maxp.x + 1, inner_minp.y - 1, inner_maxp.z + 1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "ceiling_minp",
    {get = function(self)
        local inner_minp = self.inner_minp
        local inner_maxp = self.inner_maxp
        return vector.new(inner_minp.x - 1, inner_maxp.y + 1, inner_minp.z - 1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "ceiling_maxp",
    {get = function(self)
        return vector.add(self.inner_maxp, 1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "inner_minp",
    {get = function(self)
        return vector.offset(self.pos, 1, 21, 1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "inner_floor_midp",
    {get = function(self)
        return vector.offset(self.pos, 40, 21, 40)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "inner_maxp",
    {get = function(self)
        return vector.offset(self.pos, 78, 53, 78)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "outer_minp",
    {get = function(self)
        return vector.add(self.inner_minp, -1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "outer_maxp",
    {get = function(self)
        return vector.add(self.inner_maxp, 1)
    end},
    true
)
__TS__SetDescriptor(
    Station.prototype,
    "track_starts",
    {get = function(self)
        return {
            vector.offset(self.pos, 79, 21, 30),
            vector.offset(self.pos, 79, 21, 50)
        }
    end},
    true
)
Station.EXITS = {
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 19),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 39),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 59),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(79, 21, 19),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(79, 21, 39),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(79, 21, 59),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(19, 21, 0),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 21, 0),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(59, 21, 0),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(19, 21, 79),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 21, 79),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(59, 21, 79),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 51, 39),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(79, 51, 39),
        vector.new(1, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 51, 0),
        vector.new(2, 3, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 51, 79),
        vector.new(2, 3, 1)
    )
}
Station.EXIT_TUNNELS = {
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 19),
        vector.new(80, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 39),
        vector.new(80, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 59),
        vector.new(80, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(19, 21, 0),
        vector.new(2, 3, 80)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 21, 0),
        vector.new(2, 3, 80)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(59, 21, 0),
        vector.new(2, 3, 80)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 51, 39),
        vector.new(80, 3, 2)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(39, 51, 0),
        vector.new(2, 3, 80)
    )
}
Station.WALLS = {
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 0),
        vector.new(1, 34, 80)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 0),
        vector.new(80, 34, 1)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(79, 21, 0),
        vector.new(1, 34, 80)
    ),
    minp_size_to_minp_maxp(
        nil,
        vector.new(0, 21, 79),
        vector.new(80, 34, 1)
    )
}
__TS__SetDescriptor(
    Station.prototype,
    "neighbors",
    {get = function(self)
        if self._neighbors == nil then
            self._neighbors = {}
            for ____, pos in ipairs({
                vector.offset(self.pos, -BIG_CHUNK_SIZE, 0, 0),
                vector.offset(self.pos, BIG_CHUNK_SIZE, 0, 0),
                vector.offset(self.pos, 0, 0, -BIG_CHUNK_SIZE),
                vector.offset(self.pos, 0, 0, BIG_CHUNK_SIZE)
            }) do
                local rail_level = get_rail_level(nil, pos.x, pos.z)
                if rail_level ~= nil then
                    local ____self__neighbors_4 = self._neighbors
                    ____self__neighbors_4[#____self__neighbors_4 + 1] = __TS__New(Station, pos, rail_level)
                end
            end
        end
        return self._neighbors
    end},
    true
)
local function lexicographically_less(self, lhs, rhs)
    if lhs.x < rhs.x then
        return true
    end
    if lhs.x ~= rhs.x then
        return false
    end
    if lhs.y < rhs.y then
        return true
    end
    if lhs.y ~= rhs.y then
        return false
    end
    return lhs.z < rhs.z
end
local function generate(minp, maxp, blockseed)
    if not (minp and maxp) then
        return
    end
    local avg = vector.multiply(
        vector.add(minp, maxp),
        0.5
    )
    local station = Station:get(avg)
    if station == nil then
        return
    end
    local vm, emin, emax = core.get_mapgen_object("voxelmanip")
    station:draw_all(
        __TS__New(Drawer, vm),
        emin,
        emax
    )
    vm:set_lighting({day = 0, night = 0})
    vm:calc_lighting()
    vm:update_liquids()
    vm:write_to_map()
end
core.register_on_generated(generate)
return ____exports
 end,
}
return require("init", ...)
