import type { MtVec3 } from "@repcomm/mt-api";

interface Vector extends MtVec3 {
    ["new"](this: void, x: number, y: number, z: number): Vector
    copy(this: void, v: MtVec3): Vector;
    zero(this: void): Vector
    abs(this: void, v: MtVec3): Vector
    floor(this: void, v: MtVec3): Vector;
    ceil(this: void, v: MtVec3): Vector;
    add(this: void, l: MtVec3, r: MtVec3 | number): Vector;
    subtract(this: void, l: MtVec3, r: MtVec3 | number): Vector;
    multiply(this: void, l: MtVec3, r: number): Vector;
    distance(this: void, l: MtVec3, r: MtVec3): number;
    direction(this: void, l: MtVec3, r: MtVec3): Vector;
    normalize(this: void, v: MtVec3): Vector;
    dot(this: void, l: MtVec3, r: MtVec3): number;
    offset(this: void, v: MtVec3, x: number, y: number, z: number): Vector;
}

declare global {
    const vector: Vector;
}