
core.register_node("gear_up:crate_type1", {
	description = ("Crate - Wood \n"..
		core.colorize("#aaaaaa","Break it to get 1 random item \n")..
		""..
		core.colorize("#aaaaaa","can sometimes be found in the sand")..
		""),
	tiles = {
		"gear_up_crate_type1_top.png",
		"gear_up_crate_type1_top.png",
		"gear_up_crate_type1_side.png",
		"gear_up_crate_type1_side.png",
		"gear_up_crate_type1_side.png",
		"gear_up_crate_type1_front.png"
	},
	is_ground_content = true,
	groups = {oddly_breakable_by_hand = 3},
	drop = "",
	on_dig = function(pos, node, digger)
		local item_stack = {
			"dye:green",
			"default:mese_post_light",
			"default:mese_post_light",
			"default:wood",
			"default:wood",
			"default:stick",
			"default:stick",
			"default:torch",
			"default:torch",
			"farming:cotton",
			"farming:cotton",
			"default:coal_lump",
			"default:copper_lump",
			"default:tin_lump",
			"gear_up:amethyst",
			"gear_up:aquamarine",
			"gear_up:carnelian",
			"gear_up:emerald",
			"gear_up:ruby",
			"gear_up:sapphire",
			"gear_up:topaz",
		}
		local gotten_acc = ItemStack({name = item_stack[math.random(#item_stack)]})

		if core.get_modpath("tool_modifiers") then
			if math.random(1,2) == 2 then
				ApplyAccessoryMod(gotten_acc,accessory_modifiers,math.random(#accessory_modifiers),nil)
			end
		end

		core.add_item(pos,gotten_acc)
		core.node_dig(pos,node,digger)
	end,
})

-- appears underwater and underground in sand but not too deep
core.register_ore({
	ore_type       = "scatter",
	ore            = "gear_up:crate_type1",
	wherein        = "group:sand",
	clust_scarcity = 7 * 7 * 7,
	clust_num_ores = 1,
	clust_size     = 1,
	y_max          = 1,
	y_min          = -10,
})

core.register_ore({
	ore_type       = "scatter",
	ore            = "gear_up:crate_type1",
	wherein        = "group:water",
	clust_scarcity = 16 * 16 * 16,
	clust_num_ores = 1,
	clust_size     = 1,
	y_max          = 1,
	y_min          = -1,
})
