
core.register_node("gear_up:crate_type2", {
	description = ("Crate - Wood with Metal Joints \n"..
		core.colorize("#aaaaaa","Break it to get 1 random item \n")..
		""..
		core.colorize("#aaaaaa","can sometimes be found just beneath the surface")..
		""),
	tiles = {
		"gear_up_crate_type2_top.png",
		"gear_up_crate_type2_top.png",
		"gear_up_crate_type2_side.png",
		"gear_up_crate_type2_side.png",
		"gear_up_crate_type2_side.png",
		"gear_up_crate_type2_front.png"
	},
	is_ground_content = false,
	groups = {oddly_breakable_by_hand = 3},
	drop = "",
	on_dig = function(pos, node, digger)
		local item_stack = {
			"default:wood",
			"default:wood",
			"default:stick",
			"default:stick",
			"default:torch",
			"default:torch",
			"wool:white",
			"default:coal_lump",
			"default:copper_lump",
			"default:tin_lump",
			"gear_up:amethyst",
			"gear_up:aquamarine",
			"gear_up:carnelian",
			"gear_up:emerald",
			"gear_up:ruby",
			"gear_up:sapphire",
			"gear_up:topaz",
		}
		local gotten_acc = ItemStack({name = item_stack[math.random(#item_stack)]})

		if core.get_modpath("tool_modifiers") then
			if math.random(1,2) == 2 then
				ApplyAccessoryMod(gotten_acc,accessory_modifiers,math.random(#accessory_modifiers),nil)
			end
		end

		core.add_item(pos,gotten_acc)
		core.node_dig(pos,node,digger)
	end,
})

-- crate buried in the dirt
core.register_ore({
	ore_type       = "scatter",
	ore            = "gear_up:crate_type2",
	wherein        = "default:dirt",
	clust_scarcity = 4 * 4 * 4,
	clust_num_ores = 1,
	clust_size     = 1,
	y_max          = 60,
	y_min          = -10,
})
