sfinv.register_page("sfinv:gear_up_gear", {
	title = "Gear",
	get = function(self, player, context)
		local player_name = player:get_player_name()
		local inv_gear = core.get_inventory({type="detached",name="accs_gear_"..player_name..""})
		inv_gear:set_size("gear_ss",CountOfAccInvSlots)
		inv_gear:set_width("gear_ss",8)
		local player_meta = player:get_meta()
		local gear_up_gear_formspec =(
			"size[8,11]"..
			"image[0.0,0.0;4.78,5.66;gear_up_gear_inv_bg.png]"..
			"image[4.2,0.2;1.0,1.0;gear_up_gear_defense_icon.png^[multiply:#565656]"..
			"label[4.4,0.4;"..player_meta:get_int("gear_up_gear_defense").."]"..
			"image[5.2,0.2;1.0,1.0;gear_up_gear_offense_icon.png^[multiply:#565656]"..
			"label[5.4,0.4;"..player_meta:get_int("gear_up_gear_offense").."%".."]"..
			"image[6.2,0.2;1.0,1.0;gear_up_gear_hp_regen_icon.png^[multiply:#565656]"..
			"label[6.4,0.4;"..(math.ceil(player_meta:get_float("gear_up_gear_hp_regen")*100)/100).."]"..
			"image[4.2,1.2;1.0,1.0;gear_up_gear_hp_bonus_icon.png^[multiply:#565656]"..
			"label[4.4,1.4;"..player_meta:get_int("gear_up_gear_hp_bonus").."]"..
			"image[5.2,1.2;1.0,1.0;gear_up_gear_walk_speed_icon.png^[multiply:#565656]"..
			"label[5.4,1.4;"..(math.ceil(player_meta:get_float("gear_up_gear_walk_speed")*100)/100).."]"..
			"image[6.2,1.2;1.0,1.0;gear_up_gear_dig_speed_icon.png^[multiply:#565656]"..
			"label[6.4,1.4;"..player_meta:get_int("gear_up_gear_dig_speed").."%".."]"..
			"label[4.2,2.2;"..player_meta:get_string("accessory_SetBonus").."]"..
			"list[detached:accs_gear_"..player_name..";gear_ss;0,0.0;4,5;]")
		return sfinv.make_formspec(player, context, gear_up_gear_formspec, true)
	end,
})

sfinv.register_page("sfinv:gear_up_color", {
	title = "Color",
	get = function(self, player, context)
		local player_name = player:get_player_name()
		local gear_up_color_formspec =(
			"size[8,11]"..
			"image[0,0.0;4.78,5.66;gear_up_color_inv_bg.png]"..
			"label[4.2,2.2;".."Equip Magic Dye Jars\nto change color of equipped Gear".."]"..
			"list[detached:accs_color_"..player_name..";color_ss;0,0.0;4,5;]")
		return sfinv.make_formspec(player, context, gear_up_color_formspec, true)
	end,
})
