local function fix_spawn(player)
     local name = player:get_player_name()
     local pos = player:get_pos()
     core.chat_send_player(name, tostring(pos.y))
     pos.y = pos.y + 0.5
     local node = core.get_node_or_nil(pos)
     
     if node then
         core.chat_send_player(name, "Node at your position: " .. core.serialize(node))
     else
         core.chat_send_player(name, "No node found at your position.")
         return
     end
     if node == "air" then core.chat_send_player(name, "air found at your position! ending!") return end

     local air
     core.chat_send_player(name, "looking for air in radius of 100") air = core.find_node_near(pos, 100, "air")
     core.chat_send_player(name, "air found at: "..core.serialize(air))


     if air == nil then core.chat_send_player(name, "failed to find air. stopping.") return end

     core.chat_send_player(name, "teleporting...") player:set_pos(air)

 end


 core.register_chatcommand("fix_spawn", {
     privs = {
         interact = true,
     },
     func = function(name, param)
         player = core.get_player_by_name(name)
         if not player then return false, "failed to get player" end
         fix_spawn(player)
     end,
 })