--[[
    Convenience tools for Areas protection mod
    Copyright (C) 2025 rangeTonic
	Original code copyright (C) 2013-2017 ShadowNinja
	Original code copyright (C) 2015-2020 various contributors

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, see <https://www.gnu.org/licenses/>.
--]]

local AS = core.get_translator("areas")

---@param pname string
---@param id integer
---@return nil
function Areas_protect_tool.select_area(pname, id)
	areas:setPos1(pname, areas.areas[id].pos1)
	areas:setPos2(pname, areas.areas[id].pos2)
	core.chat_send_player(pname, AS("Area @1 selected.", id))
end

---@param pname string
---@param arname string
---@return nil
function Areas_protect_tool.protect(pname, arname)
	local pos1, pos2 = areas:getPos(pname)
	if not (pos1 and pos2) then return end

	core.log("action",
			"Attempt to protect an area using areas_helper_tools:selector. Owner=" .. pname ..
			" AreaName=" .. arname ..
			" StartPos=" .. core.pos_to_string(pos1) ..
			" EndPos=" .. core.pos_to_string(pos2))

	local canAdd, errMsg = areas:canPlayerAddArea(pos1, pos2, pname)
	if not canAdd then
		core.chat_send_player(pname, AS("You can't protect that area: @1",
				errMsg))
		return
	end

	local id = areas:add(pname, arname, pos1, pos2, nil)
	areas:save()

	core.chat_send_player(pname, AS("Area protected. ID: @1", id))
end

---@param pname string
---@param pid integer
---@param owner string
---@param arname string
---@return nil
function Areas_protect_tool.add_owner(pname, pid, owner, arname)
	local pos1, pos2 = areas:getPos(pname)
	if not (pos1 and pos2) then return end

	if not areas:player_exists(owner) then
		core.chat_send_player(pname,
				AS("The player \"@1\" does not exist.", owner))
		return
	end

	core.log("action", pname .. " tries to create sub-area using areas_helper_tools:selector. Owner = " .. owner ..
			" AreaName = " .. arname .. " ParentID = " .. pid ..
			" StartPos = " .. core.pos_to_string(pos1) ..
			" EndPos = " .. core.pos_to_string(pos2))

	if not (areas:isAreaOwner(pid, pname) and
			areas:isSubarea(pos1, pos2, pid)) then
		core.chat_send_player(pname, AS("You can't protect that area."))
		return
	end

	local id = areas:add(owner, arname, pos1, pos2, pid)
	areas:save()

	core.chat_send_player(owner,
			AS("You have been granted control over area #@1. Type /list_areas to show your areas.", id))
	core.chat_send_player(pname, AS("Area protected. ID: @1", id))
end

---@param pname string
---@param id integer
---@param recursive boolean
---@return nil
function Areas_protect_tool.remove(pname, id, recursive)
	if not areas:isAreaOwner(id, pname) then
		core.chat_send_player(pname, AS("Area @1 does not exist or is not owned by you.", id))
		return
	end

	areas:remove(id, recursive)
	areas:save()
	if recursive then
		core.chat_send_player(pname, AS("Removed area @1 and its sub areas.", id))
	else
		core.chat_send_player(pname, AS("Removed area @1", id))
	end
end
