--[[
    Convenient tools for Areas protection mod
    Copyright (C) 2025-2026 rangeTonic

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, see <https://www.gnu.org/licenses/>.
--]]

local mcl = Areas_helper_tools.mcl_available
if not (mcl or Areas_helper_tools.mtg_available) then
	core.log("error", core.get_current_modname() ..
			" provides crafting recipes only for Minetest Game, VoxeLibre and Mineclonia.")
	return
end

local coal = mcl and "mcl_core:coal_lump" or "default:coal_lump"
local dye_orange = mcl and "mcl_dye:orange" or "dye:orange"
local steel = mcl and "mcl_core:iron_ingot" or "default:steel_ingot"

-- TODO: consider making the recipe more expensive
core.register_craft({
	output = "areas_helper_tools:selector",
	recipe = {
		{coal, "",           ""},
		{"",   "group:wood", dye_orange},
		{"",   "",           steel}
	}
})
