local cm = moreblocks.resources.craft_materials

-- More Blocks aliases:
minetest.register_alias("sweeper", "moreblocks:sweeper")

if cm.stick then
	minetest.register_alias("jungle_stick", cm.stick)
	minetest.register_alias("moreblocks:jungle_stick", cm.stick)
end

-- Old block/item replacement:
if cm.mossycobble then
	minetest.register_alias("moreblocks:oerkkiblock", cm.mossycobble)
end

if cm.screwdriver then
	minetest.register_alias("moreblocks:screwdriver", cm.screwdriver)
end

-- Node and item renaming:
if cm.stone_brick then
	minetest.register_alias("moreblocks:stone_bricks", cm.stone_brick)
	minetest.register_alias("moreblocks:stonebrick", cm.stone_brick)
end

if cm.jungle_wood then
	minetest.register_alias("moreblocks:junglewood", cm.jungle_wood)
	minetest.register_alias("moreblocks:jungle_wood", cm.jungle_wood)
end

if cm.fence_jungle_wood then
	minetest.register_alias("moreblocks:fence_junglewood", cm.fence_jungle_wood)
	minetest.register_alias("moreblocks:fence_jungle_wood", cm.fence_jungle_wood)
end

minetest.register_alias("moreblocks:horizontaltree", "moreblocks:horizontal_tree")
minetest.register_alias("moreblocks:horizontaljungletree", "moreblocks:horizontal_jungle_tree")
minetest.register_alias("moreblocks:stonesquare", "moreblocks:stone_tile")
minetest.register_alias("moreblocks:circlestonebrick", "moreblocks:circle_stone_bricks")
minetest.register_alias("moreblocks:ironstonebrick", "moreblocks:iron_stone_bricks")
minetest.register_alias("moreblocks:coalstone", "moreblocks:coal_stone")
minetest.register_alias("moreblocks:ironstone", "moreblocks:iron_stone")
minetest.register_alias("moreblocks:woodtile", "moreblocks:wood_tile")
minetest.register_alias("moreblocks:woodtile_full", "moreblocks:wood_tile_full")
minetest.register_alias("moreblocks:woodtile_centered", "moreblocks:wood_tile_centered")
minetest.register_alias("moreblocks:woodtile_up", "moreblocks:wood_tile_offset")
minetest.register_alias("moreblocks:wood_tile_up", "moreblocks:wood_tile_offset")
minetest.register_alias("moreblocks:woodtile_down", "moreblocks:wood_tile_down")
minetest.register_alias("moreblocks:woodtile_left", "moreblocks:wood_tile_left")
minetest.register_alias("moreblocks:woodtile_right", "moreblocks:wood_tile_right")
minetest.register_alias("moreblocks:coalglass", "moreblocks:coal_glass")
minetest.register_alias("moreblocks:ironglass", "moreblocks:iron_glass")
minetest.register_alias("moreblocks:glowglass", "moreblocks:glow_glass")
minetest.register_alias("moreblocks:superglowglass", "moreblocks:super_glow_glass")
minetest.register_alias("moreblocks:trapglass", "moreblocks:trap_glass")
minetest.register_alias("moreblocks:trapstone", "moreblocks:trap_stone")
minetest.register_alias("moreblocks:cactuschecker", "moreblocks:cactus_checker")
minetest.register_alias("moreblocks:coalchecker", "moreblocks:coal_checker")
minetest.register_alias("moreblocks:ironchecker", "moreblocks:iron_checker")
minetest.register_alias("moreblocks:cactusbrick", "moreblocks:cactus_brick")
minetest.register_alias("moreblocks:cleanglass", "moreblocks:clean_glass")
minetest.register_alias("moreblocks:emptybookshelf", "moreblocks:empty_bookshelf")
minetest.register_alias("moreblocks:junglestick", "moreblocks:jungle_stick")
minetest.register_alias("moreblocks:splitstonesquare", "moreblocks:split_stone_tile")
minetest.register_alias("moreblocks:allfacestree", "moreblocks:all_faces_tree")
minetest.register_alias("moreblocks:empty_bookshelf", "moreblocks:empty_shelf")
minetest.register_alias("moreblocks:split_stone_tile_alt", "moreblocks:checker_stone_tile")

if moreblocks.has.stairsplus and cm.jungle_wood then
	stairsplus.api.register_alias_all("moreblocks:jungle_wood", cm.jungle_wood)
end

if moreblocks.has.stairsplus then
	stairsplus.api.register_alias_all("moreblocks:split_stone_tile_alt", "moreblocks:checker_stone_tile")
end

minetest.register_lbm({
	name = "moreblocks:reduce_wood_tile_redundancy",
	nodenames = {
		"moreblocks:wood_tile_left",
		"moreblocks:wood_tile_down",
		"moreblocks:wood_tile_right",
		"moreblocks:wood_tile_flipped",
	},
	action = function(pos, node)
		if node.name == "moreblocks:wood_tile_left" then
			minetest.set_node(pos, { name = "moreblocks:wood_tile_offset", param2 = 1 })
		elseif node.name == "moreblocks:wood_tile_down" then
			minetest.set_node(pos, { name = "moreblocks:wood_tile_offset", param2 = 2 })
		elseif node.name == "moreblocks:wood_tile_right" then
			minetest.set_node(pos, { name = "moreblocks:wood_tile_offset", param2 = 3 })
		else
			-- wood_tile_flipped
			minetest.set_node(pos, { name = "moreblocks:wood_tile", param2 = 1 })
		end
		moreblocks.log("action", "LBM replaced %s at %s", node.name, minetest.pos_to_string(pos))
	end,
})

local horizontal_tree_convert_facedir = { 7, 12, 9, 18 }
if cm.tree then
	minetest.register_lbm({
		name = "moreblocks:reduce_horizontal_tree_redundancy",
		nodenames = {
			"moreblocks:horizontal_tree",
		},
		action = function(pos, node)
			node.name = cm.tree
			node.param2 = node.param2 < 3 and node.param2 or 0
			minetest.set_node(pos, {
				name = node.name,
				param2 = horizontal_tree_convert_facedir[node.param2 + 1],
			})
			moreblocks.log("action", "LBM replaced %s at %s", node.name, minetest.pos_to_string(pos))
		end,
	})
end

if cm.jungle_tree then
	minetest.register_lbm({
		name = "moreblocks:reduce_horizontal_jungle_tree_redundancy",
		nodenames = {
			"moreblocks:horizontal_jungle_tree",
		},
		action = function(pos, node)
			node.name = cm.jungle_tree
			node.param2 = node.param2 < 3 and node.param2 or 0
			minetest.set_node(pos, {
				name = node.name,
				param2 = horizontal_tree_convert_facedir[node.param2 + 1],
			})
			moreblocks.log("action", "LBM replaced %s at %s", node.name, minetest.pos_to_string(pos))
		end,
	})
end
