wa_path = minetest.get_modpath("weld_all")

zones = {
	dropsites = {}
}

local function each_min(a, b)
	--vector.combine(v, w, func)
	return vector.new(math.min(a.x, b.x), math.min(a.y, b.y), math.min(a.z, b.z))
end

local function each_max(a, b)
	return vector.new(math.max(a.x, b.x), math.max(a.y, b.y), math.max(a.z, b.z))
end

Zone = {}
function Zone.Create(a, b)
	return {
		min = each_min(a, b),
		max = each_max(a, b)
	}
end

function Zone.is_in_zone(self, p)
	return self.min.x <= p.x and self.min.y <= p.y and self.min.z <= p.z and
		   self.max.x >= p.x and self.max.y >= p.y and self.max.z >= p.z
end

-- returns the position with the lowest y coordinate that is empty
function Zone.get_lowest_empty(self)
	local diff = vector.subtract(self.max, self.min)
	for dy = 0, diff.y do
		for dx = 0, diff.x do
			for dz = 0, diff.z do
				local node = minetest.get_node(vector.offset(self.min, dx, dy, dz))
				if node.name == "air" or node.name == "vacuum:vacuum" then
					return vector.offset(self.min, dx, dy, dz)
				end
			end
		end
	end
end

dofile(wa_path.."/weld_all_entity.lua");
dofile(wa_path.."/commands.lua");
dofile(wa_path.."/mission.lua");
dofile(wa_path.."/crafting.lua");


minetest.register_entity("weld_all:weld_all", WeldAllEntity)

selected_obj = nil

is_on_move_plate = false

old_physics = nil


local function get_close_node_next_to_trapdoor(pos)
	local node = minetest.get_node(pos)
	return vector.new(pos.x + 1, pos.y, pos.z)
end


local function find_mine_entrance(pos)
	--minetest.find_node_near(pos, radius, nodenames
	--minetest.find_nodes_in_area(pos1, pos2, nodenames,
	--minetest.find_nodes_in_area_under_air(pos1, pos2, nodenames)
end


local function create_enter_mine_commands(pos)
	commands = {}
	table.insert(commands, CreateMoveCommand(get_close_node_next_to_trapdoor(pos)))
	table.insert(commands, CreateOpenDoorCommand(pos))
	table.insert(commands, CreateMiningCommand(vector.subtract(pos, vector.new(0, 1, 0))))
	table.insert(commands, CreatePrecisionMoveCommand(pos))
	table.insert(commands, CreatePrecisionMoveCommand(vector.subtract(pos, vector.new(0, 1, 0))))
	table.insert(commands, CreateCloseDoorCommand(pos))
	table.insert(commands, CreateMiningCommand(vector.subtract(pos, vector.new(0, 2, 0))))
	table.insert(commands, CreatePrecisionMoveCommand(vector.subtract(pos, vector.new(0, 2, 0))))
	table.insert(commands, CreateMiningCommand(vector.subtract(pos, vector.new(0, 3, 0))))
	table.insert(commands, CreatePrecisionMoveCommand(vector.subtract(pos, vector.new(0, 3, 0))))
	return { Command.Create(Command.Types.Combined, "EnterMineCombinedCommand", commands) }
end

local function is_vector_in_table(t, v)
	for _, q in ipairs(t) do
		if q.x == v.x and q.y == v.y and q.z == v.z then return true end
	end
	return false
end

function Zone.find_zone_in_list(t, v)
	for _, zone in ipairs(t) do
		if Zone.is_in_zone(zone, v) then return zone end
	end
end


local function use_tool(_, user, pointed_thing)
    	local target_pos = nil

	if pointed_thing.type == "node" then
		target_pos = pointed_thing.above
		if selected_obj then
			if is_entrance_node(pointed_thing.under) then
				minetest.debug("going to entrance: " .. dump(pointed_thing.under))
				selected_obj:set_commands(create_enter_mine_commands(pointed_thing.under))
				selected_obj = nil
			elseif Zone.find_zone_in_list(zones.dropsites, target_pos) then
				local zone = Zone.find_zone_in_list(zones.dropsites, target_pos)
				minetest.debug("drop into " .. dump(zone))
				--target_pos = Zone.get_lowest_empty(zone)
				selected_obj:set_commands({CreateDumpAllCommand(zone)})
			elseif vector.length(vector.subtract(user:get_pos(), target_pos)) < 1 then
				minetest.debug("toggle plate: ")
				--user:set_pos(pointed_thing.under)
				is_on_move_plate = not is_on_move_plate
				if is_on_move_plate then
					selected_obj:set_commands({CreateRemoteControlCommand(user)})
					old_physics = user:get_physics_override()
					user:set_physics_override(
						{
							speed = 0,
							jump = 0
						}
					)
				else
					selected_obj:set_commands({})
					user:set_physics_override(old_physics)
					selected_obj = nil
				end
			elseif user:get_player_control().sneak then
				minetest.debug("create mine")
				selected_obj:set_commands({
					-- todo: space must be free there!
					CreateMoveCommand(vector.add(target_pos, vector.new(1, 0, 0))),
					CreateDigMineCommand(target_pos, 6)})
				selected_obj = nil
			else
				minetest.debug("send to location")
				selected_obj:set_commands({CreateMoveCommand(target_pos)})
				selected_obj = nil
			end
		else
			minetest.add_entity(target_pos, "weld_all:weld_all")
			inv = create_inventory("my_test_inv")
			inv:set_size("main", 32)
			--inv:set_width("main",8)
		end

	elseif pointed_thing.type == "object" then
		local obj = pointed_thing.ref:get_luaentity()
		if obj and obj.set_commands then
			if selected_obj then
				show_inventory(user:get_player_name(), "my_test_inv")
			else
				minetest.debug("selected")
				selected_obj = obj
			end
		end
		return
	end
end


minetest.register_craftitem("weld_all:spawner", {
	description = "Move",
	inventory_image = "railbuilder_trackmarker.png",
	on_use = use_tool,
	on_secondary_use = use_tool,
	on_place = use_tool

})

first_drop_marked = nil

local function use_dropmarker_tool(_, user, pointed_thing)
	local target_pos = nil

	minetest.debug("create dropmarker")
	if pointed_thing.type == "node" then
		target_pos = pointed_thing.above
		if not first_drop_marked then
			first_drop_marked = target_pos
		else
			table.insert(zones.dropsites, Zone.Create(first_drop_marked, target_pos))
			first_drop_marked = nil
		end
	end
end


minetest.register_craftitem("weld_all:dropmarker", {
	description = "Drop",
	inventory_image = "railbuilder_trackmarker.png",
	on_use = use_dropmarker_tool,
	on_secondary_use = use_dropmarker_tool,
	on_place = use_dropmarker_tool

})


local function use_minemarker_tool(_, user, pointed_thing)
	local target_pos = nil

	minetest.debug("create minemarker")
	if pointed_thing.type == "node" then
		target_pos = pointed_thing.above
		table.insert(zones.minesites, target_pos)
	end
end


minetest.register_craftitem("weld_all:minemarker", {
	description = "Mine",
	inventory_image = "railbuilder_trackmarker.png",
	on_use = use_minemarker_tool,
	on_secondary_use = use_minemarker_tool,
	on_place = use_minemarker_tool

})


local chemsampler_formspec =
	"size[8,7;]" ..
	"list[context;input;0,0.3;3,1;]" ..
	"list[current_player;main;0,2.85;8,1;]" ..
	"list[current_player;main;0,4.08;8,3;8]" ..
	"listring[context;books]" ..
	"listring[current_player;main]"
	--default.get_hotbar_bg(0,2.85)



minetest.register_node("weld_all:chemsampler", {
	description = "Chemicals Sampler",
	tiles = {"ChemSampler_Top.png", "ChemSampler_Bottom.png", "ChemSampler_Right.png", "ChemSampler_Left.png", "ChemSampler_Back.png", "ChemSampler_Front.png"},
	is_ground_content = false,
	groups = {dig_immediate = 3},
	paramtype2 = "facedir",
	--sounds = default.node_sound_stone_defaults()
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		inv:set_size("input", 3 * 1)
		meta:set_string("formspec", chemsampler_formspec)
	end,
	on_metadata_inventory_put = function(pos, listname, index, stack, player)
		local mission = Mission.get_current_objective()
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		local completed = mission:has_achieved_objective(player, inv:get_list("input"))
		if completed then mission:reward_player(player) end
	end,
})


local function is_clear_for_landing(pos)
	for dx = -2, 2 do
		for dz = -2, 2 do
			for dy = 0, 6 do
				local node = minetest.get_node(vector.offset(pos, dx, dy, dz)).name
				if node ~= "air" and node ~= "vacuum:vacuum" then
					return false
				end
			end
		end
	end
	return true
end


minetest.register_node("weld_all:landing_site_marker", {
	description = "LandingSiteMarker",
	tiles = {"LandingSiteMarker.png"},
	paramtype = "light",
	buildable_to = true,
	floodable = true,
	drawtype = "nodebox",
	node_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.5, 0.5, -0.45, 0.5},
		},
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.5, 0.5, -0.45, 0.5},
		},
	},
	--inventory_image = "default_snowball.png",
	wield_image = "LandingSiteMarker.png",
	groups = {crumbly = 3},
	--sounds = default.node_sound_snow_defaults(),
	on_place = function(itemstack, placer, pointed_thing)
		-- check area
		local pos = pointed_thing.above
		if not is_clear_for_landing(pos) then
			minetest.debug("no space for landing!")
			return nil
		else
			return minetest.item_place(itemstack, placer, pointed_thing)
		end
	end,
	on_construct = function(pos)
		minetest.get_node_timer(pos):start(math.random(10, 20))
	end,

	on_timer = function(pos)
		Mission.spawn_supplies(pos)
	end
})


-- Spawn newplayer function

minetest.register_on_newplayer(function(player)
	local inv = player:get_inventory()
	inv:add_item("main", "default:pick_diamond 4")
	inv:add_item("main", "default:shovel_diamond 4")
	inv:add_item("main", "farming:hoe_diamond 4")
	inv:add_item("main", "spacesuit:helmet")
	inv:add_item("main", "spacesuit:chestplate")
	inv:add_item("main", "spacesuit:pants")
	inv:add_item("main", "spacesuit:boots")
	inv:add_item("main", "weld_all:landing_site_marker")
	inv:add_item("main", "default:axe_diamond 4")
end)


-- Respawn player function

minetest.register_on_respawnplayer(function(player)
	local inv = player:get_inventory()
	inv:add_item("main", "default:pick_diamond")
	inv:add_item("main", "default:shovel_diamond 4")
	inv:add_item("main", "farming:hoe_diamond 4")
	inv:add_item("main", "spacesuit:helmet")
	inv:add_item("main", "spacesuit:chestplate")
	inv:add_item("main", "spacesuit:pants")
	inv:add_item("main", "spacesuit:boots")
	inv:add_item("main", "default:axe_diamond 4")

	return true
end)
