# ShameGPT for Minetest

**ShameGPT** is a local AI chatbot integration for Minetest. It allows players to interact with an AI model running on their own machine via **Ollama**. By default, it is optimized for lightweight models like **Gemma 3 (270m)** to ensure a smooth gaming experience even on modest hardware.

## 🚀 Features

* **Local & Private:** No API keys required. Your data never leaves your computer.
* **Asynchronous Processing:** The game won't freeze while the AI is thinking; responses appear in chat once ready.
* **Highly Configurable:** Choose any model you have installed in Ollama via the Minetest settings menu.


* **Sanitized Output:** Automatically cleans ANSI escape codes and formatting artifacts from AI responses.

## 🛠 Prerequisites

Before installing this mod, you must have the following:

1. **Ollama installed and running:** Download it from [ollama.com]().
2. 
**An AI Model:** By default, this mod looks for `gemma3:270m`. You can pull it using:


```bash
ollama pull gemma3:270m

```


3. **Minetest 5.0 or later.**

## 📥 Installation

1. Clone or download this repository into your Minetest `mods` folder.
2. Rename the folder to `shamegpt`.
3. **Critical Security Step:** Because this mod executes system commands to talk to Ollama, you **must** grant it trusted status. Add the following line to your `minetest.conf` file:
```text
secure.trusted_mods = shamegpt

```



## ⚙️ Configuration

You can change the AI model used by the mod in the **Settings** tab of the Minetest main menu:

* **AI Model (`model_name`):** The name of the model installed in Ollama.


* *Default:* `gemma3:270m`.


* *Recommendation:* Use lightweight models (under 3B parameters) to prevent CPU spikes while playing.





## 🎮 Usage

Once in-game, any player with the `interact` privilege can use the following command:

```text
/shamegpt <your message here>

```

**Example:**
`/shamegpt Why is there a creeper in my house?` (Wait... wrong game!)

### Security Note

The mod includes a safety filter that blocks symbols like `; & | [cite_start]$` to prevent command injection, ensuring that players can only send text prompts to the AI.

## 📝 License

This project is licensed under the same terms as Minetest (LGPL-2.1).
