local ie = minetest.request_insecure_environment()
local ai_model = minetest.settings:get("model_name") or "gemma3:270m"

if not ie then
    error("\n[shamegpt] CRITICAL ERROR!\n" ..
          "Add 'secure.trusted_mods = shamegpt' to your minetest.conf")
end

local active_requests = {}

local function clean_ai_text(text)
    if not text then return "" end
    local clean = text:gsub("\27%[[%d;]*%a", "")
    clean = clean:gsub("\r", "")
    clean = clean:gsub("\t", "    ")
    return clean:match("^%s*(.-)%s*$")
end


local function is_safe_prompt(text)

    return text:match("^[%w%s%?%.%,%!%-%_%(%)]*$") ~= nil
end

minetest.register_globalstep(function(dtime)

    if next(active_requests) == nil then return end

    for name, request in pairs(active_requests) do
        request.timer = (request.timer or 0) + dtime
        
        if request.timer > 0.5 then 
            request.timer = 0

            local done_check = ie.io.open(request.file .. ".done", "r")
            if done_check then
                done_check:close()
                
                local f = ie.io.open(request.file, "r")
                if f then
                    local content = f:read("*a")
                    f:close()

                    local final_text = clean_ai_text(content)
                    
                    if final_text ~= "" then
                        minetest.chat_send_all("[ShameGPT]: " .. final_text)
                    else
                        minetest.chat_send_all("[ShameGPT]: (Error: The AI returned an empty response)")
                    end

                    ie.os.remove(request.file)
                    ie.os.remove(request.file .. ".done")
                end
                active_requests[name] = nil
            end
        end
    end
end)

minetest.register_chatcommand("shamegpt", {
    params = "<text/prompt>",
    description = "Run a local query to ShameGPT via Ollama (Safe & Async)",
    privs = {interact = true},
    func = function(name, param)
        if param == "" then 
            return false, "Usage: /shamegpt [message]" 
        end
        
        if active_requests[name] then 
            return false, "Please wait, ShameGPT is still processing your previous request." 
        end

        if not is_safe_prompt(param) then
            return false, "Error: Your message contains forbidden characters (symbols like ; & | $ are not allowed)."
        end

        minetest.chat_send_all("... " .. name .. " is asking ShameGPT (" .. ai_model .. ") ...")

        local temp_file = ie.os.tmpname() .. "_" .. name:gsub("%W", "")
        
        local cmd = string.format("ollama run %s '%s' > %s 2>/dev/null && touch %s.done &",
                                  ai_model, param, temp_file, temp_file)
        
        local success = ie.os.execute(cmd)
        
        if success then
            active_requests[name] = {file = temp_file, timer = 0}
            return true, "Request sent! Waiting for response..."
        else
            return false, "Error: Failed to execute Ollama. Is the service running?"
        end
    end,
})
