core.register_chatcommand("dump_builder_info", {
	params = "<player name>",
	privs = {["debug"] = true},
	description = "prints debug information for player's builder context",
	func = function(name, param)
		local data = builders_wand.get_data_from_name(name)

		return true, core.debug(dump(data))
	end

})

core.register_chatcommand("wipe_builder_info", {
	params = "<player name>",
	privs = {["debug"] = true},
	description = "Wipes builder context of a player, will leave player in broken state until he rejoins",
	func = function(name, param)
		builders_wand.player_data[name] = nil
		builders_wand.initialize_player_data(core.get_player_by_name(name))

		return true
	end

})

core.register_chatcommand("dump_group", {
	params = "<group name>",
	privs = {["debug"] = true},
	description = "Wipes builder context of a player, will leave player in broken state until he rejoins",
	func = function(name, param)
		return true, table.concat(builders_wand.get_groups_items(param, core.get_player_by_name(name)), "\n")
	end

})
