local search_offsets = {
	[core.hash_node_position(vector.new(1, 0, 0))] = {
			vector.new(0, 1,  0),
			vector.new(0, -1, 0),
			vector.new(0, 0,  1),
			vector.new(0, 0,  -1),
	},
	[core.hash_node_position(vector.new(-1, 0, 0))] = {
			vector.new(0, 1,  0),
			vector.new(0, -1, 0),
			vector.new(0, 0,  1),
			vector.new(0, 0,  -1),
	},
	[core.hash_node_position(vector.new(0, 1, 0))] = {
		vector.new(1,  0, 0),
		vector.new(-1, 0, 0),
		vector.new(0,  0, 1),
		vector.new(0,  0, -1),
	},
	[core.hash_node_position(vector.new(0, -1, 0))] = {
		vector.new(1,  0, 0),
		vector.new(-1, 0, 0),
		vector.new(0,  0, 1),
		vector.new(0,  0, -1),
	},
	[core.hash_node_position(vector.new(0, 0, 1))] = {
		vector.new(1,  0, 0),
		vector.new(-1, 0, 0),
		vector.new(0,  1, 0),
		vector.new(0, -1, 0),
	},
	[core.hash_node_position(vector.new(0, 0, -1))] = {
		vector.new(1,  0, 0),
		vector.new(-1, 0, 0),
		vector.new(0,  1, 0),
		vector.new(0, -1, 0),
	}
}

local function get_faces(pos, dir)
	local faces = {}
	local already_added = {}

	local function attempt_extrusion(pos)
		local hash = core.hash_node_position(pos)
		if not already_added[hash]
				and core.get_node(pos).name ~= "air"
				and core.get_node(pos:add(dir)).name == "air" then
			table.insert(faces, pos)
			already_added[hash] = true
		end
	end

	local offsets = search_offsets[core.hash_node_position(dir)]

	attempt_extrusion(pos)

	local i = 0
	local frustration = 25000
	while i ~= #faces and i < frustration do
		i = i + 1
		local pos = faces[i]
		for _, search_offset in pairs(offsets) do
			attempt_extrusion(vector.add(pos, search_offset))
		end
	end

	if i >= frustration then
		core.log("warning", "tried to extend an unreasonable amount of nodes. Dropping the attempt")
		return {}
	end

	return faces
end

function builders_wand.extrude(pos, dir)
	local faces = get_faces(pos, dir)

	for _, v in pairs(faces) do
		local node = core.get_node(v)
		core.set_node(vector.add(v, dir), node)

	end
end

function builders_wand.indent(pos, dir)
	core.bulk_set_node(get_faces(pos, dir), {name = "air"})
end
