-- copyright (c) 2024 rstcxk
-- 
-- this program is free software: you can redistribute it and/or modify it under the terms of
-- the gnu affero general public license as published by the free software foundation, either version 3 of the license, or (at your option) any later version.
-- 
-- this program is distributed in the hope that it will be useful, but without any warranty;
-- without even the implied warranty of merchantability or fitness for a particular purpose. see the gnu affero general public license for more details.
-- 
-- you should have received a copy of the gnu affero general public license along with this program. if not, see <https://www.gnu.org/licenses/>. 


---{{{ wood

builders_wand.is_player_inventory_list_relevant = function(listname)
	return listname == "main"
end

builders_wand.register_group(
{
	group_name = "wood"
},
{
	"mcl_trees:wood_spruce",
	"mcl_trees:wood_warped",
	"mcl_trees:wood_acacia",
	"mcl_trees:wood_bamboo",
	"mcl_trees:wood_birch",
	"mcl_trees:wood_cherry_blossom",
	"mcl_trees:wood_crimson",
	"mcl_trees:wood_dark_oak",
	"mcl_trees:wood_jungle",
	"mcl_trees:wood_mangrove",
	"mcl_trees:wood_oak",
})

builders_wand.register_group(
{
	group_name = "fences",
	sort_name = "functional_blocks"
},
{
	"mcl_fences:acacia_fence",
	"mcl_fences:acacia_fence_gate",
	"mcl_fences:bamboo_fence",
	"mcl_fences:bamboo_fence_gate",
	"mcl_fences:birch_fence",
	"mcl_fences:birch_fence_gate",
	"mcl_fences:cherry_blossom_fence",
	"mcl_fences:cherry_blossom_fence_gate",
	"mcl_fences:crimson_fence",
	"mcl_fences:crimson_fence_gate",
	"mcl_fences:dark_oak_fence",
	"mcl_fences:dark_oak_fence_gate",
	"mcl_fences:jungle_fence",
	"mcl_fences:jungle_fence_gate",
	"mcl_fences:mangrove_fence",
	"mcl_fences:mangrove_fence_gate",
	"mcl_fences:nether_brick_fence",
	"mcl_fences:nether_brick_fence_gate",
	"mcl_fences:oak_fence",
	"mcl_fences:oak_fence_gate",
	"mcl_fences:red_nether_brick_fence",
	"mcl_fences:red_nether_brick_fence_gate",
	"mcl_fences:spruce_fence",
	"mcl_fences:spruce_fence_gate",
	"mcl_fences:warped_fence",
	"mcl_fences:warped_fence_gate",
})

builders_wand.register_group(
{
	group_name = "trapdoors",
	sort_name = "functional_blocks"
},
{
	"mcl_copper:trapdoor",
	"mcl_copper:trapdoor_exposed",
	"mcl_copper:trapdoor_exposed_preserved",
	"mcl_copper:trapdoor_oxidized",
	"mcl_copper:trapdoor_oxidized_preserved",
	"mcl_copper:trapdoor_preserved",
	"mcl_copper:trapdoor_weathered",
	"mcl_copper:trapdoor_weathered_preserved",
	"mcl_doors:iron_trapdoor",
	"mcl_doors:trapdoor_acacia",
	"mcl_doors:trapdoor_bamboo",
	"mcl_doors:trapdoor_birch",
	"mcl_doors:trapdoor_cherry_blossom",
	"mcl_doors:trapdoor_crimson",
	"mcl_doors:trapdoor_dark_oak",
	"mcl_doors:trapdoor_jungle",
	"mcl_doors:trapdoor_mangrove",
	"mcl_doors:trapdoor_oak",
	"mcl_doors:trapdoor_spruce",
	"mcl_doors:trapdoor_warped",
})

builders_wand.register_group(
{
	group_name = "signs",
	sort_name = "functional_blocks"
},
{
	"mcl_signs:wall_sign_acacia",
	"mcl_signs:wall_sign_bamboo",
	"mcl_signs:wall_sign_birch",
	"mcl_signs:wall_sign_cherry_blossom",
	"mcl_signs:wall_sign_crimson",
	"mcl_signs:wall_sign_dark_oak",
	"mcl_signs:wall_sign_jungle",
	"mcl_signs:wall_sign_mangrove",
	"mcl_signs:wall_sign_oak",
	"mcl_signs:wall_sign_spruce",
	"mcl_signs:wall_sign_warped",
})

builders_wand.register_group(
{
	group_name = "beds",
	sort_name = "functional_blocks"
},
{
	"mcl_beds:bed_black_bottom",
	"mcl_beds:bed_blue_bottom",
	"mcl_beds:bed_brown_bottom",
	"mcl_beds:bed_cyan_bottom",
	"mcl_beds:bed_green_bottom",
	"mcl_beds:bed_grey_bottom",
	"mcl_beds:bed_light_blue_bottom",
	"mcl_beds:bed_lime_bottom",
	"mcl_beds:bed_magenta_bottom",
	"mcl_beds:bed_orange_bottom",
	"mcl_beds:bed_pink_bottom",
	"mcl_beds:bed_purple_bottom",
	"mcl_beds:bed_red_bottom",
	"mcl_beds:bed_silver_bottom",
	"mcl_beds:bed_white_bottom",
	"mcl_beds:bed_yellow_bottom",
})

builders_wand.register_group(
{
	group_name = "oak",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_oak",
	"mcl_trees:wood_oak",
	"mcl_fences:oak_fence_gate",
	"mcl_buttons:button_oak_off",
	-- "mcl_doors:door_oak",
	"mcl_doors:trapdoor_oak",
	"mcl_fences:oak_fence",
	"mcl_pressureplates:pressure_plate_oak_off",
	"mcl_signs:wall_sign_oak",
	"mcl_stairs:slab_oak",
	"mcl_stairs:slab_oak_bark",
	"mcl_stairs:stair_oak",
	"mcl_stairs:stair_oak_bark",
	"mcl_trees:bark_oak",
	"mcl_trees:bark_stripped_oak",
	"mcl_trees:leaves_oak",
	"mcl_trees:sapling_oak",
	"mcl_trees:stripped_oak",
})

builders_wand.register_group(
{
	group_name = "dark oak",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_dark_oak",
	"mcl_trees:wood_dark_oak",
	-- "mcl_doors:door_dark_oak",
	"mcl_buttons:button_dark_oak_off",
	"mcl_doors:trapdoor_dark_oak",
	"mcl_fences:dark_oak_fence",
	"mcl_fences:dark_oak_fence_gate",
	"mcl_pressureplates:pressure_plate_dark_oak_off",
	"mcl_signs:wall_sign_dark_oak",
	"mcl_stairs:slab_dark_oak",
	"mcl_stairs:slab_dark_oak_bark",
	"mcl_stairs:stair_dark_oak",
	"mcl_stairs:stair_dark_oak_bark",
	"mcl_trees:bark_dark_oak",
	"mcl_trees:bark_stripped_dark_oak",
	"mcl_trees:leaves_dark_oak",
	"mcl_trees:sapling_dark_oak",
	"mcl_trees:stripped_dark_oak",
})


builders_wand.register_group(
{
	group_name = "acacia",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_acacia",
	"mcl_trees:wood_acacia",
	"mcl_buttons:button_acacia_off",
	-- "mcl_doors:door_acacia",
	"mcl_doors:trapdoor_acacia",
	"mcl_fences:acacia_fence",
	"mcl_fences:acacia_fence_gate",
	"mcl_pressureplates:pressure_plate_acacia_off",
	"mcl_signs:wall_sign_acacia",
	"mcl_stairs:slab_acacia",
	"mcl_stairs:slab_acacia_bark",
	"mcl_stairs:stair_acacia",
	"mcl_stairs:stair_acacia_bark",
	"mcl_trees:bark_acacia",
	"mcl_trees:bark_stripped_acacia",
	"mcl_trees:leaves_acacia",
	"mcl_trees:sapling_acacia",
	"mcl_trees:stripped_acacia",
})

builders_wand.register_group(
{
	group_name = "bamboo",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_bamboo",
	"mcl_trees:wood_bamboo",
	"mcl_bamboo:bamboo_mosaic",
	"mcl_bamboo:scaffolding",
	"mcl_buttons:button_bamboo_off",
	-- "mcl_doors:door_bamboo",
	"mcl_doors:trapdoor_bamboo",
	"mcl_fences:bamboo_fence",
	"mcl_fences:bamboo_fence_gate",
	"mcl_pressureplates:pressure_plate_bamboo_off",
	"mcl_signs:wall_sign_bamboo",
	"mcl_stairs:slab_bamboo",
	"mcl_stairs:stair_bamboo",
	"mcl_trees:stripped_bamboo",
})

builders_wand.register_group(
{
	group_name = "birch",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_birch",
	"mcl_trees:wood_birch",
	"mcl_buttons:button_birch_off",
	-- "mcl_doors:door_birch",
	"mcl_doors:trapdoor_birch",
	"mcl_fences:birch_fence",
	"mcl_fences:birch_fence_gate",
	"mcl_pressureplates:pressure_plate_birch_off",
	"mcl_signs:wall_sign_birch",
	"mcl_stairs:slab_birch",
	"mcl_stairs:slab_birch_bark",
	"mcl_stairs:stair_birch",
	"mcl_stairs:stair_birch_bark",
	"mcl_trees:bark_birch",
	"mcl_trees:bark_stripped_birch",
	"mcl_trees:leaves_birch",
	"mcl_trees:sapling_birch",
	"mcl_trees:stripped_birch",
})

builders_wand.register_group(
{
	group_name = "cherry",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_cherry_blossom",
	"mcl_trees:wood_cherry_blossom",
	"mcl_buttons:button_cherry_blossom_off",
	"mcl_cherry_blossom:pink_petals",
	-- "mcl_doors:door_cherry_blossom",
	"mcl_doors:trapdoor_cherry_blossom",
	"mcl_fences:cherry_blossom_fence",
	"mcl_fences:cherry_blossom_fence_gate",
	"mcl_pressureplates:pressure_plate_cherry_blossom_off",
	"mcl_signs:wall_sign_cherry_blossom",
	"mcl_stairs:slab_cherry_blossom",
	"mcl_stairs:slab_cherry_blossom_bark",
	"mcl_stairs:stair_cherry_blossom",
	"mcl_stairs:stair_cherry_blossom_bark",
	"mcl_trees:bark_cherry_blossom",
	"mcl_trees:bark_stripped_cherry_blossom",
	"mcl_trees:leaves_cherry_blossom",
	"mcl_trees:sapling_cherry_blossom",
	"mcl_trees:stripped_cherry_blossom",
})

builders_wand.register_group(
{
	group_name = "crimson",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_crimson",
	"mcl_trees:wood_crimson",
	"mcl_buttons:button_crimson_off",
	"mcl_crimson:crimson_roots",
	"mcl_crimson:crimson_fungus",
	"mcl_crimson:weeping_vines",
	-- "mcl_doors:door_crimson",
	"mcl_doors:trapdoor_crimson",
	"mcl_fences:crimson_fence",
	"mcl_fences:crimson_fence_gate",
	"mcl_pressureplates:pressure_plate_crimson_off",
	"mcl_signs:wall_sign_crimson",
	"mcl_stairs:slab_crimson",
	"mcl_stairs:slab_crimson_bark",
	"mcl_stairs:stair_crimson",
	"mcl_stairs:stair_crimson_bark",
	"mcl_trees:bark_crimson",
	"mcl_trees:bark_stripped_crimson",
	"mcl_trees:stripped_crimson",
})

builders_wand.register_group(
{
	group_name = "jungle",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_jungle",
	"mcl_trees:wood_jungle",
	"mcl_buttons:button_jungle_off",
	-- "mcl_cocoas:cocoa_beans",
	-- "mcl_doors:door_jungle",
	"mcl_doors:trapdoor_jungle",
	"mcl_fences:jungle_fence",
	"mcl_fences:jungle_fence_gate",
	"mcl_pressureplates:pressure_plate_jungle_off",
	"mcl_signs:wall_sign_jungle",
	"mcl_stairs:slab_jungle",
	"mcl_stairs:slab_jungle_bark",
	"mcl_stairs:stair_jungle",
	"mcl_stairs:stair_jungle_bark",
	"mcl_trees:bark_jungle",
	"mcl_trees:bark_stripped_jungle",
	"mcl_trees:leaves_jungle",
	"mcl_trees:sapling_jungle",
	"mcl_trees:stripped_jungle",
})

builders_wand.register_group(
{
	group_name = "mangrove",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_mangrove",
	"mcl_trees:wood_mangrove",
	"mcl_buttons:button_mangrove_off",
	-- "mcl_doors:door_mangrove",
	"mcl_doors:trapdoor_mangrove",
	"mcl_fences:mangrove_fence",
	"mcl_fences:mangrove_fence_gate",
	"mcl_mangrove:mangrove_mud_roots",
	"mcl_mangrove:mangrove_roots",
	"mcl_mangrove:propagule",
	"mcl_pressureplates:pressure_plate_mangrove_off",
	"mcl_signs:wall_sign_mangrove",
	"mcl_stairs:slab_mangrove",
	"mcl_stairs:slab_mangrove_bark",
	"mcl_stairs:stair_mangrove",
	"mcl_stairs:stair_mangrove_bark",
	"mcl_trees:bark_mangrove",
	"mcl_trees:bark_stripped_mangrove",
	"mcl_trees:leaves_mangrove",
	"mcl_trees:stripped_mangrove",
})

builders_wand.register_group(
{
	group_name = "spruce",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_spruce",
	"mcl_trees:wood_spruce",
	"mcl_buttons:button_spruce_off",
	-- "mcl_doors:door_spruce",
	"mcl_doors:trapdoor_spruce",
	"mcl_fences:spruce_fence",
	"mcl_fences:spruce_fence_gate",
	"mcl_pressureplates:pressure_plate_spruce_off",
	"mcl_signs:wall_sign_spruce",
	"mcl_stairs:slab_spruce",
	"mcl_stairs:slab_spruce_bark",
	"mcl_stairs:stair_spruce",
	"mcl_stairs:stair_spruce_bark",
	"mcl_trees:bark_spruce",
	"mcl_trees:bark_stripped_spruce",
	"mcl_trees:leaves_spruce",
	"mcl_trees:sapling_spruce",
	"mcl_trees:stripped_spruce",
})

builders_wand.register_group(
{
	group_name = "warped",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_warped",
	"mcl_trees:wood_warped",
	-- "mcl_buttons:button_warp",
	"mcl_crimson:warped_fungus",
	"mcl_crimson:warped_roots",
	"mcl_crimson:warped_wart_block",
	-- "mcl_doors:door_warped",
	"mcl_doors:trapdoor_warped",
	"mcl_fences:warped_fence",
	"mcl_fences:warped_fence_gate",
	"mcl_pressureplates:pressure_plate_warped_off",
	"mcl_signs:wall_sign_warped",
	"mcl_stairs:slab_warped",
	"mcl_stairs:slab_warped_bark",
	"mcl_stairs:stair_warped",
	"mcl_stairs:stair_warped_bark",
	"mcl_trees:bark_stripped_warped",
	"mcl_trees:bark_warped",
	"mcl_trees:stripped_warped",
})

---}}}

---{{{ misc


builders_wand.register_group(
{
	group_name = "bricks",
},
{
	"mcl_core:brick_block",
	"mcl_blackstone:blackstone_brick_polished",
	"mcl_blackstone:blackstone_brick_polished_cracked",
	"mcl_blackstone:quartz_brick",
	"mcl_core:stonebrick",
	"mcl_core:stonebrickcarved",
	"mcl_core:stonebrickcracked",
	"mcl_core:stonebrickmossy",
	"mcl_deepslate:deepslate_bricks",
	"mcl_deepslate:deepslate_bricks_cracked",
	"mcl_deepslate:tuff_bricks",
	"mcl_deepslate:tuff_chiseled_bricks",
	"mcl_end:end_bricks",
	"mcl_mud:mud_bricks",
	"mcl_nether:chiseled_nether_brick",
	"mcl_nether:cracked_nether_brick",
	"mcl_nether:nether_brick",
	"mcl_nether:red_nether_brick",
	"mcl_ocean:prismarine_brick",
})

---}}}

---{{{ stone

builders_wand.register_group(
{
	group_name = "stone",
	sort_name = "terrain_blocks",
},
{
	"mcl_core:cobble",
	"mcl_buttons:button_stone_off",
	"mcl_core:stone",
	"mcl_core:stone_smooth",
	"mcl_core:mossycobble",
	"mcl_core:stonebrick",
	"mcl_core:stonebrickcarved",
	"mcl_core:stonebrickcracked",
	"mcl_core:stonebrickmossy",
	"mcl_pressureplates:pressure_plate_stone_off",
	"mcl_stairs:slab_cobble",
	"mcl_stairs:slab_mossycobble",
	"mcl_stairs:slab_stone_rough",
	"mcl_stairs:slab_stonebrick",
	"mcl_stairs:slab_stonebrickcracked",
	"mcl_stairs:slab_stonebrickmossy",
	"mcl_stairs:stair_cobble",
	"mcl_stairs:stair_stone",
	"mcl_stairs:stair_stone_rough",
	"mcl_stairs:stair_stonebrick",
	"mcl_stairs:stair_stonebrickcracked",
	"mcl_stairs:stair_stonebrickmossy",
	"mcl_walls:cobble",
	"mcl_walls:stonebrick",
	"mcl_walls:stonebrickmossy",
	"mcl_walls:mossycobble",
})

builders_wand.register_group(
{
	group_name = "stone variants",
	sort_name = "terrain_blocks",
},
{
	"mcl_blackstone:basalt",
	"mcl_blackstone:basalt_smooth",
	"mcl_blackstone:blackstone",
	"mcl_blackstone:basalt_polished",
	"mcl_core:cobble",
	"mcl_core:stone",
	"mcl_core:redsandstone",
	"mcl_core:sandstone",
	"mcl_end:end_stone",
	"mcl_nether:netherrack",
	"mcl_core:diorite",
	"mcl_core:granite",
	"mcl_core:gravel",
	"mcl_core:andesite",
	"mcl_amethyst:calcite",
	"mcl_deepslate:deepslate",
	"mcl_deepslate:deepslate_cobbled",
	"mcl_deepslate:tuff",
	"mcl_dripstone:dripstone_block",
})

builders_wand.register_group(
{
	group_name = "ores",
	sort_name = "terrain_blocks",
},
{
	"mcl_core:stone_with_iron",
	"mcl_deepslate:deepslate_with_iron",
	"mcl_raw_ores:raw_iron_block",
	"mcl_core:ironblock",
	"mcl_core:stone_with_gold",
	"mcl_deepslate:deepslate_with_gold",
	"mcl_blackstone:nether_gold",
	"mcl_raw_ores:raw_gold_block",
	"mcl_core:goldblock",
	"mcl_copper:stone_with_copper",
	"mcl_deepslate:deepslate_with_copper",
	"mcl_copper:block_raw",
	"mcl_copper:block",
	"mcl_core:stone_with_coal",
	"mcl_deepslate:deepslate_with_coal",
	"mcl_core:coalblock",
	"mcl_core:stone_with_diamond",
	"mcl_deepslate:deepslate_with_diamond",
	"mcl_core:diamondblock",
	"mcl_core:stone_with_emerald",
	"mcl_deepslate:deepslate_with_emerald",
	"mcl_core:emeraldblock",
	"mcl_core:stone_with_lapis",
	"mcl_deepslate:deepslate_with_lapis",
	"mcl_core:lapisblock",
	"mcl_redstone_torch:redstoneblock",
	"mcl_core:stone_with_redstone",
	"mcl_deepslate:deepslate_with_redstone",
	"mcl_nether:quartz_ore",
	"mcl_nether:quartz_block",
})

builders_wand.register_group(
{
	group_name = "deepslate",
	sort_name = "terrain_blocks",
},
{
	"mcl_deepslate:deepslate",
	"mcl_deepslate:deepslate_bricks",
	"mcl_deepslate:deepslate_bricks_cracked",
	"mcl_deepslate:deepslate_chiseled",
	"mcl_deepslate:deepslate_cobbled",
	"mcl_deepslate:deepslate_polished",
	"mcl_deepslate:deepslate_reinforced",
	"mcl_deepslate:deepslate_tiles",
	"mcl_deepslate:deepslate_tiles_cracked",
	"mcl_deepslate:deepslatebrickswall",
	"mcl_deepslate:deepslatecobbledwall",
	"mcl_deepslate:deepslatepolishedwall",
	"mcl_deepslate:deepslatetileswall",
	"mcl_monster_eggs:monster_egg_deepslate",
	"mcl_stairs:slab_deepslate_bricks",
	"mcl_stairs:slab_deepslate_bricks_cracked",
	"mcl_stairs:slab_deepslate_cobbled",
	"mcl_stairs:slab_deepslate_polished",
	"mcl_stairs:slab_deepslate_tiles",
	"mcl_stairs:slab_deepslate_tiles_cracked",
	"mcl_stairs:stair_deepslate_bricks",
	"mcl_stairs:stair_deepslate_bricks_cracked",
	"mcl_stairs:stair_deepslate_cobbled",
	"mcl_stairs:stair_deepslate_polished",
	"mcl_stairs:stair_deepslate_tiles",
	"mcl_stairs:stair_deepslate_tiles_cracked",
})

builders_wand.register_group(
{
	group_name = "tuff",
	sort_name = "terrain_blocks",
},
{
	"mcl_deepslate:tuff",
	"mcl_deepslate:tuff_bricks",
	"mcl_deepslate:tuff_chiseled",
	"mcl_deepslate:tuff_chiseled_bricks",
	"mcl_deepslate:tuff_polished",
	"mcl_deepslate:tuffbrickswall",
	"mcl_deepslate:tuffpolishedwall",
	"mcl_stairs:slab_tuff_bricks",
	"mcl_stairs:slab_tuff_polished",
	"mcl_stairs:stair_tuff_bricks",
	"mcl_stairs:stair_tuff_polished",
})

builders_wand.register_group(
{
	group_name = "quartz",
},
{
	"mcl_nether:quartz_block",
	"mcl_blackstone:quartz_brick",
	"mcl_nether:quartz_chiseled",
	"mcl_nether:quartz_pillar",
	"mcl_nether:quartz_smooth",
	"mcl_stairs:slab_quartz_smooth",
	"mcl_stairs:slab_quartzblock",
	"mcl_stairs:stair_quartz_smooth",
	"mcl_stairs:stair_quartzblock",
})

builders_wand.register_group(
{
	group_name = "terracotta",
	sort_name = "terrain_blocks",
},
{
	"mcl_colorblocks:hardened_clay",
	"mcl_colorblocks:hardened_clay_black",
	"mcl_colorblocks:hardened_clay_blue",
	"mcl_colorblocks:hardened_clay_brown",
	"mcl_colorblocks:hardened_clay_cyan",
	"mcl_colorblocks:hardened_clay_green",
	"mcl_colorblocks:hardened_clay_grey",
	"mcl_colorblocks:hardened_clay_light_blue",
	"mcl_colorblocks:hardened_clay_lime",
	"mcl_colorblocks:hardened_clay_magenta",
	"mcl_colorblocks:hardened_clay_orange",
	"mcl_colorblocks:hardened_clay_pink",
	"mcl_colorblocks:hardened_clay_purple",
	"mcl_colorblocks:hardened_clay_red",
	"mcl_colorblocks:hardened_clay_silver",
	"mcl_colorblocks:hardened_clay_white",
	"mcl_colorblocks:hardened_clay_yellow",
	"mcl_stairs:slab_hardened_clay",
	"mcl_stairs:slab_hardened_clay_black",
	"mcl_stairs:slab_hardened_clay_blue",
	"mcl_stairs:slab_hardened_clay_brown",
	"mcl_stairs:slab_hardened_clay_cyan",
	"mcl_stairs:slab_hardened_clay_green",
	"mcl_stairs:slab_hardened_clay_grey",
	"mcl_stairs:slab_hardened_clay_light_blue",
	"mcl_stairs:slab_hardened_clay_lime",
	"mcl_stairs:slab_hardened_clay_magenta",
	"mcl_stairs:slab_hardened_clay_orange",
	"mcl_stairs:slab_hardened_clay_pink",
})

builders_wand.register_group(
{
	group_name = "glazed terracotta",
},
{
	"mcl_colorblocks:glazed_terracotta_black",
	"mcl_colorblocks:glazed_terracotta_blue",
	"mcl_colorblocks:glazed_terracotta_brown",
	"mcl_colorblocks:glazed_terracotta_cyan",
	"mcl_colorblocks:glazed_terracotta_green",
	"mcl_colorblocks:glazed_terracotta_grey",
	"mcl_colorblocks:glazed_terracotta_light_blue",
	"mcl_colorblocks:glazed_terracotta_lime",
	"mcl_colorblocks:glazed_terracotta_magenta",
	"mcl_colorblocks:glazed_terracotta_orange",
	"mcl_colorblocks:glazed_terracotta_pink",
	"mcl_colorblocks:glazed_terracotta_purple",
	"mcl_colorblocks:glazed_terracotta_red",
	"mcl_colorblocks:glazed_terracotta_silver",
	"mcl_colorblocks:glazed_terracotta_white",
	"mcl_colorblocks:glazed_terracotta_yellow",
})

builders_wand.register_group(
{
	group_name = "netherack",
	sort_name = "terrain_blocks",
},
{
	"mcl_nether:netherrack",
	"mcl_fences:nether_brick_fence",
	"mcl_fences:nether_brick_fence_gate",
	"mcl_fences:red_nether_brick_fence",
	"mcl_fences:red_nether_brick_fence_gate",
	"mcl_nether:chiseled_nether_brick",
	"mcl_nether:cracked_nether_brick",
	"mcl_nether:ancient_debris",
	"mcl_nether:glowstone",
	"mcl_nether:magma",
	"mcl_nether:netheriteblock",
	"mcl_nether:nether_brick",
	"mcl_nether:red_nether_brick",
	"mcl_stairs:slab_nether_brick",
	"mcl_stairs:slab_red_nether_brick",
	"mcl_stairs:stair_nether_brick",
	"mcl_stairs:stair_red_nether_brick",
	"mcl_walls:netherbrick",
	"mcl_walls:rednetherbrick",
})

builders_wand.register_group(
{
	group_name = "blackstone",
	sort_name = "terrain_blocks",
},
{
	"mcl_blackstone:basalt",
	"mcl_blackstone:basalt_polished",
	"mcl_blackstone:basalt_smooth",
	"mcl_blackstone:blackstone",
	"mcl_blackstone:blackstone_brick_polished",
	"mcl_blackstone:blackstone_brick_polished_cracked",
	"mcl_blackstone:blackstone_chiseled_polished",
	"mcl_blackstone:blackstone_gilded",
	"mcl_blackstone:blackstone_polished",
	"mcl_blackstone:wall",
	"mcl_buttons:button_polished_blackstone_off",
	"mcl_pressureplates:pressure_plate_polished_blackstone_off",
	"mcl_stairs:slab_blackstone",
	"mcl_stairs:slab_blackstone_brick_polished",
	"mcl_stairs:slab_blackstone_polished",
	"mcl_stairs:stair_blackstone",
	"mcl_stairs:stair_blackstone_brick_polished",
	"mcl_stairs:stair_blackstone_polished",
})

builders_wand.register_group(
{
	group_name = "wall",
	sort_name = "functional_blocks"
},
{
	"mcl_blackstone:wall",
	"mcl_deepslate:deepslatebrickswall",
	"mcl_deepslate:deepslatecobbledwall",
	"mcl_deepslate:deepslatepolishedwall",
	"mcl_deepslate:deepslatetileswall",
	"mcl_deepslate:tuffbrickswall",
	"mcl_deepslate:tuffpolishedwall",
	"mcl_walls:andesite",
	"mcl_walls:brick",
	"mcl_walls:cobble",
	"mcl_walls:diorite",
	"mcl_walls:endbricks",
	"mcl_walls:granite",
	"mcl_walls:mossycobble",
	"mcl_walls:mudbrick",
	"mcl_walls:netherbrick",
	"mcl_walls:prismarine",
	"mcl_walls:rednetherbrick",
	"mcl_walls:redsandstone",
	"mcl_walls:sandstone",
	"mcl_walls:stonebrick",
	"mcl_walls:stonebrickmossy",
})

---}}}

---{{{ metals

builders_wand.register_group(
{
	group_name = "copper",
	sort_name = "copper_variants",
},
{
	"mcl_copper:block_exposed",
	"mcl_copper:block",
	"mcl_copper:block_chiseled",
	"mcl_copper:block_chiseled_preserved",
	"mcl_copper:block_cut",
	"mcl_copper:block_cut_preserved",
	"mcl_copper:block_exposed_chiseled",
	"mcl_copper:block_exposed_chiseled_preserved",
	"mcl_copper:block_exposed_cut",
	"mcl_copper:block_exposed_cut_preserved",
	"mcl_copper:block_exposed_grate",
	"mcl_copper:block_exposed_grate_preserved",
	"mcl_copper:block_exposed_preserved",
	"mcl_copper:block_grate",
	"mcl_copper:block_grate_preserved",
	"mcl_copper:block_oxidized",
	"mcl_copper:block_oxidized_chiseled",
	-- "mcl_copper:block_oxidized_chiseled_preserved",
	"mcl_copper:block_oxidized_cut",
	"mcl_copper:block_oxidized_cut_preserved",
	"mcl_copper:block_oxidized_grate",
	"mcl_copper:block_oxidized_grate_preserved",
	"mcl_copper:block_oxidized_preserved",
	"mcl_copper:block_preserved",
	"mcl_copper:block_raw",
	"mcl_copper:block_weathered",
	"mcl_copper:block_weathered_chiseled",
	"mcl_copper:block_weathered_chiseled_preserved",
	"mcl_copper:block_weathered_cut",
	"mcl_copper:block_weathered_cut_preserved",
	"mcl_copper:block_weathered_grate",
	"mcl_copper:block_weathered_grate_preserved",
	"mcl_copper:block_weathered_preserved",
	"mcl_copper:bulb_exposed_off",
	"mcl_copper:bulb_exposed_off_preserved",
	"mcl_copper:bulb_off",
	"mcl_copper:bulb_off_preserved",
	"mcl_copper:bulb_oxidized_off",
	"mcl_copper:bulb_oxidized_off_preserved",
	"mcl_copper:bulb_weathered_off",
	"mcl_copper:bulb_weathered_off_preserved",
	-- "mcl_copper:door",
	-- "mcl_copper:door_exposed",
	-- "mcl_copper:door_oxidized",
	-- "mcl_copper:door_weathered",
	-- "mcl_copper:trapdoor",
	-- "mcl_copper:trapdoor_exposed",
	-- "mcl_copper:trapdoor_exposed_preserved",
	-- "mcl_copper:trapdoor_oxidized",
	-- "mcl_copper:trapdoor_oxidized_preserved",
	-- "mcl_copper:trapdoor_preserved",
	-- "mcl_copper:trapdoor_weathered",
	-- "mcl_copper:trapdoor_weathered_preserved",
	"mcl_stairs:slab_copper_cut",
	"mcl_stairs:slab_copper_cut_preserved",
	"mcl_stairs:slab_copper_exposed_cut",
	"mcl_stairs:slab_copper_exposed_cut_preserved",
	"mcl_stairs:slab_copper_oxidized_cut",
	"mcl_stairs:slab_copper_oxidized_cut_preserved",
	"mcl_stairs:slab_copper_weathered_cut",
	"mcl_stairs:slab_copper_weathered_cut_preserved",
	"mcl_stairs:stair_copper_cut",
	"mcl_stairs:stair_copper_cut_preserved",
	"mcl_stairs:stair_copper_exposed_cut",
	"mcl_stairs:stair_copper_exposed_cut_preserved",
	"mcl_stairs:stair_copper_oxidized_cut",
	"mcl_stairs:stair_copper_oxidized_cut_preserved",
	"mcl_stairs:stair_copper_weathered_cut",
	"mcl_stairs:stair_copper_weathered_cut_preserved",
})

builders_wand.register_group(
{
	group_name = "waxed copper",
	sort_name = "copper_variants",
},
{
	"mcl_copper:block_preserved",
	"mcl_copper:block_chiseled_preserved",
	"mcl_copper:block_cut_preserved",
	"mcl_copper:block_exposed_chiseled_preserved",
	"mcl_copper:block_exposed_cut_preserved",
	"mcl_copper:block_exposed_grate_preserved",
	"mcl_copper:block_exposed_preserved",
	"mcl_copper:block_grate_preserved",
	-- "mcl_copper:block_oxidized_chiseled_preserved",
	"mcl_copper:block_oxidized_cut_preserved",
	"mcl_copper:block_oxidized_grate_preserved",
	"mcl_copper:block_oxidized_preserved",
	"mcl_copper:block_weathered_chiseled_preserved",
	"mcl_copper:block_weathered_cut_preserved",
	"mcl_copper:block_weathered_grate_preserved",
	"mcl_copper:block_weathered_preserved",
	"mcl_copper:bulb_exposed_off_preserved",
	"mcl_copper:bulb_off_preserved",
	"mcl_copper:bulb_oxidized_off_preserved",
	"mcl_copper:bulb_weathered_off_preserved",
	-- "mcl_copper:trapdoor_exposed_preserved",
	-- "mcl_copper:trapdoor_oxidized_preserved",
	-- "mcl_copper:trapdoor_preserved",
	-- "mcl_copper:trapdoor_weathered_preserved",
	"mcl_stairs:slab_copper_cut_preserved",
	"mcl_stairs:slab_copper_exposed_cut_preserved",
	"mcl_stairs:slab_copper_oxidized_cut_preserved",
	"mcl_stairs:slab_copper_weathered_cut_preserved",
	"mcl_stairs:stair_copper_cut_preserved",
	"mcl_stairs:stair_copper_exposed_cut_preserved",
	"mcl_stairs:stair_copper_oxidized_cut_preserved",
	"mcl_stairs:stair_copper_weathered_cut_preserved",
})

builders_wand.register_group(
{
	group_name = "waxed exposed copper",
	sort_name = "copper_variants",
},
{
	"mcl_copper:block_exposed_preserved",
	"mcl_copper:block_exposed_chiseled_preserved",
	"mcl_copper:block_exposed_cut_preserved",
	"mcl_copper:block_exposed_grate_preserved",
	"mcl_copper:bulb_exposed_off_preserved",
	-- "mcl_copper:door_exposed",
	-- "mcl_copper:trapdoor_exposed_preserved",
	"mcl_stairs:slab_copper_exposed_cut_preserved",
	"mcl_stairs:stair_copper_exposed_cut_preserved",
})

builders_wand.register_group(
{
	group_name = "waxed weathered copper",
	sort_name = "copper_variants",
},
{
	"mcl_copper:block_weathered_chiseled_preserved",
	"mcl_copper:block_weathered_cut_preserved",
	"mcl_copper:block_weathered_grate_preserved",
	"mcl_copper:block_weathered_preserved",
	"mcl_copper:bulb_weathered_off_preserved",
	-- "mcl_copper:door_weathered",
	-- "mcl_copper:trapdoor_weathered_preserved",
	"mcl_stairs:slab_copper_weathered_cut_preserved",
	"mcl_stairs:stair_copper_weathered_cut_preserved",
})

builders_wand.register_group(
{
	group_name = "waxed oxidized copper",
	sort_name = "copper_variants",
},
{
	-- "mcl_copper:block_oxidized_chiseled_preserved ",
	"mcl_copper:block_oxidized_cut_preserved",
	"mcl_copper:block_oxidized_grate_preserved",
	"mcl_copper:block_oxidized_preserved",
	"mcl_copper:bulb_oxidized_off_preserved",
	-- "mcl_copper:door_oxidized",
	-- "mcl_copper:trapdoor_oxidized_preserved",
	"mcl_stairs:slab_copper_oxidized_cut_preserved",
	"mcl_stairs:stair_copper_oxidized_cut_preserved",
})

builders_wand.register_group(
{
	group_name = "iron",
	sort_name = "ores"
},
{
	"mcl_core:ironblock",
	-- "mcl_doors:iron_door",
	"mcl_doors:iron_trapdoor",
	"mcl_panes:bar_flat",
	"mcl_stairs:slab_ironblock",
	"mcl_stairs:stair_ironblock",
	"mcl_raw_ores:raw_iron_block",
})

builders_wand.register_group(
{
	group_name = "gold",
	sort_name = "ores"
},
{
	"mcl_core:goldblock",
	"mcl_raw_ores:raw_gold_block",
	"mcl_stairs:slab_goldblock",
	"mcl_stairs:stair_goldblock",
})

---}}}

---{{{ color blocks

builders_wand.register_group(
{
	group_name = "red",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_red",
	"mcl_colorblocks:concrete_red",
	"mcl_beds:bed_red_bottom",
	"mcl_chests:red_shulker_box",
	"mcl_colorblocks:concrete_powder_red",
	"mcl_colorblocks:glazed_terracotta_red",
	"mcl_colorblocks:hardened_clay_red",
	"mcl_panes:pane_red_flat",
	"mcl_core:glass_red",
	"mcl_stairs:slab_concrete_red",
	"mcl_stairs:stair_concrete_red",
	"mcl_wool:red",
	"mcl_wool:red_carpet",
})

builders_wand.register_group(
{
	group_name = "blue",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_blue",
	"mcl_colorblocks:concrete_blue",
	"mcl_beds:bed_blue_bottom",
	"mcl_chests:blue_shulker_box",
	"mcl_colorblocks:concrete_powder_blue",
	"mcl_colorblocks:glazed_terracotta_blue",
	"mcl_colorblocks:hardened_clay_blue",
	"mcl_core:glass_blue",
	"mcl_panes:pane_blue_flat",
	"mcl_stairs:slab_concrete_blue",
	"mcl_stairs:slab_hardened_clay_blue",
	"mcl_stairs:stair_concrete_blue",
	"mcl_wool:blue",
	"mcl_stairs:stair_hardened_clay_blue",
	"mcl_wool:blue_carpet",
})

builders_wand.register_group(
{
	group_name = "green",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_green",
	"mcl_colorblocks:concrete_green",
	"mcl_beds:bed_green_bottom",
	"mcl_chests:dark_green_shulker_box",
	"mcl_colorblocks:concrete_powder_green",
	"mcl_colorblocks:glazed_terracotta_green",
	"mcl_colorblocks:hardened_clay_green",
	"mcl_core:glass_green",
	"mcl_panes:pane_green_flat",
	"mcl_stairs:slab_concrete_green",
	"mcl_stairs:slab_hardened_clay_green",
	"mcl_stairs:stair_concrete_green",
	"mcl_stairs:stair_hardened_clay_green",
	"mcl_wool:green",
	"mcl_wool:green_carpet",
})

builders_wand.register_group(
{
	group_name = "lime",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_lime",
	"mcl_colorblocks:concrete_lime",
	"mcl_beds:bed_lime_bottom",
	"mcl_chests:green_shulker_box",
	"mcl_colorblocks:concrete_powder_lime",
	"mcl_colorblocks:glazed_terracotta_lime",
	"mcl_colorblocks:hardened_clay_lime",
	"mcl_core:glass_lime",
	"mcl_panes:pane_lime_flat",
	"mcl_stairs:slab_concrete_lime",
	"mcl_stairs:slab_hardened_clay_lime",
	"mcl_stairs:stair_concrete_lime",
	"mcl_stairs:stair_hardened_clay_lime",
	"mcl_wool:lime",
	"mcl_wool:lime_carpet",
})

builders_wand.register_group(
{
	group_name = "light blue",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_light_blue",
	"mcl_colorblocks:concrete_light_blue",
	"mcl_beds:bed_light_blue_bottom",
	"mcl_chests:lightblue_shulker_box",
	"mcl_colorblocks:concrete_powder_light_blue",
	"mcl_colorblocks:glazed_terracotta_light_blue",
	"mcl_colorblocks:hardened_clay_light_blue",
	"mcl_core:glass_light_blue",
	"mcl_panes:pane_light_blue_flat",
	"mcl_stairs:slab_concrete_light_blue",
	"mcl_stairs:slab_hardened_clay_light_blue",
	"mcl_stairs:stair_concrete_light_blue",
	"mcl_stairs:stair_hardened_clay_light_blue",
	"mcl_wool:light_blue",
	"mcl_wool:light_blue_carpet",
})

builders_wand.register_group(
{
	group_name = "yellow",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_yellow",
	"mcl_colorblocks:concrete_yellow",
	"mcl_beds:bed_yellow_bottom",
	"mcl_chests:yellow_shulker_box",
	"mcl_colorblocks:concrete_powder_yellow",
	"mcl_colorblocks:glazed_terracotta_yellow",
	"mcl_colorblocks:hardened_clay_yellow",
	"mcl_core:glass_yellow",
	"mcl_panes:pane_yellow_flat",
	"mcl_stairs:slab_concrete_yellow",
	"mcl_stairs:slab_hardened_clay_yellow",
	"mcl_stairs:stair_concrete_yellow",
	"mcl_stairs:stair_hardened_clay_yellow",
	"mcl_wool:yellow",
	"mcl_wool:yellow_carpet",
})

builders_wand.register_group(
{
	group_name = "black",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_black",
	"mcl_colorblocks:concrete_black",
	"mcl_beds:bed_black_bottom",
	"mcl_chests:black_shulker_box",
	"mcl_colorblocks:concrete_powder_black",
	"mcl_colorblocks:glazed_terracotta_black",
	"mcl_colorblocks:hardened_clay_black",
	"mcl_core:glass_black",
	"mcl_panes:pane_black_flat",
	"mcl_pressureplates:pressure_plate_polished_blackstone_off",
	"mcl_stairs:slab_concrete_black",
	"mcl_stairs:slab_hardened_clay_black",
	"mcl_stairs:stair_concrete_black",
	"mcl_stairs:stair_hardened_clay_black",
	"mcl_wool:black",
	"mcl_wool:black_carpet",
})

builders_wand.register_group(
{
	group_name = "grey",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_grey",
	"mcl_colorblocks:concrete_grey",
	"mcl_beds:bed_grey_bottom",
	"mcl_chests:dark_grey_shulker_box",
	"mcl_colorblocks:concrete_powder_grey",
	"mcl_colorblocks:glazed_terracotta_grey",
	"mcl_colorblocks:hardened_clay_grey",
	"mcl_core:glass_grey",
	"mcl_panes:pane_grey_flat",
	"mcl_stairs:slab_concrete_grey",
	"mcl_stairs:slab_hardened_clay_grey",
	"mcl_stairs:stair_concrete_grey",
	"mcl_stairs:stair_hardened_clay_grey",
	"mcl_wool:grey",
	"mcl_wool:grey_carpet",
})

builders_wand.register_group(
{
	group_name = "brown",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_brown",
	"mcl_colorblocks:concrete_brown",
	"mcl_beds:bed_brown_bottom",
	"mcl_chests:brown_shulker_box",
	"mcl_colorblocks:concrete_powder_brown",
	"mcl_colorblocks:glazed_terracotta_brown",
	"mcl_colorblocks:hardened_clay_brown",
	"mcl_core:glass_brown",
	"mcl_panes:pane_brown_flat",
	"mcl_stairs:slab_concrete_brown",
	"mcl_stairs:slab_hardened_clay_brown",
	"mcl_stairs:stair_concrete_brown",
	"mcl_stairs:stair_hardened_clay_brown",
	"mcl_wool:brown",
	"mcl_wool:brown_carpet",
})

builders_wand.register_group(
{
	group_name = "cyan",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_cyan",
	"mcl_colorblocks:concrete_cyan",
	"mcl_beds:bed_cyan_bottom",
	"mcl_chests:cyan_shulker_box",
	"mcl_colorblocks:concrete_powder_cyan",
	"mcl_colorblocks:glazed_terracotta_cyan",
	"mcl_colorblocks:hardened_clay_cyan",
	"mcl_core:glass_cyan",
	"mcl_panes:pane_cyan_flat",
	"mcl_stairs:slab_concrete_cyan",
	"mcl_stairs:slab_hardened_clay_cyan",
	"mcl_stairs:stair_concrete_cyan",
	"mcl_stairs:stair_hardened_clay_cyan",
	"mcl_wool:cyan",
	"mcl_wool:cyan_carpet",
})

builders_wand.register_group(
{
	group_name = "magenta",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_magenta",
	"mcl_colorblocks:concrete_magenta",
	"mcl_beds:bed_magenta_bottom",
	"mcl_chests:magenta_shulker_box",
	"mcl_colorblocks:concrete_powder_magenta",
	"mcl_colorblocks:glazed_terracotta_magenta",
	"mcl_colorblocks:hardened_clay_magenta",
	"mcl_core:glass_magenta",
	"mcl_panes:pane_magenta_flat",
	"mcl_stairs:slab_concrete_magenta",
	"mcl_stairs:slab_hardened_clay_magenta",
	"mcl_stairs:stair_concrete_magenta",
	"mcl_stairs:stair_hardened_clay_magenta",
	"mcl_wool:magenta",
	"mcl_wool:magenta_carpet",
})

builders_wand.register_group(
{
	group_name = "orange",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_orange",
	"mcl_colorblocks:concrete_orange",
	"mcl_beds:bed_orange_bottom",
	"mcl_chests:orange_shulker_box",
	"mcl_colorblocks:concrete_powder_orange",
	"mcl_colorblocks:glazed_terracotta_orange",
	"mcl_colorblocks:hardened_clay_orange",
	"mcl_core:glass_orange",
	"mcl_panes:pane_orange_flat",
	"mcl_stairs:slab_concrete_orange",
	"mcl_stairs:slab_hardened_clay_orange",
	"mcl_stairs:stair_concrete_orange",
	"mcl_stairs:stair_hardened_clay_orange",
	"mcl_wool:orange",
	"mcl_wool:orange_carpet",
})

builders_wand.register_group(
{
	group_name = "pink",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_pink",
	"mcl_colorblocks:concrete_pink",
	"mcl_beds:bed_pink_bottom",
	"mcl_chests:pink_shulker_box",
	"mcl_colorblocks:concrete_powder_pink",
	"mcl_colorblocks:glazed_terracotta_pink",
	"mcl_colorblocks:hardened_clay_pink",
	"mcl_core:glass_pink",
	"mcl_panes:pane_pink_flat",
	"mcl_stairs:slab_concrete_pink",
	"mcl_stairs:slab_hardened_clay_pink",
	"mcl_stairs:stair_concrete_pink",
	"mcl_stairs:stair_hardened_clay_pink",
	"mcl_wool:pink",
	"mcl_wool:pink_carpet",
})

builders_wand.register_group(
{
	group_name = "purple",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_purple",
	"mcl_colorblocks:concrete_purple",
	"mcl_beds:bed_purple_bottom",
	"mcl_chests:violet_shulker_box",
	"mcl_colorblocks:concrete_powder_purple",
	"mcl_colorblocks:glazed_terracotta_purple",
	"mcl_colorblocks:hardened_clay_purple",
	"mcl_core:glass_purple",
	"mcl_panes:pane_purple_flat",
	"mcl_stairs:slab_concrete_purple",
	"mcl_stairs:slab_hardened_clay_purple",
	"mcl_stairs:stair_concrete_purple",
	"mcl_stairs:stair_hardened_clay_purple",
	"mcl_wool:purple",
	"mcl_wool:purple_carpet",
})

builders_wand.register_group(
{
	group_name = "white",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_white",
	"mcl_colorblocks:concrete_white",
	"mcl_beds:bed_white_bottom",
	"mcl_chests:white_shulker_box",
	"mcl_colorblocks:concrete_powder_white",
	"mcl_colorblocks:glazed_terracotta_white",
	"mcl_colorblocks:hardened_clay_white",
	"mcl_core:glass_white",
	"mcl_panes:pane_white_flat",
	"mcl_stairs:slab_concrete_white",
	"mcl_stairs:slab_hardened_clay_white",
	"mcl_stairs:stair_concrete_white",
	"mcl_stairs:stair_hardened_clay_white",
	"mcl_wool:white",
	"mcl_wool:white_carpet",
})

builders_wand.register_group(
{
	group_name = "light grey",
	sort_name = "color"
},
{
	-- "mcl_banners:banner_item_silver",
	"mcl_colorblocks:concrete_silver",
	"mcl_beds:bed_silver_bottom",
	"mcl_chests:grey_shulker_box",
	"mcl_colorblocks:concrete_powder_silver",
	"mcl_colorblocks:glazed_terracotta_silver",
	"mcl_colorblocks:hardened_clay_silver",
	"mcl_core:glass_silver",
	"mcl_panes:pane_silver_flat",
	"mcl_stairs:slab_concrete_silver",
	"mcl_stairs:slab_hardened_clay_silver",
	"mcl_stairs:stair_concrete_silver",
	"mcl_stairs:stair_hardened_clay_silver",
	"mcl_wool:silver",
	"mcl_wool:silver_carpet",
})

---}}}

---{{{ misc

builders_wand.register_group(
{
	group_name = "redstone",
	sort_name = "functional_blocks"
},
{
	"mcl_redstone:redstone",
	"mcl_comparators:comparator_off_comp",
	"mcl_copper:bulb_off_preserved",
	"mcl_buttons:button_stone_off",
	"mcl_daylight_detector:daylight_detector",
	"mcl_dispensers:dispenser",
	"mcl_dispensers:dropper",
	"mcl_hoppers:hopper",
	"mcl_lever:lever_off",
	"mcl_minecarts:activator_rail",
	"mcl_minecarts:golden_rail",
	"mcl_noteblock:noteblock",
	"mcl_observers:observer_off",
	"mcl_pistons:piston_off",
	"mcl_pistons:piston_sticky_off",
	"mcl_redstone_lamp:lamp_off",
	"mcl_redstone_torch:redstone_torch_on",
	"mcl_redstone_torch:redstoneblock",
	"mcl_repeaters:repeater_off_1",
	"mcl_target:target_off",
	"mcl_tnt:tnt",
	"mcl_core:slimeblock",
	"mcl_honey:honey_block",
})

builders_wand.register_group(
{
	group_name = "rail",
	sort_name = "functional_blocks"
},
{
	"mcl_minecarts:activator_rail",
	"mcl_minecarts:detector_rail",
	"mcl_minecarts:golden_rail",
	"mcl_minecarts:rail",
})

builders_wand.register_group(
{
	group_name = "glass",
},
{
	"mcl_amethyst:tinted_glass",
	"mcl_core:glass",
	"mcl_core:glass_black",
	"mcl_core:glass_blue",
	"mcl_core:glass_brown",
	"mcl_core:glass_cyan",
	"mcl_core:glass_green",
	"mcl_core:glass_grey",
	"mcl_core:glass_light_blue",
	"mcl_core:glass_lime",
	"mcl_core:glass_magenta",
	"mcl_core:glass_orange",
	"mcl_core:glass_pink",
	"mcl_core:glass_purple",
	"mcl_core:glass_red",
	"mcl_core:glass_silver",
	"mcl_core:glass_white",
	"mcl_core:glass_yellow",
	"mcl_panes:pane_black_flat",
	"mcl_panes:pane_blue_flat",
	"mcl_panes:pane_brown_flat",
	"mcl_panes:pane_cyan_flat",
	"mcl_panes:pane_green_flat",
	"mcl_panes:pane_grey_flat",
	"mcl_panes:pane_light_blue_flat",
	"mcl_panes:pane_lime_flat",
	"mcl_panes:pane_magenta_flat",
	"mcl_panes:pane_natural_flat",
	"mcl_panes:pane_orange_flat",
	"mcl_panes:pane_pink_flat",
	"mcl_panes:pane_purple_flat",
	"mcl_panes:pane_red_flat",
	"mcl_panes:pane_silver_flat",
	"mcl_panes:pane_white_flat",
	"mcl_panes:pane_yellow_flat",
})

builders_wand.register_group(
{
	group_name = "decorational",
	sort_name = "functional_blocks"
},
{
	"mcl_anvils:anvil",
	"mcl_anvils:anvil_damage_1",
	"mcl_anvils:anvil_damage_2",
	"mcl_barrels:barrel_closed",
	"mcl_beacons:beacon",
	"mcl_beds:respawn_anchor",
	"mcl_blast_furnace:blast_furnace",
	"mcl_cartography_table:cartography_table",
	"mcl_chests:chest",
	"mcl_chests:ender_chest",
	"mcl_chests:trapped_chest",
	"mcl_crafting_table:crafting_table",
	"mcl_furnaces:furnace",
	"mcl_jukebox:jukebox",
	"mcl_lectern:lectern",
	"mcl_loom:loom",
	-- "mcl_paintings:painting",
	"mcl_smithing_table:table",
	"mcl_smoker:smoker",
	"mcl_stonecutter:stonecutter",
	"mcl_bamboo:scaffolding",
	"mcl_armor_stand:armor_stand",
	"mcl_hoppers:hopper",
	"mcl_lanterns:chain",
	"mcl_beehives:beehive",
	"mcl_bells:bell",
	"mcl_books:bookshelf",
	"mcl_campfires:campfire_lit",
	"mcl_lanterns:lantern_floor",
	"mcl_lanterns:soul_lantern_floor",
	"mcl_campfires:soul_campfire_lit",
	"mcl_panes:bar_flat",
	"mcl_cauldrons:cauldron",
	"mcl_compass:lodestone",
	"mcl_composters:composter",
	"mcl_core:ladder",
	"mcl_end:end_rod",
	"mcl_end:dragon_egg",
	"mcl_flowerpots:flower_pot",
	"mcl_grindstone:grindstone",
	"mcl_heads:creeper",
	"mcl_heads:skeleton",
	"mcl_heads:steve",
	"mcl_heads:wither_skeleton",
	"mcl_heads:zombie",
})

-- builders_wand.register_group(
--{
-- group_name = "banners",
-- },
-- {
-- 	"mcl_banners:banner_item_black",
-- 	"mcl_banners:banner_item_blue",
-- 	"mcl_banners:banner_item_brown",
-- 	"mcl_banners:banner_item_cyan",
-- 	"mcl_banners:banner_item_green",
-- 	"mcl_banners:banner_item_grey",
-- 	"mcl_banners:banner_item_light_blue",
-- 	"mcl_banners:banner_item_lime",
-- 	"mcl_banners:banner_item_magenta",
-- 	"mcl_banners:banner_item_orange",
-- 	"mcl_banners:banner_item_pink",
-- 	"mcl_banners:banner_item_purple",
-- 	"mcl_banners:banner_item_red",
-- 	"mcl_banners:banner_item_silver",
-- 	"mcl_banners:banner_item_white",
-- 	"mcl_banners:banner_item_yellow",
-- })

builders_wand.register_group(
{
	group_name = "shulkers",
	sort_name = "functional_blocks"
},
{
	"mcl_chests:black_shulker_box",
	"mcl_chests:blue_shulker_box",
	"mcl_chests:brown_shulker_box",
	"mcl_chests:cyan_shulker_box",
	"mcl_chests:dark_green_shulker_box",
	"mcl_chests:dark_grey_shulker_box",
	"mcl_chests:green_shulker_box",
	"mcl_chests:grey_shulker_box",
	"mcl_chests:lightblue_shulker_box",
	"mcl_chests:magenta_shulker_box",
	"mcl_chests:orange_shulker_box",
	"mcl_chests:pink_shulker_box",
	"mcl_chests:red_shulker_box",
	"mcl_chests:violet_shulker_box",
	"mcl_chests:white_shulker_box",
	"mcl_chests:yellow_shulker_box",
})

builders_wand.register_group(
{
	group_name = "plants",
	sort_name = "plants"
},
{
	"mcl_cherry_blossom:pink_petals",
	"mcl_core:cactus",
	"mcl_core:deadbush",
	"mcl_core:vine",
	"mcl_crimson:crimson_fungus",
	"mcl_crimson:crimson_roots",
	"mcl_crimson:nether_sprouts",
	"mcl_crimson:twisting_vines",
	"mcl_crimson:warped_fungus",
	"mcl_crimson:warped_roots",
	"mcl_crimson:weeping_vines",
	"mcl_end:chorus_flower",
	"mcl_end:chorus_plant",
	"mcl_flowers:allium",
	"mcl_flowers:azure_bluet",
	"mcl_flowers:blue_orchid",
	"mcl_flowers:cornflower",
	"mcl_flowers:dandelion",
	"mcl_flowers:double_fern",
	"mcl_flowers:double_grass",
	"mcl_flowers:fern",
	"mcl_flowers:lilac",
	"mcl_flowers:lily_of_the_valley",
	"mcl_flowers:oxeye_daisy",
	"mcl_flowers:peony",
	"mcl_flowers:poppy",
	"mcl_flowers:rose_bush",
	"mcl_flowers:sunflower",
	"mcl_flowers:tallgrass",
	"mcl_flowers:tulip_orange",
	"mcl_flowers:tulip_pink",
	"mcl_flowers:tulip_red",
	"mcl_flowers:tulip_white",
	"mcl_flowers:waterlily",
	"mcl_flowers:wither_rose",
	"mcl_lush_caves:azalea",
	"mcl_lush_caves:azalea_flowering",
	"mcl_lush_caves:azalea_leaves",
	"mcl_lush_caves:azalea_leaves_flowering",
	"mcl_lush_caves:cave_vines",
	"mcl_lush_caves:cave_vines_lit",
	"mcl_lush_caves:hanging_roots",
	"mcl_lush_caves:moss_carpet",
	"mcl_lush_caves:spore_blossom",
	"mcl_mangrove:mangrove_roots",
	"mcl_mangrove:propagule",
	"mcl_mushrooms:mushroom_brown",
	"mcl_mushrooms:mushroom_red",
	"mcl_ocean:sea_pickle_1_dead_brain_coral_block",
	-- "mcl_ocean:seagrass",
	-- "mcl_ocean:kelp",
	"mcl_trees:sapling_acacia",
	"mcl_trees:sapling_birch",
	"mcl_trees:sapling_cherry_blossom",
	"mcl_trees:sapling_dark_oak",
	"mcl_trees:sapling_jungle",
	"mcl_trees:sapling_oak",
	"mcl_trees:sapling_spruce",
})

builders_wand.register_group(
{
	group_name = "leaves",
	sort_name = "plants"
},
{
	"mcl_trees:leaves_acacia",
	"mcl_trees:leaves_birch",
	"mcl_trees:leaves_cherry_blossom",
	"mcl_trees:leaves_dark_oak",
	"mcl_trees:leaves_jungle",
	"mcl_trees:leaves_mangrove",
	"mcl_trees:leaves_oak",
	"mcl_trees:leaves_spruce",
})

builders_wand.register_group(
{
	group_name = "carpets",
	sort_name = "functional_blocks"
},
{
	"mcl_wool:silver_carpet",
	"mcl_wool:black_carpet",
	"mcl_wool:blue_carpet",
	"mcl_wool:brown_carpet",
	"mcl_wool:cyan_carpet",
	"mcl_wool:green_carpet",
	"mcl_wool:grey_carpet",
	"mcl_wool:light_blue_carpet",
	"mcl_wool:lime_carpet",
	"mcl_wool:magenta_carpet",
	"mcl_wool:orange_carpet",
	"mcl_wool:pink_carpet",
	"mcl_wool:purple_carpet",
	"mcl_wool:red_carpet",
	"mcl_wool:white_carpet",
	"mcl_wool:yellow_carpet",
	"mcl_lush_caves:moss_carpet",
})

builders_wand.register_group(
{
	group_name = "concrete",
},
{
	"mcl_colorblocks:concrete_black",
	"mcl_colorblocks:concrete_blue",
	"mcl_colorblocks:concrete_brown",
	"mcl_colorblocks:concrete_cyan",
	"mcl_colorblocks:concrete_green",
	"mcl_colorblocks:concrete_grey",
	"mcl_colorblocks:concrete_light_blue",
	"mcl_colorblocks:concrete_lime",
	"mcl_colorblocks:concrete_magenta",
	"mcl_colorblocks:concrete_orange",
	"mcl_colorblocks:concrete_pink",
	"mcl_colorblocks:concrete_powder_black",
	"mcl_colorblocks:concrete_powder_blue",
	"mcl_colorblocks:concrete_powder_brown",
	"mcl_colorblocks:concrete_powder_cyan",
	"mcl_colorblocks:concrete_powder_green",
	"mcl_colorblocks:concrete_powder_grey",
	"mcl_colorblocks:concrete_powder_light_blue",
	"mcl_colorblocks:concrete_powder_lime",
	"mcl_colorblocks:concrete_powder_magenta",
	"mcl_colorblocks:concrete_powder_orange",
	"mcl_colorblocks:concrete_powder_pink",
	"mcl_colorblocks:concrete_powder_purple",
	"mcl_colorblocks:concrete_powder_red",
	"mcl_colorblocks:concrete_powder_white",
	"mcl_colorblocks:concrete_powder_yellow",
	"mcl_colorblocks:concrete_purple",
	"mcl_colorblocks:concrete_red",
	"mcl_colorblocks:concrete_silver",
	"mcl_colorblocks:concrete_white",
	"mcl_colorblocks:concrete_yellow",
	"mcl_stairs:slab_concrete_black",
	"mcl_stairs:slab_concrete_blue",
	"mcl_stairs:slab_concrete_brown",
	"mcl_stairs:slab_concrete_cyan",
	"mcl_stairs:slab_concrete_green",
	"mcl_stairs:slab_concrete_grey",
	"mcl_stairs:slab_concrete_light_blue",
	"mcl_stairs:slab_concrete_lime",
	"mcl_stairs:slab_concrete_magenta",
	"mcl_stairs:slab_concrete_orange",
	"mcl_stairs:slab_concrete_pink",
	"mcl_stairs:slab_concrete_purple",
	"mcl_stairs:slab_concrete_red",
	"mcl_stairs:slab_concrete_silver",
	"mcl_stairs:slab_concrete_white",
	"mcl_stairs:slab_concrete_yellow",
	"mcl_stairs:stair_concrete_black",
	"mcl_stairs:stair_concrete_blue",
	"mcl_stairs:stair_concrete_brown",
	"mcl_stairs:stair_concrete_cyan",
	"mcl_stairs:stair_concrete_green",
	"mcl_stairs:stair_concrete_grey",
	"mcl_stairs:stair_concrete_light_blue",
	"mcl_stairs:stair_concrete_lime",
	"mcl_stairs:stair_concrete_magenta",
	"mcl_stairs:stair_concrete_orange",
	"mcl_stairs:stair_concrete_pink",
	"mcl_stairs:stair_concrete_purple",
	"mcl_stairs:stair_concrete_red",
	"mcl_stairs:stair_concrete_silver",
	"mcl_stairs:stair_concrete_white",
	"mcl_stairs:stair_concrete_yellow",
})

builders_wand.register_group(
{
	group_name = "dirt",
	sort_name = "terrain_blocks",
},
{
	"mcl_core:coarse_dirt",
	"mcl_core:dirt",
	"mcl_core:dirt_with_grass",
	"mcl_lush_caves:rooted_dirt",
	"mcl_colorblocks:concrete_powder_brown",
	"mcl_colorblocks:concrete_brown",
	"mcl_blackstone:soul_soil",
	"mcl_colorblocks:hardened_clay",
	"mcl_colorblocks:hardened_clay_black",
	"mcl_colorblocks:hardened_clay_brown",
	"mcl_colorblocks:hardened_clay_grey",
	"mcl_colorblocks:hardened_clay_silver",
	"mcl_core:podzol",
	"mcl_core:mycelium",
	"mcl_core:granite",
	"mcl_core:gravel",
	"mcl_deepslate:tuff",
	"mcl_dripstone:dripstone_block",
	"mcl_mangrove:mangrove_mud_roots",
	"mcl_mud:mud",
	"mcl_nether:soul_sand",
	"mcl_stairs:slab_hardened_clay_black",
	"mcl_stairs:slab_hardened_clay_brown",
	"mcl_stairs:slab_hardened_clay_grey",
	"mcl_stairs:slab_hardened_clay_silver",
	"mcl_stairs:slab_oak_bark",
	"mcl_stairs:stair_hardened_clay",
	"mcl_stairs:stair_hardened_clay_black",
	"mcl_stairs:stair_hardened_clay_brown",
	"mcl_stairs:stair_granite",
	"mcl_stairs:stair_hardened_clay_grey",
	"mcl_stairs:stair_hardened_clay_silver",
})

builders_wand.register_group(
{
	group_name = "wool",
},
{
	"mcl_wool:white",
	"mcl_wool:black",
	"mcl_wool:blue",
	"mcl_wool:brown",
	"mcl_wool:cyan",
	"mcl_wool:green",
	"mcl_wool:grey",
	"mcl_wool:light_blue",
	"mcl_wool:lime",
	"mcl_wool:magenta",
	"mcl_wool:orange",
	"mcl_wool:pink",
	"mcl_wool:purple",
	"mcl_wool:red",
	"mcl_wool:silver",
	"mcl_wool:yellow",
})

builders_wand.register_group(
{
	group_name = "sand",
	sort_name = "terrain_blocks",
},
{
	"mcl_core:redsand",
	"mcl_core:redsandstone",
	"mcl_core:redsandstonecarved",
	"mcl_core:redsandstonesmooth",
	"mcl_core:redsandstonesmooth2",
	"mcl_core:sand",
	"mcl_core:sandstone",
	"mcl_core:sandstonecarved",
	"mcl_core:sandstonesmooth",
	"mcl_core:sandstonesmooth2",
	"mcl_stairs:slab_redsandstone",
	"mcl_stairs:slab_redsandstonesmooth",
	"mcl_stairs:slab_redsandstonesmooth2",
	"mcl_stairs:slab_sandstone",
	"mcl_stairs:slab_sandstonesmooth",
	"mcl_stairs:slab_sandstonesmooth2",
	"mcl_stairs:stair_redsandstone",
	"mcl_stairs:stair_redsandstonesmooth",
	"mcl_stairs:stair_redsandstonesmooth2",
	"mcl_stairs:stair_sandstone",
	"mcl_stairs:stair_sandstonesmooth",
	"mcl_stairs:stair_sandstonesmooth2",
	"mcl_sus_nodes:sand",
	"mcl_walls:redsandstone",
	"mcl_walls:sandstone",
})

builders_wand.register_group(
{
	group_name = "coral",
},
{
	"mcl_ocean:brain_coral",
	"mcl_ocean:brain_coral_block",
	"mcl_ocean:brain_coral_fan",
	"mcl_ocean:bubble_coral",
	"mcl_ocean:bubble_coral_block",
	"mcl_ocean:bubble_coral_fan",
	"mcl_ocean:dead_brain_coral",
	"mcl_ocean:dead_brain_coral_block",
	"mcl_ocean:dead_brain_coral_fan",
	"mcl_ocean:dead_bubble_coral",
	"mcl_ocean:dead_bubble_coral_block",
	"mcl_ocean:dead_bubble_coral_fan",
	"mcl_ocean:dead_fire_coral",
	"mcl_ocean:dead_fire_coral_block",
	"mcl_ocean:dead_fire_coral_fan",
	"mcl_ocean:dead_horn_coral",
	"mcl_ocean:dead_horn_coral_block",
	"mcl_ocean:dead_horn_coral_fan",
	"mcl_ocean:dead_tube_coral",
	"mcl_ocean:dead_tube_coral_block",
	"mcl_ocean:dead_tube_coral_fan",
	"mcl_ocean:fire_coral",
	"mcl_ocean:fire_coral_block",
	"mcl_ocean:fire_coral_fan",
	"mcl_ocean:horn_coral",
	"mcl_ocean:horn_coral_block",
	"mcl_ocean:horn_coral_fan",
	"mcl_ocean:tube_coral",
	"mcl_ocean:tube_coral_block",
	"mcl_ocean:tube_coral_fan",
})

builders_wand.register_group(
{
	group_name = "slabs",
	sort_name = "functional_blocks"
},
{
	"mcl_stairs:slab_concrete_silver",
	"mcl_stairs:slab_concrete_white",
	"mcl_stairs:slab_concrete_black",
	"mcl_stairs:slab_concrete_blue",
	"mcl_stairs:slab_concrete_brown",
	"mcl_stairs:slab_concrete_cyan",
	"mcl_stairs:slab_concrete_green",
	"mcl_stairs:slab_concrete_grey",
	"mcl_stairs:slab_concrete_light_blue",
	"mcl_stairs:slab_concrete_lime",
	"mcl_stairs:slab_concrete_magenta",
	"mcl_stairs:slab_concrete_orange",
	"mcl_stairs:slab_concrete_pink",
	"mcl_stairs:slab_concrete_purple",
	"mcl_stairs:slab_concrete_red",
	"mcl_stairs:slab_concrete_yellow",
	"mcl_stairs:slab_acacia",
	"mcl_stairs:slab_acacia_bark",
	"mcl_stairs:slab_andesite",
	"mcl_stairs:slab_andesite_smooth",
	"mcl_stairs:slab_bamboo",
	"mcl_stairs:slab_birch",
	"mcl_stairs:slab_birch_bark",
	"mcl_stairs:slab_blackstone",
	"mcl_stairs:slab_blackstone_brick_polished",
	"mcl_stairs:slab_blackstone_polished",
	"mcl_stairs:slab_brick_block",
	"mcl_stairs:slab_cherry_blossom",
	"mcl_stairs:slab_cherry_blossom_bark",
	"mcl_stairs:slab_cobble",
	"mcl_stairs:slab_copper_cut",
	"mcl_stairs:slab_copper_cut_preserved",
	"mcl_stairs:slab_copper_exposed_cut",
	"mcl_stairs:slab_copper_exposed_cut_preserved",
	"mcl_stairs:slab_copper_oxidized_cut",
	"mcl_stairs:slab_copper_oxidized_cut_preserved",
	"mcl_stairs:slab_copper_weathered_cut",
	"mcl_stairs:slab_copper_weathered_cut_preserved",
	"mcl_stairs:slab_crimson",
	"mcl_stairs:slab_crimson_bark",
	"mcl_stairs:slab_dark_oak",
	"mcl_stairs:slab_dark_oak_bark",
	"mcl_stairs:slab_deepslate_bricks",
	"mcl_stairs:slab_deepslate_bricks_cracked",
	"mcl_stairs:slab_deepslate_cobbled",
	"mcl_stairs:slab_deepslate_polished",
	"mcl_stairs:slab_deepslate_tiles",
	"mcl_stairs:slab_deepslate_tiles_cracked",
	"mcl_stairs:slab_diorite",
	"mcl_stairs:slab_diorite_smooth",
	"mcl_stairs:slab_end_bricks",
	"mcl_stairs:slab_end_stone",
	"mcl_stairs:slab_goldblock",
	"mcl_stairs:slab_granite",
	"mcl_stairs:slab_granite_smooth",
	"mcl_stairs:slab_hardened_clay",
	"mcl_stairs:slab_hardened_clay_black",
	"mcl_stairs:slab_hardened_clay_blue",
	"mcl_stairs:slab_hardened_clay_brown",
	"mcl_stairs:slab_hardened_clay_cyan",
	"mcl_stairs:slab_hardened_clay_green",
	"mcl_stairs:slab_hardened_clay_grey",
	"mcl_stairs:slab_hardened_clay_light_blue",
	"mcl_stairs:slab_hardened_clay_lime",
	"mcl_stairs:slab_hardened_clay_magenta",
	"mcl_stairs:slab_hardened_clay_orange",
	"mcl_stairs:slab_hardened_clay_pink",
	"mcl_stairs:slab_hardened_clay_purple",
	"mcl_stairs:slab_hardened_clay_red",
	"mcl_stairs:slab_hardened_clay_silver",
	"mcl_stairs:slab_hardened_clay_white",
	"mcl_stairs:slab_hardened_clay_yellow",
	"mcl_stairs:slab_ironblock",
	"mcl_stairs:slab_jungle",
	"mcl_stairs:slab_jungle_bark",
	"mcl_stairs:slab_lapisblock",
	"mcl_stairs:slab_mangrove",
	"mcl_stairs:slab_mangrove_bark",
	"mcl_stairs:slab_mossycobble",
	"mcl_stairs:slab_mud_brick",
	"mcl_stairs:slab_nether_brick",
	"mcl_stairs:slab_oak",
	"mcl_stairs:slab_oak_bark",
	"mcl_stairs:slab_prismarine",
	"mcl_stairs:slab_prismarine_brick",
	"mcl_stairs:slab_prismarine_dark",
	"mcl_stairs:slab_purpur_block",
	"mcl_stairs:slab_quartz_smooth",
	"mcl_stairs:slab_quartzblock",
	"mcl_stairs:slab_red_nether_brick",
	"mcl_stairs:slab_redsandstone",
	"mcl_stairs:slab_redsandstonesmooth",
	"mcl_stairs:slab_redsandstonesmooth2",
	"mcl_stairs:slab_sandstone",
	"mcl_stairs:slab_sandstonesmooth",
	"mcl_stairs:slab_sandstonesmooth2",
	"mcl_stairs:slab_spruce",
	"mcl_stairs:slab_spruce_bark",
	"mcl_stairs:slab_stone",
	"mcl_stairs:slab_stone_rough",
	"mcl_stairs:slab_stonebrick",
	"mcl_stairs:slab_stonebrickcracked",
	"mcl_stairs:slab_stonebrickmossy",
	"mcl_stairs:slab_tuff_bricks",
	"mcl_stairs:slab_tuff_polished",
	"mcl_stairs:slab_warped",
	"mcl_stairs:slab_warped_bark",
})

builders_wand.register_group(
{
	group_name = "stairs",
	sort_name = "functional_blocks"
},
{
	"mcl_stairs:stair_concrete_silver",
	"mcl_stairs:stair_concrete_white",
	"mcl_stairs:stair_concrete_black",
	"mcl_stairs:stair_concrete_blue",
	"mcl_stairs:stair_concrete_brown",
	"mcl_stairs:stair_concrete_cyan",
	"mcl_stairs:stair_concrete_green",
	"mcl_stairs:stair_concrete_grey",
	"mcl_stairs:stair_concrete_light_blue",
	"mcl_stairs:stair_concrete_lime",
	"mcl_stairs:stair_concrete_magenta",
	"mcl_stairs:stair_concrete_orange",
	"mcl_stairs:stair_concrete_pink",
	"mcl_stairs:stair_concrete_purple",
	"mcl_stairs:stair_concrete_red",
	"mcl_stairs:stair_concrete_yellow",
	"mcl_stairs:stair_acacia_bark",
	"mcl_stairs:stair_andesite",
	"mcl_stairs:stair_andesite_smooth",
	"mcl_stairs:stair_bamboo",
	"mcl_stairs:stair_birch",
	"mcl_stairs:stair_birch_bark",
	"mcl_stairs:stair_blackstone",
	"mcl_stairs:stair_blackstone_brick_polished",
	"mcl_stairs:stair_blackstone_polished",
	"mcl_stairs:stair_brick_block",
	"mcl_stairs:stair_cherry_blossom",
	"mcl_stairs:stair_cherry_blossom_bark",
	"mcl_stairs:stair_cobble",
	"mcl_stairs:stair_copper_cut",
	"mcl_stairs:stair_copper_cut_preserved",
	"mcl_stairs:stair_copper_exposed_cut",
	"mcl_stairs:stair_copper_exposed_cut_preserved",
	"mcl_stairs:stair_copper_oxidized_cut",
	"mcl_stairs:stair_copper_oxidized_cut_preserved",
	"mcl_stairs:stair_copper_weathered_cut",
	"mcl_stairs:stair_copper_weathered_cut_preserved",
	"mcl_stairs:stair_crimson",
	"mcl_stairs:stair_crimson_bark",
	"mcl_stairs:stair_dark_oak",
	"mcl_stairs:stair_dark_oak_bark",
	"mcl_stairs:stair_deepslate_bricks",
	"mcl_stairs:stair_deepslate_bricks_cracked",
	"mcl_stairs:stair_deepslate_cobbled",
	"mcl_stairs:stair_deepslate_polished",
	"mcl_stairs:stair_deepslate_tiles",
	"mcl_stairs:stair_deepslate_tiles_cracked",
	"mcl_stairs:stair_diorite",
	"mcl_stairs:stair_diorite_smooth",
	"mcl_stairs:stair_end_bricks",
	"mcl_stairs:stair_end_stone",
	"mcl_stairs:stair_goldblock",
	"mcl_stairs:stair_granite",
	"mcl_stairs:stair_granite_smooth",
	"mcl_stairs:stair_hardened_clay",
	"mcl_stairs:stair_hardened_clay_black",
	"mcl_stairs:stair_hardened_clay_blue",
	"mcl_stairs:stair_hardened_clay_brown",
	"mcl_stairs:stair_hardened_clay_cyan",
	"mcl_stairs:stair_hardened_clay_green",
	"mcl_stairs:stair_hardened_clay_grey",
	"mcl_stairs:stair_hardened_clay_light_blue",
	"mcl_stairs:stair_hardened_clay_lime",
	"mcl_stairs:stair_hardened_clay_magenta",
	"mcl_stairs:stair_hardened_clay_orange",
	"mcl_stairs:stair_hardened_clay_pink",
	"mcl_stairs:stair_hardened_clay_purple",
	"mcl_stairs:stair_hardened_clay_red",
	"mcl_stairs:stair_hardened_clay_silver",
	"mcl_stairs:stair_hardened_clay_white",
	"mcl_stairs:stair_hardened_clay_yellow",
	"mcl_stairs:stair_ironblock",
	"mcl_stairs:stair_jungle",
	"mcl_stairs:stair_jungle_bark",
	"mcl_stairs:stair_lapisblock",
	"mcl_stairs:stair_mangrove",
	"mcl_stairs:stair_mangrove_bark",
	"mcl_stairs:stair_mossycobble",
	"mcl_stairs:stair_mud_brick",
	"mcl_stairs:stair_nether_brick",
	"mcl_stairs:stair_oak",
	"mcl_stairs:stair_oak_bark",
	"mcl_stairs:stair_prismarine",
	"mcl_stairs:stair_prismarine_brick",
	"mcl_stairs:stair_prismarine_dark",
	"mcl_stairs:stair_purpur_block",
	"mcl_stairs:stair_quartz_smooth",
	"mcl_stairs:stair_quartzblock",
	"mcl_stairs:stair_red_nether_brick",
	"mcl_stairs:stair_redsandstone",
	"mcl_stairs:stair_redsandstonesmooth",
	"mcl_stairs:stair_redsandstonesmooth2",
	"mcl_stairs:stair_sandstone",
	"mcl_stairs:stair_sandstonesmooth",
	"mcl_stairs:stair_sandstonesmooth2",
	"mcl_stairs:stair_spruce",
	"mcl_stairs:stair_spruce_bark",
	"mcl_stairs:stair_stone",
	"mcl_stairs:stair_stone_rough",
	"mcl_stairs:stair_stonebrick",
	"mcl_stairs:stair_stonebrickcracked",
	"mcl_stairs:stair_stonebrickmossy",
	"mcl_stairs:stair_tuff_bricks",
	"mcl_stairs:stair_tuff_polished",
	"mcl_stairs:stair_warped",
	"mcl_stairs:stair_warped_bark",
})

builders_wand.register_group(
{
	group_name = "end blocks",
	sort_name = "terrain_blocks",
},
{
	"mcl_end:end_stone",
	"mcl_end:end_bricks",
	"mcl_end:purpur_block",
	"mcl_end:purpur_pillar",
	"mcl_stairs:slab_end_bricks",
	"mcl_stairs:slab_end_stone",
	"mcl_stairs:stair_end_bricks",
	"mcl_stairs:stair_end_stone",
	"mcl_end:dragon_egg",
	"mcl_walls:endbricks",
	"mcl_end:chorus_plant",
	"mcl_end:chorus_flower",
	"mcl_portals:end_portal_frame",
	"mcl_chests:ender_chest",
	"mcl_end:end_rod",
})

builders_wand.register_group(
{
	group_name = "natural blocks",
	sort_name = "terrain_blocks",
},
{
	"mcl_core:dirt_with_grass",
	"mcl_core:snowblock",
	"mcl_core:snow",
	"mcl_core:dirt",
	"mcl_core:bedrock",
	"mcl_core:clay",
	"mcl_core:diorite",
	"mcl_core:granite",
	"mcl_core:gravel",
	"mcl_core:redsand",
	"mcl_core:sand",
	"mcl_lush_caves:moss",
	"mcl_core:stone",
	"mcl_deepslate:deepslate",
	"mcl_deepslate:tuff",
	"mcl_end:end_stone",
	"mcl_nether:netherrack",
	"mcl_nether:soul_sand",
})

builders_wand.register_group(
{
	group_name = "amethyst",
	sort_name = "terrain_blocks",
},
{
	"mcl_amethyst:amethyst_block",
	"mcl_amethyst:amethyst_cluster",
	"mcl_amethyst:budding_amethyst_block",
	"mcl_amethyst:calcite",
	"mcl_amethyst:large_amethyst_bud",
	"mcl_amethyst:medium_amethyst_bud",
	"mcl_amethyst:small_amethyst_bud",
	"mcl_amethyst:tinted_glass",
})
---}}}
