core.register_entity("builders_wand:edge_marker",
{
	initial_properties = {
		virual = "sprite",
		visual_size = {x = 0.5, y = 0.5, z = 0.5},
		collisionbox = { -0.125, -0.125, -0.125, 0.125, 0.125, 0.125},
		textures = {"border-shit.png"},
		use_texture_alpha = true,
		static_save = false,
		glow = 0.2
	},
	on_deactivate = function(self, removal)
		if self.group and not self.group.busy then
			self.group.busy = true
			for _, v in ipairs(self.group) do
				if v:get_luaentity() ~= self then
					v:remove()
				end
			end
		end
	end,
	_group = nil
})

core.register_entity("builders_wand:little_marker",
{
	initial_properties = {
		virual = "sprite",
		visual_size = {x = 0.5, y = 0.5, z = 0.5},
		collisionbox = { -0.125, -0.125, -0.125, 0.125, 0.125, 0.125},
		textures = {"little-shit.png"},
		use_texture_alpha = true,
		static_save = false,
		glow = 0.2
	},
	on_deactivate = function(self, removal)
		if self.group and not self.group.busy then
			self.group.busy = true
			for _, v in ipairs(self.group) do
				if v:get_luaentity() ~= self then
					v:remove()
				end
			end
		end
	end,
	_group = nil
})

core.register_entity("builders_wand:special_marker",
{
	initial_properties = {
		virual = "sprite",
		visual_size = {x = 0.5, y = 0.5, z = 0.5},
		collisionbox = { -0.125, -0.125, -0.125, 0.125, 0.125, 0.125},
		textures = {"special-shit.png"},
		use_texture_alpha = true,
		static_save = false,
		glow = 0.2
	},
	on_deactivate = function(self, removal)
		if self.group and not self.group.busy then
			self.group.busy = true
			for _, v in ipairs(self.group) do
				if v:get_luaentity() ~= self then
					v:remove()
				end
			end
		end
	end,
	_group = nil
})

local function map_type_to_entity(type)
	if type == "edge" then
		return "builders_wand:edge_marker"
	elseif type == "special" then
		return "builders_wand:special_marker"
	elseif type == "small" then
		return "builders_wand:little_marker"
	end
end

function builders_wand.create_marker(pos, type, group)
	local obj = core.add_entity(pos, map_type_to_entity(type))
	local luaentity = obj:get_luaentity()
	luaentity.group = group
	-- so stupid
	table.insert(group, obj)
end

function builders_wand.delete_marker_group(group)
	group.busy = true
	while #group ~= 0 do
		group[#group]:remove()
		group[#group] = nil
	end
	group.busy = nil
end
