This is a small write up about integrating your mod/game with `builder_wand`

Generally, you can look at `defs/mcl_defs.lua` to see an example of integrating `builder_wand` into your game

Integrations with games should reside in this repository, while integrations with external mods should be defined in those mods.
Unless i decide otherwise on a case by case basis :p

# Easily define groups

When defining your own groups it is highly advised you use the `group manager` tool to do so, here is the work flow:

1. Use the `group manager` to create a new group
2. Clear you inventory
3. Open creative inventory and pick all the nodes you want
4. Open `group manager` and click `Add nodes from inventory`
5. If all the nodes didn't fit in a single inventory, simply repeat from step `2`

Define as much group as you want this way, after you're done write this in chat

```
/dump_builder_info <player name, "singleplayer" in singleplayer mode>
```

Now copy the result. You can copy it from the terminal, or from the bottom of `$MINETEST_HOME/debug.txt` file

# Defining groups

For defining global groups use the `builder_wand.register_group(def, group)` method. Here's an example:

```lua
builders_wand.register_group(
{
	group_name = "oak",
	sort_name = "wood_type"
},
{
	"mcl_trees:tree_oak",
	"mcl_trees:wood_oak",
	"mcl_fences:oak_fence_gate",
	"mcl_buttons:button_oak_off",
	"mcl_doors:trapdoor_oak",
	"mcl_fences:oak_fence",
	"mcl_pressureplates:pressure_plate_oak_off",
	"mcl_signs:wall_sign_oak",
	"mcl_stairs:slab_oak",
	"mcl_stairs:slab_oak_bark",
	"mcl_stairs:stair_oak",
	"mcl_stairs:stair_oak_bark",
	"mcl_trees:bark_oak",
	"mcl_trees:bark_stripped_oak",
	"mcl_trees:leaves_oak",
	"mcl_trees:sapling_oak",
	"mcl_trees:stripped_oak",
})
```

`group_name` is the name of the group. While `sort_name` is a virtual name of the group used for sorting. Its used so related
groups are near each other in group selection menu. Its completely optional

The current convention for minecolonia has these `sort_name`s defined:

- `functional_blocks`
- `wood_type`
- `terrain_blocks`
- `copper_variants`
- `ores`
- `color`
- `plants`

Try following this convention when relevant, but don't be scared to add your own (in which case, you can inform me and i'll add
it to the list)

# Adding nodes to existing groups


use `builders_wand.add_node_to_group(group_name, node_name)`

Example:

```lua
local success = builders_wand.add_node_to_group("oak", "mcl_trees:stripped_oak")

if success then
    core.log("Succesfully added a node to a group")
else
    core.log("Failed to add the node to the group")
end
```

The group needs to be defined beforehand

# Defining player inventory lists

Builder wand has a button to add all nodes from the inventory to the selected group. For this to work, it needs to know what
inventory lists are relevant. For example, in minecolonia the player's enderchest and wield armor are part of the players
inventory

To make this work, simply override the given function

```lua
builders_wand.is_player_inventory_list_relevant = function(listname)
	return listname == "main"
end
```
