local gui_helpers = builders_wand.gui

core.register_tool("builders_wand:recent_items_wand",
{
	description = "recent items wand",
	inventory_image = "palette.png",
	range = 10,
	on_use = function(itemstack, player, pointed_thing)
		gui_helpers.create_recent_items_selection_gui(player):show(player)
	end
})

-- I FUNCKING HAPEIT THIShq
local function workaround_condition(ndef)
	return ndef.walkable
	and not ndef.buildable_to
	and ndef.drawtype == "normal"
	and ndef.paramtype == "none"
	and ndef.paramtype2 == "none"
end

local placeholder_node

core.register_on_mods_loaded(function()
	for name, ndef in pairs(core.registered_nodes) do
		if workaround_condition(ndef) then
			placeholder_node = name
			break
		end
	end
end)

core.register_tool("builders_wand:extruder",
{
	description = "Extruder",
	inventory_image = "trowel.png",
	range = 10,
	on_place = function(itemstack, player, pointed_thing)
		if pointed_thing.type ~= "node" then return end
		local controls = player:get_player_control()

		if controls.sneak then
			gui_helpers.create_extruder_gui(player):show(player)
		else
			local data = builders_wand.get_data_from_player(player)
			builders_wand.extrude(
				pointed_thing.under,
				vector.subtract(pointed_thing.above, pointed_thing.under),
				data.extruder_propagation_mode,
				data.extruder_mode
			)
		end
	end,
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing.type ~= "node" then return end
		local data = builders_wand.get_data_from_player(player)
		builders_wand.indent(
			pointed_thing.under,
			vector.subtract(pointed_thing.above, pointed_thing.under),
			data.extruder_propagation_mode,
			data.extruder_mode
		)
	end
})

core.register_tool("builders_wand:bucket_fill",
{
	description = "Bucket fill",
	inventory_image = "bucket_fill.png",
	range = 10,
	on_place = function(itemstack, player, pointed_thing)
		if pointed_thing.type ~= "node" then return end
		local builder_data = builders_wand.get_data_from_player(player)
		builders_wand.paint_face(pointed_thing.under, vector.subtract(pointed_thing.above, pointed_thing.under), {name = builder_data.selected_item})
	end,
})

core.register_tool("builders_wand:wall_scraper",
{
	description = "Wall scraper",
	inventory_image = "scraper.png",
	range = 10,
	on_place = function(itemstack, player, pointed_thing)
		if pointed_thing.type ~= "node" then return end
		local builder_data = builders_wand.get_data_from_player(player)
		builders_wand.scrape_face(pointed_thing.under, vector.subtract(pointed_thing.above, pointed_thing.under))
	end,
})

core.register_tool("builders_wand:wand",
{
	description = "builders wand",
	inventory_image = "hammer.png",
	range = 10,
	on_place = function(itemstack, player, pointed_thing)
		local builder_data = builders_wand.get_data_from_player(player)
		local controls = player:get_player_control()
		local nodedef = core.registered_nodes[builder_data.selected_item]
		local replace_workaround_node

		if builder_data.replace_mode then
			local dir = pointed_thing.under - pointed_thing.above
			pointed_thing.under = pointed_thing.under + dir
			pointed_thing.above = pointed_thing.above + dir
			core.remove_node(pointed_thing.above)
			local behind_node = core.get_node(pointed_thing.under)
			local behind_node_def = core.registered_nodes[behind_node.name]
			if not workaround_condition(behind_node_def) then
				replace_workaround_node = behind_node
				core.set_node(pointed_thing.under, {name = placeholder_node})
			end
		end

		if controls.sneak then
			if builder_data.selected_group then
				builders_wand.create_item_selection_gui(player):show(player)
			else
				gui_helpers.create_group_selection_gui(player):show(player)
			end
		else
			if builder_data.selected_item then
				nodedef.on_place(ItemStack(builder_data.selected_item), player, pointed_thing)

				if nodedef.sounds and nodedef.sounds.place then
					core.sound_play(nodedef.sounds.place, {pos = pointed_thing.above}, true)
				end

				if replace_workaround_node then
					core.set_node(pointed_thing.under, replace_workaround_node)
				end
			end
		end
	end,
	on_use = function(itemstack, player, pointed_thing)
		local controls = player:get_player_control()
		local builder_data = builders_wand.get_data_from_player(player)
		local nodedef = core.registered_nodes[builder_data.selected_item]

		if pointed_thing.type ~= "node" then
			return
		end

		if controls.sneak then
			builders_wand.select_item(builder_data, core.get_node(pointed_thing.under).name)
		else
			core.swap_node(pointed_thing.under, {name = "air"})
			if nodedef and nodedef.sounds then
				core.sound_play(nodedef.sounds.dug, {pos = pointed_thing.under}, true)
			end
		end
	end
})

core.register_tool("builders_wand:group_manager",
{
	description = "Group manager",
	inventory_image = "device.png",
	range = 10,
	on_secondary_use = function(itemstack, player, pointed_thing)
		gui_helpers.create_group_manager_gui(player):show(player)
	end,
	on_place = function(itemstack, player, pointed_thing)
		gui_helpers.create_group_manager_gui(player):show(player)
	end,
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing.type ~= "node" then return end

		local data = builders_wand.get_data_from_player(player)

		if builders_wand.get_group_type(data.selected_group, player) ~= "custom" then
			core.chat_send_player(player:get_player_name(), "Only user defined groups can be edited")
			return
		end
		builders_wand.add_item_to_custom_group(data.selected_group, player, core.get_node(pointed_thing.under).name)
	end
})

local player_measures = {}

core.register_tool("builders_wand:ruler",
{
	description = "Ruler",
	inventory_image = "ruler.png",
	range = 10,
	on_place = function(itemstack, player, pointed_thing)
		local name = player:get_player_name()
		if not player_measures[name] then
			player_measures[name] = {markers = {}}
		end

		local data = player_measures[name]
		local markers = data.markers
		builders_wand.create_marker(pointed_thing.above, "edge", markers)

		if data.pos_2 then
			data.pos_1 = pointed_thing.above
			data.pos_2 = nil
		elseif data.pos_1 then
			if vector.equals(pointed_thing.above, data.pos_1) then
				return
			end

			builders_wand.delete_marker_group(markers)
			data.pos_2 = pointed_thing.above

			local marker_tmp = {}

			local x_iterator = data.pos_1.x
			local x_end = data.pos_2.x
			local y_iterator = data.pos_1.y
			local y_end = data.pos_2.y
			local z_iterator = data.pos_1.z
			local z_end = data.pos_2.z

			local magnitude = vector.distance(data.pos_1, data.pos_2)

			local x_step = (x_end - x_iterator) / magnitude
			local y_step = (y_end - y_iterator) / magnitude
			local z_step = (z_end - z_iterator) / magnitude
			local place_head = vector.copy(data.pos_1)

			local x_acc = 0
			local y_acc = 0
			local z_acc = 0

			local threshold = 1
			local changed = true
			while not vector.equals(place_head, data.pos_2) do
				if changed then
					table.insert(marker_tmp, vector.copy(place_head))
				end
				changed = false
				x_acc = x_acc + x_step

				if math.abs(x_acc) >= threshold then
					place_head.x = place_head.x + (1 * math.sign(x_step))
					x_acc = x_acc - (threshold * math.sign(x_step))
					changed = true
				end

				y_acc = y_acc + y_step

				if math.abs(y_acc) >= threshold then
					place_head.y = place_head.y + (1 * math.sign(y_step))
					y_acc = y_acc - (threshold * math.sign(y_step))
					changed = true
				end

				z_acc = z_acc + z_step

				if math.abs(z_acc) >= threshold then
					place_head.z = place_head.z + (1 * math.sign(z_step))
					z_acc = z_acc - (threshold * math.sign(z_step))
					changed = true
				end
			end

			-- We end when the place_head is equal to the end position, but we haven't added the last position.
			-- So we're doing it now
			table.insert(marker_tmp, vector.copy(place_head))

			core.chat_send_player(name, "x: " .. core.colorize("#00FF00", tostring(math.abs(data.pos_1.x - data.pos_2.x) + 1)))
			core.chat_send_player(name, "y: " .. core.colorize("#00FF00", tostring(math.abs(data.pos_1.y - data.pos_2.y) + 1)))
			core.chat_send_player(name, "z: " .. core.colorize("#00FF00", tostring(math.abs(data.pos_1.z - data.pos_2.z) + 1)))
			builders_wand.create_marker(table.remove(marker_tmp, #marker_tmp), "edge", markers)
			builders_wand.create_marker(table.remove(marker_tmp, 1), "edge", markers)

			local mid_point = math.floor(#marker_tmp / 2)
			if #marker_tmp ~= 0 then
				if #marker_tmp % 2 == 0 then
					core.chat_send_player(name, string.format("midpoints: %s and %s",
						core.colorize("#00FF00", tostring(marker_tmp[mid_point])),
						core.colorize("#00FF00", tostring(marker_tmp[mid_point + 1]))))
					builders_wand.create_marker(table.remove(marker_tmp, mid_point), "special", markers)
					builders_wand.create_marker(table.remove(marker_tmp, mid_point), "special", markers)
				else
					core.chat_send_player(name, string.format("midpoint: %s", core.colorize("#00FF00", tostring(marker_tmp[mid_point + 1]))))
					builders_wand.create_marker(table.remove(marker_tmp, mid_point + 1), "special", markers)
				end
			end

			for _, v in pairs(marker_tmp) do
				builders_wand.create_marker(v, "small", markers)
			end

		else
			data.pos_1 = pointed_thing.above
		end
	end,
})

core.register_tool("builders_wand:teleporter",
{
	description = "Teleport tool",
	inventory_image = "teleport-tool.png",
	range = 1000,
	on_use = function(itemstack, player, pointed_thing)
		if pointed_thing.type == "nothing" then
			player:set_pos(player:get_pos() + player:get_look_dir() * 50)
		elseif pointed_thing.type == "node" then
			player:set_pos(vector.round(pointed_thing.above))
		elseif pointed_thing.type == "object" then
			player:set_pos(vector.round(pointed_thing.ref:get_pos()))
		end
		return nil
	end
})
