local function are_adjacent(pos_1, pos_2)
	if math.abs(pos_1.x - pos_2.x) == 1 and pos_1.y == pos_2.y and pos_1.z == pos_2.z then
		return true, "x"
	elseif pos_1.x == pos_2.x and math.abs(pos_1.y - pos_2.y) == 1 and pos_1.z == pos_2.z then
		return true, "y"
	elseif pos_1.x == pos_2.x and pos_1.y == pos_2.y and math.abs(pos_1.z - pos_2.z) == 1 then
		return true, "z"
	else
		return false, ""
	end
end

local fast_placer_range = 10
local fast_placer_axis_switch_threshold = 0.1
core.register_globalstep(function(dtime)
	for _, player in pairs(core.get_connected_players()) do
		local wielded_item = player:get_wielded_item()

		if wielded_item:get_name() == "builders_wand:fast_placer" then
			local pd = builders_wand.get_data_from_player(player)

			pd.fast_placer_time = pd.fast_placer_time or 0.1
			pd.fast_placer_time_accumulator = pd.fast_placer_time_accumulator or 0
			pd.fast_placer_axis_switch_accumulator = pd.fast_placer_axis_switch_accumulator or 0
			pd.fast_placer_align_data = pd.fast_placer_align_data or {axis = "", previous_place = vector.new(0, 0, 0)}

			pd.fast_placer_time_accumulator = pd.fast_placer_time_accumulator + dtime
			if pd.fast_placer_time_accumulator >= pd.fast_placer_time then
				pd.fast_placer_time_accumulator = pd.fast_placer_time_accumulator - pd.fast_placer_time

				local controls = player:get_player_control()
				local player_look = player:get_look_dir()
				local player_pos = player:get_pos():offset(0, 1.5, 0)
				local ray = core.raycast(player_pos, player_pos + vector.multiply(player_look, fast_placer_range), false, false)
				local pointed_thing

				for v in ray do
					if v then
						pointed_thing = v
						break
					end
				end

				if pointed_thing and (controls.LMB or controls.RMB) then
					local adjecent, axis = are_adjacent(pointed_thing.above, pd.fast_placer_align_data.previous_place)
					if not pd.fast_placer_alignment_enabled or not adjecent or pd.fast_placer_align_data.axis == axis then
						pd.fast_placer_align_data.previous_place = pointed_thing.above
						pd.fast_placer_axis_switch_accumulator = 0
						if controls.LMB then
							core.remove_node(pointed_thing.under)
						elseif controls.RMB then
							if pd.replace_mode then
								core.set_node(pointed_thing.under, {name = pd.selected_item})
							else
								core.set_node(pointed_thing.above, {name = pd.selected_item})
							end
						end
					else
						pd.fast_placer_axis_switch_accumulator = pd.fast_placer_axis_switch_accumulator + dtime

						if pd.fast_placer_axis_switch_accumulator >= fast_placer_axis_switch_threshold then
							pd.fast_placer_axis_switch_accumulator = 0
							pd.fast_placer_align_data.axis = axis
							-- beautiful branching
						end
					end
				end
			end
		end
	end
end)

local function on_rightclick(_, player)
	local controls = player:get_player_control()

	if controls.sneak then
		builders_wand.gui.create_fast_placer_gui(player):show(player)
	end
end

core.register_tool("builders_wand:fast_placer",
{
	description = "Fast placer",
	inventory_image = "super-hammer.png",
	range = 10,
	on_dig = function() return false end,
	on_place = on_rightclick,
	on_secondary_use = on_rightclick
})
