core.register_node("hl:reinforced_brick",
{
	description = "Reinforced bricks",
	drawtype = "normal",
	groups = {solid = 1, pickaxey = 5},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	stack_max = 64,
	_mcl_hardness = 8,
	_mcl_blast_resistance = 18,
	tiles = {"reinforced_bricks.png"}
})

core.register_node("hl:reinforced_obsidian",
{
	description = "Reinforced obsidian",
	drawtype = "normal",
	groups = {solid = 1, pickaxey = 5},
	sounds = mcl_sounds.node_sound_stone_defaults(),
	stack_max = 64,
	_mcl_hardness = 100,
	_mcl_blast_resistance = 2400,
	tiles = {"reinforced_obsidian.png"}
})

core.register_node("hl:barbed_wire",
{
	description = "Barbed wire",
	drawtype = "mesh",
	mesh = "barbed_wire.glb",
	use_texture_alpha = "clip",
	tiles = {"barbed_wire.png"},
	paramtype = "light",
	paramtype2 = "4dir",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {shearsy_cobweb = 1, disable_jump = 1},
	damage_per_second = 2,
	move_resistance = 14,
	stack_max = 64,
	walkable = false,
	_mcl_hardness = 6,
	_mcl_shears_drop = true,
	_pathfinding_class = "DANGER_OTHER",
})

hl.define_recipe("barbed wire", {
	output = "hl:barbed_wire",
	recipe = {
		{"hl:barbed_wire_thread", "hl:barbed_wire_thread", "hl:barbed_wire_thread"},
		{"mcl_core:stick",                 "",                               "mcl_core:stick"}
	}
})

core.register_node("hl:flaming_barbed_wire",
{
	description = "Flaming barbed wire",
	drawtype = "mesh",
	mesh = "barbed_wire.glb",
	use_texture_alpha = "clip",
	tiles = {"flaming_barbed_wire.png"},
	paramtype = "light",
	paramtype2 = "4dir",
	sunlight_propagates = true,
	is_ground_content = false,
	groups = {shearsy_cobweb = 1, disable_jump = 1},
	damage_per_second = 2,
	move_resistance = 14,
	stack_max = 64,
	walkable = false,
	_mcl_hardness = 6,
	_mcl_shears_drop = true,
	_mcl_on_entity_inside = function(pos, node, obj)
		mcl_burning.set_on_fire(obj, 10)
	end,
	_pathfinding_class = "DANGER_OTHER",
})

mcl_mobs.mob_class.slowdown_nodes["hl:barbed_wire"] = {x = 0.2, y = 0.2, z = 0.2}
mcl_mobs.mob_class.slowdown_nodes["hl:flaming_barbed_wire"] = {x = 0.2, y = 0.2, z = 0.2}

hl.define_recipe("flaming barbed wire", {
	output = "hl:flaming_barbed_wire",
	recipe = {
		{"mcl_mobitems:blaze_powder", "mcl_mobitems:blaze_powder", "mcl_mobitems:blaze_powder"},
		{"hl:barbed_wire_thread", "hl:barbed_wire_thread", "hl:barbed_wire_thread"},
		{"mcl_core:stick",                 "",                               "mcl_core:stick"}
	}
})
