local flashbang_radius_multiplier = 25
local flashbang_time_multiplier = 10
local player_flashbangs = {}

function hl.flashbang_effect(pos, strength)
	for obj in core.objects_inside_radius(pos, strength * flashbang_radius_multiplier) do
		if core.is_player(obj) then
			local player_pos = vector.offset(obj:get_pos(), 0, 1.5, 0)
			local pos_diff = pos - player_pos
			local player_look = obj:get_look_dir()
			local similarity = vector.distance(player_look, vector.normalize(pos_diff))

			if similarity < 0.2 then
				-- add HUD that covers the screen

				local ray = core.raycast(pos, player_pos, true, false)
				local obstructed = false

				for pointed_thing in ray do
					if pointed_thing and not (pointed_thing.type == "object" and pointed_thing.ref == obj) then
						obstructed = true
						break
					end
				end

				if not obstructed then
					if player_flashbangs[obj] then
						obj:hud_remove(player_flashbangs[obj].hud_id)
						player_flashbangs[obj] = nil
					end

					local sound_handler = core.sound_play(
						{
							name = "flashbang"
						},
						{
							to_player = obj:get_player_name(),
							object = obj,
							loop = true
						}
					)

					core.sound_fade(sound_handler, 1 / (strength * flashbang_time_multiplier), 0)

					local hud_id = obj:hud_add({
						type = "image",
						name = "flashbang flash",
						text = "flashbang_overlay.png",
						scale = {x = 10000, y = 10000}, -- that ought to be enough
						position = {x = 0, y = 0},
						alignment = {x = 1, y = 1},
						z_index = 99999
					})
					player_flashbangs[obj] = {
						time = strength * flashbang_time_multiplier,
						full_time = strength * flashbang_time_multiplier,
						hud_id = hud_id
					}
				end
			end
		end
	end
end

core.register_globalstep(function(dtime)
	for player, data in pairs(player_flashbangs) do
		local new_time = data.time - dtime

		if new_time < 0 then
			player:hud_remove(data.hud_id)
			player_flashbangs[player] = nil
		else
			player:hud_change(
				data.hud_id,
				"text",
				string.format(
					"flashbang_overlay.png^[opacity:%s",
					-- MATHHHHHHHHH
					-- y = (peak / t^2) * (t - x)^2 + peak
					-- where:
					-- peak - 255 in our case
					-- t = full time of the fuse
					-- x = fuse remaining
					math.floor(- (255/math.pow(data.full_time, 2)) * math.pow(data.full_time - data.time, 2) + 255)
				)
			)
			data.time = new_time
		end
	end
end)
