local landmine_power = 4

local function landmine_on_construct(pos)
	local under_pos = vector.offset(pos, 0, -1, 0)
	local under_node = core.get_node(under_pos)

	if core.get_item_group(under_node.name, "shovely") > 0 then
		core.swap_node(pos, {name = "hl:hidden_landmine"})
	end
end

core.register_node("hl:landmine", {
	description = "Landmine",
	drawtype = "mesh",
	mesh = "landmine.glb",
	use_texture_alpha = "opaque",
	tiles = {"landmine.png"},
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	stack_max = 16,
	walkable = false,
	_mcl_hardness = 6,
	selection_box = {
		type = "fixed",
		fixed = {
			-10/32, -1/2, -10/32,
			10/32, -8/32, 10/32,
		}
	},
	drop = "hl:landmine",

	on_blast = function(pos, _)
		core.remove_node(pos)
		mcl_explosions.explode(pos, landmine_power)
	end,

	_mcl_on_object_inside = function(pos, node, obj)
		core.remove_node(pos)
		mcl_explosions.explode(pos, landmine_power)
	end,

	on_construct = landmine_on_construct,
})

core.register_node("hl:hidden_landmine", {
	description = "Hidden landmine",
	drawtype = "nodebox",
	use_texture_alpha = "blend",
	tiles = {"hidden_landmine.png"},
	paramtype = "light",
	sunlight_propagates = true,
	is_ground_content = false,
	stack_max = 16,
	groups = {not_in_creative_inventory = 1},
	walkable = false,
	_mcl_hardness = 6,
	node_box = {
		type = "fixed",
		fixed = {
			-2/32, -1/2, -2/32,
			2/32, -14/32, 2/32,
		}
	},
	drop = "hl:landmine",

	on_blast = function(pos, _)
		core.remove_node(pos)
		mcl_explosions.explode(pos, landmine_power)
	end,

	_mcl_on_object_inside = function(pos, node, obj)
		core.remove_node(pos)
		mcl_explosions.explode(pos, landmine_power)
	end,

	on_construct = landmine_on_construct,
})

hl.define_recipe("landmine",
{
	output = "hl:landmine",
	recipe = {
		{"mcl_pressureplates:pressure_plate_heavy_off"},
		{"mcl_tnt:tnt"},
	}
})
