-- {{{ Craft items

core.register_node("hl:basic_fuse_casing", {
	description = "Basic fuse casing",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"basic_fuse_casing.png"}
})

core.register_node("hl:advanced_fuse_casing", {
	description = "Advanced fuse casing",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"advanced_fuse_casing.png"}
})

-- }}}

-- {{{ Primitive penetration fuse

core.register_node("hl:primitive_penetration_fuse",
{
	description = "Primitive penetration fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"primitive_penetration_fuse.png"}
})

hl.register_load_component("hl:primitive_penetration_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fpp",
	compressed_size = 0.5,

	on_activate = function(self, pos, load)
		self.state = "inactive"
	end,
	on_step = function(self, pos, load, current_node)
		if self.state == "primed" and current_node.name == "air" then
			return "explode"
		elseif self.state == "inactive" and current_node.name ~= "air" then
			self.state = "primed"
		end
	end
})

-- }}}

-- {{{ Sophisticated penetration fuse

core.register_node("hl:sophisticated_penetration_fuse",
{
	description = "Sophisticated penetration fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"sophisticated_penetration_fuse.png"}
})

hl.register_load_component("hl:sophisticated_penetration_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fsp",
	compressed_size = 0.5,

	on_activate = function(self, pos, load)
		self.state = "inactive"
	end,
	on_step = function(self, pos, load, current_node)
		if self.state == "primed" and current_node.name == "air" then
			self.state = "last_phase"
		elseif current_node.name ~= "air" then
			if self.state == "inactive" then
				self.state = "primed"
			elseif self.state == "last_phase" then
				return "explode"
			end
		end
	end
})

-- }}}

-- {{{ Frontal proximity fuse

core.register_node("hl:frontal_proximity_fuse",
{
	description = "Frontal proximity fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", "frontal_proximity_fuse.png", }
})

hl.register_load_component("hl:frontal_proximity_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Ffp",
	compressed_size = 0.5,

	on_step = function(self, pos, load, current_node)
		local dir = vector.normalize(load.velocity)
		local ray = core.raycast(pos, pos + (dir * 5), false, true)

		for pointed_thing in ray do
			if core.get_item_group(core.get_node(pointed_thing.under).name, "solid") > 0 then
				return "explode"
			end
		end

	end
})


-- }}}

-- {{{ Gyroscoped proximity fuse

core.register_node("hl:gyro_proximity_fuse",
{
	description = "Gyroscoped proximity fuse",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"gyro_proximity_fuse.png"}
})

hl.register_load_component("hl:gyro_proximity_fuse", {
	hardness = 0,
	weight = 1,
	codename = "Fgp",
	compressed_size = 0.5,

	on_activate = function(self)
		self.state = "inactive"
		self.counter = 0
	end,
	on_step = function(self, pos, load, current_node)
		local ray = core.raycast(pos, vector.offset(pos, 0, -5, 0), false, true)

		local found_anything = true
		for pointed_thing in ray do
			if core.get_item_group(core.get_node(pointed_thing.under).name, "solid") > 0 then
				if self.state == "primed" and self.counter > 8 then
					return "explode"
				end
				found_anything = false
			end
		end

		if found_anything then
			self.state = "primed"
		end

		self.counter = self.counter + 1
	end
})

-- }}}
