hl.registered_explosion_modifiers = {}

function hl.register_explosion_modifier(name, def)
	hl.registered_explosion_modifiers[name] = def
end

-- {{{ empty capsule

core.register_node("hl:empty_capsule",
{
	description = "Empty capsule",
	drawtype = "allfaces",
	groups = {solid = 1},
	stack_max = 64,
	use_texture_alpha = "clip",
	tiles = {"empty_capsule.png"}
})

hl.define_recipe("empty capsule", {
	output = "hl:empty_capsule",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:glass", "mcl_core:iron_ingot"},
		{"mcl_core:glass",      "",               "mcl_core:glass"},
		{"mcl_core:iron_ingot", "mcl_core:glass", "mcl_core:iron_ingot"},
	}
})

-- }}}

-- {{{ Shrapnel

hl.register_explosion_modifier("shrapnel", {
	explosion_reduction_multiplier = 1,
	process = function(pos, power, total)
		hl.shrapnel_effect(pos, power, total)
	end
})

core.register_node("hl:shrapnel",
{
	description = "Shrapnel",
	short_description = "Shrapnel",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"shrapnel.png", "shrapnel.png", "shrapnel.png", "shrapnel.png", "shrapnel.png", "shrapnel.png", }
})

hl.register_load_component("hl:shrapnel", {
	hardness = 0,
	codename = "S",
	weight = 4,
	explosion_modifiers = {
		{
			name = "shrapnel",
			amount = 12500 -- calculated to deal 10 damage at 10 blocks
		}
	},
})

core.register_craftitem("hl:handful_of_shrapnel",
{
	description = "Handful of shrapnel",
	stack_max = 64,
	inventory_image = "handful_of_shrapnel.png"
})

hl.define_recipe("handful_of_shrapnel", {
	output = "hl:handful_of_shrapnel",
	type = "shapeless",
	recipe = {
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
		"mcl_core:iron_nugget",
	}
})

hl.define_recipe("shrapnel", {
	output = "hl:shrapnel",
	type = "shapeless",
	recipe = {
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
	}
})

-- }}}

-- {{{ Smoke screen

hl.register_explosion_modifier("smokescreen", {
	explosion_reduction_multiplier = 0.001,
	process = function(pos, power, total)
		hl.spawn_smoke(power, total, pos)
	end
})

core.register_node("hl:smokescreen_capsule",
{
	description = "Smokescreen capsule",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"smokescreen_capsule.png"}
})

hl.register_load_component("hl:smokescreen_capsule", {
	hardness = 0,
	weight = 2,
	codename = "Sc",
	explosion_modifiers = {
		{
			name = "smokescreen",
			amount = 500
		}
	},
})

hl.define_recipe("smokescreen capsule", {
	output = "hl:smokescreen_capsule",
	type = "shapeless",
	recipe = {
		"hl:smokescreen_bottle", "hl:empty_capsule",
	}
})

-- }}}

-- {{{ Mustard gas
hl.register_explosion_modifier("mustard gas", {
	explosion_reduction_multiplier = 0.001,
	process = function(pos, power, total)
		hl.spawn_mustard_gas(power, total, pos)
	end
})

core.register_node("hl:mustard_gas_capsule",
{
	description = "mustard gas capsule",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"mustard_capsule.png"}
})

hl.register_load_component("hl:mustard_gas_capsule", {
	hardness = 0,
	weight = 2,
	codename = "Mc",
	explosion_modifiers = {
		{
			name = "mustard gas",
			amount = 500,
		}
	},
	break_on_explode = true
})

hl.define_recipe("mustard gas capsule", {
	output = "hl:mustard_gas_capsule",
	type = "shapeless",
	recipe = {
		"hl:mustard_bottle", "hl:empty_capsule",
	}
})

-- }}}

-- {{{ Napalm
hl.register_explosion_modifier("napalm", {
	explosion_reduction_multiplier = 0.05,
	process = function(pos, power, total)
		hl.spawn_infernal_flame_explosion(pos, power * 2, total)
	end
})

core.register_node("hl:napalm_capsule",
{
	description = "napalm capsule",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"napalm_capsule.png"}
})

hl.register_load_component("hl:napalm_capsule", {
	hardness = 0,
	weight = 2,
	codename = "Nc",
	explosion_modifiers = {
		{
			name = "napalm",
			amount = 75
		}
	},
	break_on_explode = true
})

hl.define_recipe("napalm gas capsule", {
	output = "hl:napalm_capsule",
	type = "shapeless",
	recipe = {
		"hl:napalm_bottle", "hl:empty_capsule",
	}
})

-- }}}

-- {{{ Flashbang

hl.register_explosion_modifier("flashbang", {
	explosion_reduction_multiplier = 1.5,
	process = function(pos, power, total)
		hl.flashbang_effect(pos, total)
	end
})

core.register_node("hl:flashbang",
{
	description = "flash bang",
	drawtype = "normal",
	groups = {solid = 1},
	stack_max = 64,
	tiles = {"flashbang_capsule.png"}
})

hl.register_load_component("hl:flashbang", {
	hardness = 0,
	weight = 1,
	codename = "Fb",
	explosion_modifiers =
	{
		{
			name = "flashbang",
			amount = 1
		}
	},
	break_on_explode = true
})

hl.define_recipe("flashbang capsule", {
	output = "hl:flashbang",
	recipe = {
		{"mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust"},
		{"mcl_nether:glowstone_dust", "hl:empty_capsule", "mcl_nether:glowstone_dust"},
		{"mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust"}
	}
})

-- }}}
