function hl.standard_benchmarks_for_component(component_name)
	local benchmarks = {}

	benchmarks.dirt = hl.benchmark_component_against(component_name, "mcl_core:dirt")
	benchmarks.stone = hl.benchmark_component_against(component_name, "mcl_core:stone")
	benchmarks.deepslate = hl.benchmark_component_against(component_name, "mcl_deepslate:deepslate")
	benchmarks.reinforced_brick = hl.benchmark_component_against(component_name, "hl:reinforced_brick")
	benchmarks.obsidian = hl.benchmark_component_against(component_name, "mcl_core:obsidian")
	benchmarks.reinforced_obsidian = hl.benchmark_component_against(component_name, "hl:reinforced_obsidian")

	return benchmarks
end

function hl.benchmark_component_against(component_name, nodename)
	local benchmark = {}
	local ndef = core.registered_nodes[nodename]
	local cdef = hl.registered_loads[component_name]

	core.debug("nodename: ", nodename)
	benchmark.penetration_limit = cdef.hardness / ndef._mcl_hardness

	-- this is a shortened version, after some simplifications
	-- the full formula:
	-- (e / m) / ((nh * k) / m) = (ch / nh)
	-- where:
	-- right side - the penetration limit
	-- left side - the formula for amount of block traveled
	--
	-- e - gas emission needed (this is what we solve for)
	-- m - mass
	-- nh - node hardness
	-- k - the hardness slowing multiplier
	-- ch - component hardness
	benchmark.gas_needed_for_full_utilization = cdef.hardness * hl.hardness_slowing_mul

	return benchmark
end

function hl.render_benchmarks(benchmarks)
	local str = ""

	for benchmark_name, benchmark in pairs(benchmarks) do
		str = str .. benchmark_name .. ":\n"
		str = str .. "\tpenetration " .. benchmark.penetration_limit .. " blocks\n"
		str = str .. "\tgas needed for full utilization " .. benchmark.gas_needed_for_full_utilization .. "\n"
	end

	return str
end
