
local bounce_factor = 0.6
local granade_gravity = -25
local fuse_length = 2

hl.granade_types = {}

function hl.register_granade_type(name, def)
	hl.granade_types[name] = def
	core.register_craftitem(name, {
		description = def.description,
		inventory_image = def.inventory_image,
		stack_max = 16,
		on_secondary_use = function(itemstack, user, pointed_thing)
			local player_look = user:get_look_dir()
			hl.spawn_granade(vector.offset(user:get_pos(), 0, 1.5, 0), vector.multiply(player_look, 10), name)
			if not core.is_creative_enabled(user:get_player_name()) then
				itemstack:take_item()
				return itemstack
			end
		end,
		on_place = function(itemstack, placer, pointed_thing)
			local player_look = placer:get_look_dir()
			hl.spawn_granade(vector.offset(placer:get_pos(), 0, 1.5, 0), vector.multiply(player_look, 10), name)
			if not core.is_creative_enabled(placer:get_player_name()) then
				itemstack:take_item()
				return itemstack
			end
		end,
		on_use = function(itemstack, user, pointed_thing)
			local player_look = user:get_look_dir()
			hl.spawn_granade(vector.offset(user:get_pos(), 0, 1.5, 0), vector.multiply(player_look, 25), name)
			if not core.is_creative_enabled(user:get_player_name()) then
				itemstack:take_item()
				return itemstack
			end
		end
	})
end

core.register_entity("hl:granade", {
	initial_properties = {
		physical = true,
		visual = "mesh",
		mesh = "granade.glb",
		use_texture_aplha = false,
		backface_culling = true,
		pointable = true,
		collisionbox = {-0.1, -0.2, -0.1, 0.1, 0.2, 0.1},
		textures = {"granade.png"},
		static_save = true,
	},

	fuse = fuse_length,
	type = nil,

	explode = function(self)
		local self_pos = self.object:get_pos()
		if self.type then
			hl.granade_types[self.type].func(self_pos)
		end

		core.sound_play(
			{
				name = "granade-explosion"
			},
			{
				pos = self_pos,
				max_hear_distance = 64
			},
			true
		)

		self.object:remove()
	end,

	on_step = function(self, dtime, moveresult)

		if not self.fuse then self.object:remove() end

		self.fuse = self.fuse - dtime

		if self.fuse < 0 then
			self:explode()
			return
		end

		if moveresult.collides then
			if self.explode_on_hit then
				self:explode()
				return
			end

			for _, v in pairs(moveresult.collisions) do
				if v.type == "node" then
					local under = v.node_pos
					local above = vector.round(v.new_pos)

					self.object:set_velocity(vector.multiply(v.old_velocity, vector.multiply(under - above, bounce_factor)))
				end
			end
		end

		self.object:add_velocity(vector.new(0, granade_gravity * dtime, 0))
	end
})

function hl.spawn_granade(pos, velocity, type, explode_on_hit)
	local obj = core.add_entity(pos, "hl:granade")
	local l = obj:get_luaentity()
	l.type = type
	l.explode_on_hit = explode_on_hit
	obj:set_velocity(velocity)
end

hl.register_granade_type("hl:explosive_granade",
{
	func = function(pos)
		mcl_explosions.explode(pos, 3, {})
	end,
	description = "Explosive granade",
	inventory_image = "explosive_granade.png",
})

hl.define_recipe("explosive granade", {
	output = "hl:explosive_granade",
	type = "shapeless",
	recipe = {
		"hl:empty_granade",
		"mcl_tnt:tnt"
	}
})

hl.register_granade_type("hl:shrapnel_granade",
{
	func = function(pos)
		hl.shrapnel_effect(vector.offset(pos, 0, 0.5, 0), 2, 12500)
	end,
	description = "Fragment granade",
	inventory_image = "fragment_granade.png",
})

hl.define_recipe("shrapnel granade", {
	output = "hl:shrapnel_granade",
	type = "shapeless",
	recipe = {
		"hl:empty_granade",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
		"hl:handful_of_shrapnel",
	}
})

hl.register_granade_type("hl:smokescreen_granade",
{
	func = function(pos)
		hl.spawn_smoke(2, 500, vector.offset(pos, 0, 0.5, 0))
	end,
	description = "Smokescreen granade",
	inventory_image = "smokescreen_granade.png",
})

hl.define_recipe("smokescreen granade", {
	output = "hl:smokescreen_granade",
	type = "shapeless",
	recipe = {
		"hl:empty_granade",
		"hl:smokescreen_bottle",
	}
})

hl.register_granade_type("hl:mustard_granade",
{
	func = function(pos)
		hl.spawn_mustard_gas(3, 500, pos)
	end,
	description = "Mustard granade",
	inventory_image = "mustard_granade.png",
})

hl.define_recipe("mustard granade", {
	output = "hl:mustard_granade",
	type = "shapeless",
	recipe = {
		"hl:empty_granade",
		"hl:mustard_bottle",
	}
})

hl.register_granade_type("hl:napalm_granade",
{
	func = function(pos)
		hl.spawn_infernal_flame_explosion(vector.offset(pos, 0, 0.5, 0), 25, 50)
	end,
	description = "Napalm granade",
	inventory_image = "napalm_granade.png",
})

hl.define_recipe("napalm granade", {
	output = "hl:napalm_granade",
	type = "shapeless",
	recipe = {
		"hl:empty_granade",
		"hl:napalm_bottle",
	}
})

hl.register_granade_type("hl:flashbang_granade",
{
	func = function(pos)
		hl.flashbang_effect(vector.offset(pos, 0, 0.5, 0), 1.5)
	end,
	description = "Flashbang granade",
	inventory_image = "flashbang_granade.png",
})

hl.define_recipe("flashbang", {
	output = "hl:flashbang_granade",
	recipe = {
		{"mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust"},
		{"mcl_nether:glowstone_dust", "hl:empty_granade", "mcl_nether:glowstone_dust"},
		{"mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust", "mcl_nether:glowstone_dust"},
	}
})
