local function shoot_bazooka(itemstack, player, pointed_thing)
	local player_look = player:get_look_dir()
	local meta = itemstack:get_meta()
	local load = hl.deserialize_load(meta:get_string("load"))
	hl.process_load(load, vector.round(vector.offset(player:get_pos(), 0, 1.5, 0)), player_look)

	meta:set_string("load", nil)
	return itemstack
end

local function load_bazooka(itemstack, player, pointed_thing)
	local load = hl.read_from_map(pointed_thing)
	itemstack:get_meta():set_string("load", hl.serialize_load(load))
	return itemstack
end

local function shoot_admin_bazooka(itemstack, player, pointed_thing)
	local player_look = player:get_look_dir()
	local meta = itemstack:get_meta()
	local load = hl.deserialize_load(meta:get_string("load"))

	core.debug(hl.get_load_name(load))

	hl.process_load(load, vector.round(vector.offset(player:get_pos(), 0, 1.5, 0)), player_look)
end

local function load_admin_bazooka(itemstack, player, pointed_thing)
	local load = hl.read_from_map(pointed_thing)
	itemstack:get_meta():set_string("load", hl.serialize_load(load))
	return itemstack
end

local function shoot_admin_shotgun_bazooka(itemstack, player, pointed_thing)
	local player_look = player:get_look_dir()
	local meta = itemstack:get_meta()
	local load = hl.deserialize_load(meta:get_string("load"))

	for i = 1, 25 do
		hl.process_load(table.copy(load), vector.round(vector.offset(player:get_pos(), 0, 1.5, 0)), vector.normalize(player_look + vector.random_direction() * 0.4))
	end
end

local function load_admin_shotgun_bazooka(itemstack, player, pointed_thing)
	local load = hl.read_from_map(pointed_thing)
	itemstack:get_meta():set_string("load", hl.serialize_load(load))
	return itemstack
end

core.register_tool("hl:bazooka", {
	description = "Bazooka",
	inventory_image = "bazooka.png",
	on_use = shoot_bazooka,
	on_place = load_bazooka
})

core.register_tool("hl:admin_bazooka", {
	description = "SUPA Bazooka",
	inventory_image = "bazooka.png",
	on_use = shoot_admin_bazooka,
	on_place = load_admin_bazooka
})

core.register_tool("hl:admin_shotgun_bazooka", {
	description = "SUPA SHOTA GONA Bazooka",
	inventory_image = "bazooka.png",
	on_use = shoot_admin_shotgun_bazooka,
	on_place = load_admin_shotgun_bazooka
})

-- core.register_tool("hl:round_maker", {
-- 	description = "Round maker",
-- 	inventory_image = "flamethrower.png",
-- 	on_place = function(itemstack, user, pointed_thing)
-- 		local round_itemstack = ItemStack("hl:1m_round")
-- 		local success
-- 		success, round_itemstack = hl.load_round(round_itemstack, pointed_thing.under, pointed_thing.under - pointed_thing.above)
--
-- 		if success then
-- 			core.add_item(pointed_thing.under, round_itemstack)
-- 		end
-- 	end
-- })

core.register_tool("hl:debug_granade_launcher", {
	description = "Debug granade launcher",
	inventory_image = "flamethrower.png",
	on_secondary_use = function(itemstack, user, pointed_thing)
		local player_look = user:get_look_dir()
		hl.spawn_granade(vector.offset(user:get_pos(), 0, 1.5, 0), vector.multiply(player_look, 25), "flashbang")
	end
})

core.register_tool("hl:artillery_spawner", {
	description = "Artillery spawner",
	inventory_image = "artillery_icon.png",
	on_place = function(itemstack, user, pointed_thing)
		core.add_entity(pointed_thing.above, "hl:artillery")

		if not core.is_creative_enabled(user:get_player_name()) then
			user:set_wielded_item(ItemStack())
		end
	end
})

core.register_tool("hl:fire_blanket", {
	description = "Fire blanket",
	inventory_image = "fire_blanket.png",
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type == "node" then
			local node = core.get_node(pointed_thing.under)

			if node.name == "hl:infernal_flame" and math.random() > 0.75 then
				core.remove_node(pointed_thing.under)
			end
		end
	end
})
