hl = {}

hl.registered_loads = {}

hl.exposive_power_to_push_force_mul = 10
hl.hardness_slowing_mul = 10
hl.shrapnel_explosion_reduction_coefficient = 0.00008
hl.gravity = vector.new(0, 0.5, 0)

-- load invariants
-- a list "components" with a length of at least one. It contains the component definitions
-- a member velocity
-- a member total_weight

-- component definition can contain these members
-- hardness - defines the penetrative strength
-- explosive_power - defines the explosive power
-- weight - the weight
-- activation_point - the explosive_power required to kick start the explosion
-- firing_pin_activated - whether the component can be detonated with a firing pin

local radius_constant = 1 / (2 * math.sqrt(math.pi))
function hl.shrapnel_effect(pos, strength, amount)
	if strength == 0 then return end
	local radius = math.sqrt(amount) * radius_constant

	for obj in core.objects_inside_radius(pos, radius) do
		local obj_pos = obj:get_pos()
		local distance = vector.distance(pos, obj_pos)

		local hit_count = math.floor(amount / (4 * math.pi * distance * distance))
		if hit_count > 0 then
			local rays
			local l = obj:get_luaentity()
			if l then
				local cbox = l.collisionbox
				if cbox then
					-- miny is usually 0, so this avoids it being in the ground
					cbox[2] = cbox[2] + 0.025
					rays = {
						vector.offset(obj_pos, cbox[1], cbox[2], cbox[3]),
						vector.offset(obj_pos, cbox[4], cbox[2], cbox[3]),
						vector.offset(obj_pos, cbox[1], cbox[2], cbox[6]),
						vector.offset(obj_pos, cbox[4], cbox[2], cbox[6]),

						vector.offset(obj_pos, cbox[1], cbox[5], cbox[3]),
						vector.offset(obj_pos, cbox[4], cbox[5], cbox[3]),
						vector.offset(obj_pos, cbox[1], cbox[5], cbox[6]),
						vector.offset(obj_pos, cbox[4], cbox[5], cbox[6]),
					}
				else
					rays = {obj_pos}
				end
			elseif core.is_player(obj) then
				rays = {
					vector.offset(obj_pos, 0, 0.025, 0),
					vector.offset(obj_pos, 0, 1, 0),
					vector.offset(obj_pos, 0, 1.75, 0),
				}
			else
				rays = {obj_pos}
			end

			local direct_shot = true
			for _, ray_pos in pairs(rays) do
				local ray = core.raycast(pos, ray_pos, false, true)
				direct_shot = true
				for pointed_thing in ray do
					if core.get_item_group(core.get_node(pointed_thing.under).name, "solid") > 0 then
						direct_shot = false
						break
					end
				end

				if direct_shot then
					break
				end
			end

			if direct_shot then
				-- TODO: the hit count var can get very big when close, it needs to be somehow capped...
				-- But i don't know how to without reducing the range
				mcl_util.deal_damage(obj, hit_count * strength, {type = "generic"})
			end
		end
	end
end


function hl.register_load_component(name, def)
	def.name = name
	def.activation_point = def.activation_point or math.huge
	def.explosive_power = def.explosive_power or 0
	def.hardness = def.hardness or 0
	def.butter_factor = def.butter_factor or 0
	def.break_on_explode = def.break_on_explode or false
	-- def.explosion_modifiers = {}
	-- def.shrapnel = def.shrapnel or 0
	-- def.smokescreen = def.smokescreen or 0
	-- def.mustard_gas = def.mustard_gas or 0
	-- def.napalm = def.napalm or 0
	def.codename = def.codename or "XXX"
	def.on_break = def.on_break or function(self, pos, load) end
	def.on_activate = def.on_activate or function(self, pos, load) end
	def.on_step = def.on_step or function(self, pos, load, current_node) end
	hl.registered_loads[name] = def
end

function hl.create_empty_load()
	return {
		components = {},
		velocity = vector.new(0, 0, 0),
		total_weight = 0,
	}
end

function hl.read_from_map(pointed_thing)
	if pointed_thing.type ~= "node" then return end

	local load = hl.create_empty_load()
	local iterator = vector.copy(pointed_thing.under)
	local dir = pointed_thing.under - pointed_thing.above
	while true do
		local node = core.get_node(iterator)

		local component_def = hl.registered_loads[node.name]
		if component_def then
			table.insert(load.components, table.copy(component_def))
			load.total_weight = load.total_weight + component_def.weight
			core.remove_node(iterator)
		else
			return load
		end

		iterator = iterator + dir
	end
end

function hl.get_load_weight(load)
	local weight = 0
	for _, component in pairs(load.components) do
		weight = weight + component.weight
	end
	return weight
end

function hl.process_load(load, pos, dir)
	-- local load_pos = vector.offset(vector.floor(pos), -0.5, -0.5, -0.5)
	local load_pos = pos
	local current_node
	local load_dir = dir
	-- This records the whole trajectory, but only the last few nodes are needed (#load.components when at 0 velocity)
	local node_history = {}

	local function combust(idx)
		if idx ~= 1 then
			error("not implemented... Splitting loads IS NOT ALLOWED")
		end

		local component = table.remove(load.components, idx)

		if not component.gas_emission then
			-- nah, fuck you
			-- look at what you made me do... This code is terrible
			table.insert(load.components, 1, component)
			return
		end

		load.total_weight = load.total_weight - component.weight
		load.velocity = load.velocity + vector.multiply(load_dir, component.gas_emission / load.total_weight)

		if load.components[idx] and load.components[idx].combustible then
			combust(idx)
		end
	end

	local function head()
		return load.components[#load.components]
	end

	local function too_little_speed_epilogue()
		core.debug("Speed failure")
		for i = 0, math.min(#load.components - 1, #node_history) do
			core.set_node(node_history[#node_history - i], {name = load.components[#load.components - i].name})
		end

	end

	local function fancy_round(val, dir_sign)
		local frac = math.abs(val - math.floor(val))
		if frac > 0.5 then
			return math.floor(val) + 1
		elseif frac < 0.5 then
			return math.floor(val)
		else
			if dir_sign > 0 then
				return val + 0.5
			else
				return val - 0.5
			end
		end
	end

	local function explode_component(idx)
		-- if idx ~= #load.components then
		-- 	error("Not implemented")
		-- end

		-- core.add_particle({
		-- 	pos = load_pos,
		-- 	expirationtime = 10,
		-- 	texture = "marker.png",
		-- 	size = 10,
		-- 	glow = 14,
		-- })

		local c = load.components[idx]
		local explosive_power = c.explosive_power
		local explosion_modifiers = {}
		-- local shrapnel = c.shrapnel
		-- local smokescreen = c.smokescreen
		-- local mustard_gas = c.mustard_gas
		-- local napalm = c.napalm
		local to_be_removed = {idx}

		local function propagate_explosion(idx, direction)
			if idx < 1 or idx > #load.components then
				return false, math.max(math.min(idx, #load.components), 1) -- XDDD
			end

			local cdef = load.components[idx]
			if cdef.activation_point <= explosive_power or cdef.explosion_modifiers then
				explosive_power = explosive_power + cdef.explosive_power
				-- shrapnel = shrapnel + cdef.shrapnel
				-- smokescreen = smokescreen + cdef.smokescreen
				-- mustard_gas = mustard_gas + cdef.mustard_gas
				-- napalm = napalm + cdef.napalm
				if cdef.explosion_modifiers then
					for _, v in pairs(cdef.explosion_modifiers) do
						-- core.debug(dump(cdef.explosion_modifiers), (explosion_modifiers[v.name] or 0), v.amount, dump(v))
						explosion_modifiers[v.name] = (explosion_modifiers[v.name] or 0) + v.amount
					end
				end
				table.insert(to_be_removed, idx)
				return propagate_explosion(idx + direction, direction)
			else
				return true, idx - 1
			end
		end

		local is_propagation_hot = true
		local back_idx = idx
		local front_idx = idx
		local did_frontal_propagation_do_anything
		local did_backwards_propagation_do_anything
		while is_propagation_hot do
			-- core.debug(front_idx, back_idx)
			did_frontal_propagation_do_anything, front_idx = propagate_explosion(front_idx + 1, 1)
			did_backwards_propagation_do_anything, back_idx = propagate_explosion(back_idx - 1, -1)

			-- core.debug(did_backwards_propagation_do_anything, did_frontal_propagation_do_anything)
			is_propagation_hot = did_frontal_propagation_do_anything ~= did_backwards_propagation_do_anything
		end

		load.components = hl.helpers.table_bulk_remove(load.components, to_be_removed)
		-- core.debug(dump(load.components))

		local modifier_explosion_reduction_amount = 0
		for modifier_name, total in pairs(explosion_modifiers) do
			modifier_explosion_reduction_amount = modifier_explosion_reduction_amount + hl.registered_explosion_modifiers[modifier_name].explosion_reduction_multiplier * total
		end

		core.remove_node(load_pos)
		mcl_explosions.explode(load_pos, explosive_power - modifier_explosion_reduction_amount, {})

		for modifier_name, total in pairs(explosion_modifiers) do
			hl.registered_explosion_modifiers[modifier_name].process(load_pos, explosive_power - modifier_explosion_reduction_amount, total)
		end
		-- if shrapnel ~= 0 then
		-- 	shrapnel_effect(explosive_power, shrapnel)
		-- end
		--
		-- if smokescreen ~= 0 then
		-- 	hl.spawn_smoke(explosive_power, smokescreen, load_pos)
		-- end
		--
		-- if mustard_gas ~= 0 then
		-- 	hl.spawn_mustard_gas(explosive_power, mustard_gas, load_pos)
		-- end
		--
		-- if napalm ~= 0 then
		-- 	hl.spawn_infernal_flame_explosion(load_pos, explosive_power * 2, napalm)
		-- end
	end

	local function step_all_components()
		for i, v in pairs(load.components) do
			if v.on_step then
				local result = v.on_step(v, load_pos, load, current_node)

				if result == "explode" then
					explode_component(i)

					if #load.components == 0 then
						return false
					end
				end
			end
		end

		return true
	end

	local function brrrr()
		local frustration = 10000
		local time_passed = 0
		while vector.length(load.velocity) > 0 and frustration > 0 do
			current_node = core.get_node(load_pos)
			local ndef = core.registered_nodes[current_node.name]

			local node_hardness = ndef._mcl_hardness or 0

			local head_c = head()
			local resistance_vector = (vector.multiply(load_dir, node_hardness * hl.hardness_slowing_mul / load.total_weight))

			if time_passed > 0.05 then
				resistance_vector = resistance_vector + hl.gravity
			end

			if vector.length(resistance_vector) > vector.length(load.velocity) then
				too_little_speed_epilogue()
				break
			end

			load.velocity = load.velocity - resistance_vector
			load_dir = vector.normalize(load.velocity)
			head_c.hardness = head_c.hardness - node_hardness

			if head_c.hardness < 0 then
				local result = head_c:on_break(load_pos, load)

				if result == "explode" then
					explode_component(#load.components)
				else
					table.remove(load.components, #load.components)
				end

				if #load.components == 0 then
					break
				end
			end

			-- core.debug("TIME", time_passed)

			local rounded_load_pos = vector.copy(load_pos)
			rounded_load_pos.x = fancy_round(rounded_load_pos.x, load.velocity.x)
			rounded_load_pos.y = fancy_round(rounded_load_pos.y, load.velocity.y)
			rounded_load_pos.z = fancy_round(rounded_load_pos.z, load.velocity.z)

			-- TODO: make sure this doesn't ignore the hardness of the block after the last head broke
			core.remove_node(rounded_load_pos)

			local velocity_normalized = vector.normalize(load.velocity)

			local next_x = fancy_round(load_pos.x, velocity_normalized.x) + math.sign(velocity_normalized.x) * 0.5
			local x_diff = next_x - load_pos.x
			local x_offset_vec = velocity_normalized * (x_diff / velocity_normalized.x)
			-- believe this or not. But the negation in this condition is crtical and completely changes the behaviour
			-- Weird huh?
			-- apparently math.inf when interpreted as a conditional, will return false. Breaking our tetriary operator
			local x_length = velocity_normalized.x ~= 0 and vector.length(x_offset_vec) or math.huge

			local next_y = fancy_round(load_pos.y, velocity_normalized.y) + math.sign(velocity_normalized.y) * 0.5
			local y_diff = next_y - load_pos.y
			local y_offset_vec = velocity_normalized * (y_diff / velocity_normalized.y)
			local y_length = velocity_normalized.y ~= 0 and vector.length(y_offset_vec) or math.huge

			local next_z = fancy_round(load_pos.z, velocity_normalized.z) + math.sign(velocity_normalized.z) * 0.5
			local z_diff = next_z - load_pos.z
			local z_offset_vec = velocity_normalized * (z_diff / velocity_normalized.z)
			local z_length = velocity_normalized.z ~= 0 and vector.length(z_offset_vec) or math.huge

			table.insert(node_history, load_pos)
			local continue = step_all_components()

			if not continue then
				break
			end

			-- core.add_particle({
			-- 	pos = load_pos,
			-- 	expirationtime = 10,
			-- 	texture = "marker.png",
			-- 	size = 4,
			-- 	glow = 14,
			-- })

			if z_length < y_length then
				if z_length < x_length then
					load_pos = load_pos + z_offset_vec
					time_passed = time_passed + z_length / vector.length(load.velocity)
				else
					load_pos = load_pos + x_offset_vec
					time_passed = time_passed + x_length / vector.length(load.velocity)
				end
			else
				if y_length < x_length then
					load_pos = load_pos + y_offset_vec
					time_passed = time_passed + y_length / vector.length(load.velocity)
				else
					load_pos = load_pos + x_offset_vec
					time_passed = time_passed + x_length / vector.length(load.velocity)
				end
			end

			-- This is so retarded..
			-- local remember = vector.floor(load_pos)
			-- while vector.floor(load_pos) == remember do
			-- 	load_pos = load_pos + load_dir
			-- end
			frustration = frustration - 1
		end
		-- will this even ever fallthrough?
	end

	for _, v in pairs(load.components) do
		v.on_activate(v, pos, load)
	end

	combust(1)

	if #load.components == 0 then return end

	brrrr()
	core.debug(load_pos, #node_history)
end

function hl.serialize_load(load)
	for i = 1, #load.components do
		load.components[i] = load.components[i].name
	end
	return core.serialize(load)
end

function hl.deserialize_load(load_string)
	local load = core.deserialize(load_string)
	for i = 1, #load.components do
		load.components[i] = table.copy(hl.registered_loads[load.components[i]])
	end

	return load
end

function hl.get_load_name(load)
	local name_buffer = {}

	local components = load.components
	local prev_component_codename
	local repeat_count
	local gas_emission = 0

	local function flush_previous()
		if not prev_component_codename then return end

		if repeat_count ~= 1 then
			table.insert(name_buffer, tostring(repeat_count))
		end

		table.insert(name_buffer, tostring(prev_component_codename))
		table.insert(name_buffer, ".")
		repeat_count = 1
	end

	for i = #components, 1, -1 do
		local cdef = components[i]
		gas_emission = gas_emission + (cdef.gas_emission or 0)
		if not prev_component_codename then
			repeat_count = 1
		elseif cdef.codename == prev_component_codename then
			repeat_count = repeat_count + 1
		else
			flush_previous()
		end

		if cdef.gas_emission then
			prev_component_codename = nil
		else
			prev_component_codename = cdef.codename
		end
	end

	flush_previous()

	table.insert(name_buffer, tostring(gas_emission))

	return table.concat(name_buffer)
end


local recipes = {}
-- This function exists so that in the future mods can disable the default recipes, so they can define their own
function hl.define_recipe(name, def)
	recipes[name] = def
	-- core.register_craft(def)
end

dofile(core.get_modpath("hl") .. "/src/defs/mcl.lua")
dofile(core.get_modpath("hl") .. "/src/tools.lua")
dofile(core.get_modpath("hl") .. "/src/cmd.lua")

dofile(core.get_modpath("hl") .. "/src/components/explosives.lua")
dofile(core.get_modpath("hl") .. "/src/components/explosion_modifiers.lua")
dofile(core.get_modpath("hl") .. "/src/components/fuses.lua")
dofile(core.get_modpath("hl") .. "/src/components/penetration_components.lua")
dofile(core.get_modpath("hl") .. "/src/components/misc_components.lua")
dofile(core.get_modpath("hl") .. "/src/components/propellants.lua")


dofile(core.get_modpath("hl") .. "/src/building_blocks.lua")
dofile(core.get_modpath("hl") .. "/src/benchmark.lua")
dofile(core.get_modpath("hl") .. "/src/gasses.lua")
dofile(core.get_modpath("hl") .. "/src/infernal_flame.lua")
dofile(core.get_modpath("hl") .. "/src/helpers.lua")
dofile(core.get_modpath("hl") .. "/src/rounds.lua")
dofile(core.get_modpath("hl") .. "/src/artillery.lua")
dofile(core.get_modpath("hl") .. "/src/granade.lua")
dofile(core.get_modpath("hl") .. "/src/flashbang.lua")
dofile(core.get_modpath("hl") .. "/src/craftitems.lua")
dofile(core.get_modpath("hl") .. "/src/gas_mask.lua")
dofile(core.get_modpath("hl") .. "/src/flamethrower.lua")
dofile(core.get_modpath("hl") .. "/src/landmines.lua")
dofile(core.get_modpath("hl") .. "/src/granade_launcher.lua")

local function load_mod_integration(modname)
	if core.get_modpath(modname) then
		dofile(core.get_modpath("hl") .. "/src/integrations/" .. modname .. ".lua")
	end
end

load_mod_integration("builders_wand")
load_mod_integration("elepower_dynamics")

for _, v in pairs(recipes) do
	core.register_craft(v)
end
