local flashbang_radius_multiplier = 75
local flashbang_time_multiplier = 10
local player_flashbangs = {}

function hl.flashbang_effect(pos, strength)
	local radius = strength * flashbang_radius_multiplier
	for obj in core.objects_inside_radius(pos, radius) do
		if core.is_player(obj) then
			local player_pos = vector.offset(obj:get_pos(), 0, 1.5, 0)
			local pos_diff = pos - player_pos
			local player_look = obj:get_look_dir()
			local similarity = vector.distance(player_look, vector.normalize(pos_diff))

			-- add HUD that covers the screen

			local ray = core.raycast(pos, player_pos, true, false)
			local obstructed = false

			for pointed_thing in ray do
				if pointed_thing.type == "object" and pointed_thing.ref ~= obj then
					obstructed = true
					break
				elseif pointed_thing.type == "node" then
					local node = core.get_node(pointed_thing.under)
					local ndef = core.registered_nodes[node.name]

					if ndef.walkable then
						obstructed = true
						break
					end

				end
			end

			if not obstructed then

				local flash_strength = strength * (1 - vector.distance(player_pos, pos) / radius) * math.abs(1 - similarity / 2)

				if player_flashbangs[obj] and player_flashbangs[obj].time > flash_strength * flashbang_time_multiplier then
					return
				end

				local sound_handler = core.sound_play(
					{
						name = "flashbang"
					},
					{
						to_player = obj:get_player_name(),
						object = obj,
						loop = true
					}
				)

				core.sound_fade(sound_handler, 1 / (flash_strength * flashbang_time_multiplier), 0)

				local hud_id = obj:hud_add({
					type = "image",
					name = "flashbang flash",
					text = "flashbang_overlay.png",
					scale = {x = 10000, y = 10000}, -- that ought to be enough
					position = {x = 0, y = 0},
					alignment = {x = 1, y = 1},
					z_index = 99999
				})

				if player_flashbangs[obj] then
					if player_flashbangs[obj].time < flash_strength * flashbang_time_multiplier then
						obj:hud_remove(player_flashbangs[obj].hud_id)
						player_flashbangs[obj] = {
							time = flash_strength * flashbang_time_multiplier,
							full_time = strength * flashbang_time_multiplier,
							hud_id = hud_id
						}
					end
				else
					player_flashbangs[obj] = {
						time = flash_strength * flashbang_time_multiplier,
						full_time = strength * flashbang_time_multiplier,
						hud_id = hud_id
					}
				end
			end
		end
	end
end

core.register_globalstep(function(dtime)
	for player, data in pairs(player_flashbangs) do
		local new_time = data.time - dtime

		if new_time < 0 then
			player:hud_remove(data.hud_id)
			player_flashbangs[player] = nil
		else
			player:hud_change(
				data.hud_id,
				"text",
				string.format(
					"flashbang_overlay.png^[opacity:%s",
					-- MATHHHHHHHHH
					-- y = (peak / t^2) * (t - x)^2 + peak
					-- where:
					-- peak - 255 in our case
					-- t = full time of the fuse
					-- x = fuse remaining
					math.floor(- (255/math.pow(data.full_time, 2)) * math.pow(data.full_time - data.time, 2) + 255)
				)
			)
			data.time = new_time
		end
	end
end)
